/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.DataViewer;
import org.yamcs.ui.archivebrowser.IndexBox;
import org.yamcs.ui.archivebrowser.Selection;
import org.yamcs.ui.archivebrowser.TMScale;
import org.yamcs.ui.archivebrowser.TagBox;
import org.yamcs.ui.archivebrowser.ZoomSpec;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.TimeInterval;

public class DataView
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    HeaderPanel headerPanel;
    IndexPanel indexPanel;
    Map<String, IndexBox> indexBoxes = new HashMap<String, IndexBox>();
    private boolean showTagBox = true;
    Stack<ZoomSpec> zoomStack = new Stack();
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private DataViewer dataViewer;
    ArchivePanel archivePanel;
    boolean hideResponsePackets = true;
    long lastStartTimestamp = -1L;
    long lastEndTimestamp = -1L;
    boolean startColor = false;
    int startX;
    int stopX;
    int deltaX;
    boolean drawPreviewLocator;
    float previewLocatorAlpha;
    int dragButton;
    int previewLocatorX;
    int mouseLocatorX;
    SelectionImpl currentSelection;
    long startLocator;
    long stopLocator;
    long currentLocator;
    long previewLocator;
    long seekLocator;
    final long DO_NOT_DRAW = Long.MIN_VALUE;
    final int handleWidth = 6;
    final int handleHeight = 12;
    final int handleWidth2 = 9;
    final int cursorSnap = 2;
    final Color handleFill = Color.YELLOW;
    final Color currentFill = Color.GREEN;
    int antsOffset = 0;
    final int antsLength = 8;

    public DataView(ArchivePanel archivePanel, DataViewer dataViewer) {
        super(20, 30);
        this.dataViewer = dataViewer;
        this.archivePanel = archivePanel;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getViewport().setOpaque(false);
        this.setPreferredSize(new Dimension(850, 400));
        this.headerPanel = new HeaderPanel();
        this.indexPanel = new IndexPanel();
        this.setColumnHeaderView(this.headerPanel);
        this.setViewportView(this.indexPanel);
        this.getColumnHeader().setOpaque(false);
        this.currentLocator = Long.MIN_VALUE;
        this.stopLocator = Long.MIN_VALUE;
        this.startLocator = Long.MIN_VALUE;
        this.drawPreviewLocator = false;
        this.resetSelection();
        new Timer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (DataView.this.getComponentCount() > 0) {
                        int y = DataView.this.getComponent((int)0).getLocation().y;
                        int h = DataView.this.getSize().height - y;
                        if (DataView.this.currentSelection != null) {
                            if (++DataView.this.antsOffset >= 8) {
                                DataView.this.antsOffset = 0;
                                DataView.this.startColor = !DataView.this.startColor;
                            }
                            int x1 = DataView.this.currentSelection.getStartX();
                            int x2 = DataView.this.currentSelection.getStopX();
                            DataView.this.repaint(0L, x1, y, x2 - x1 + 1, h);
                        }
                    }
                    if (DataView.this.drawPreviewLocator) {
                        DataView.this.repaint();
                        DataView.this.previewLocatorAlpha -= 0.05f;
                        DataView.this.drawPreviewLocator = DataView.this.previewLocatorAlpha > 0.0f;
                    }
                }
            }
        }, 1000L, 150L);
        ToolTipManager ttmgr = ToolTipManager.sharedInstance();
        ttmgr.setInitialDelay(0);
        ttmgr.setReshowDelay(0);
        ttmgr.setDismissDelay(Integer.MAX_VALUE);
        this.setOpaque(false);
    }

    public void addIndex(String tableName, String name, long mergeTime) {
        IndexBox indexBox = new IndexBox(this, name);
        indexBox.setAlignmentX(0.0f);
        indexBox.setMergeTime(mergeTime);
        this.indexBoxes.put(tableName, indexBox);
        this.indexPanel.add(indexBox);
    }

    public void addVerticalGlue() {
        this.indexPanel.add(Box.createVerticalGlue());
    }

    public void refreshDisplay() {
        this.refreshDisplay(false);
    }

    public void refreshDisplay(boolean force) {
        int panelw = this.getViewport().getExtentSize().width;
        if (!this.zoomStack.empty()) {
            ZoomSpec zoom = this.zoomStack.peek();
            if (panelw > zoom.getPixels() || force) {
                zoom.setPixels(panelw);
            }
            panelw = zoom.getPixels();
            this.headerPanel.scale.setToZoom(zoom);
            if (this.showTagBox) {
                this.headerPanel.tagBox.setToZoom(zoom);
            } else {
                this.headerPanel.tagBox.removeAll();
            }
            for (IndexBox ib : this.indexBoxes.values()) {
                ib.setToZoom(zoom);
            }
        }
        this.headerPanel.scale.setMaximumSize(new Dimension(panelw, this.headerPanel.scale.getPreferredSize().height));
        this.headerPanel.scale.setMinimumSize(this.headerPanel.scale.getMaximumSize());
        this.headerPanel.scale.setPreferredSize(this.headerPanel.scale.getMaximumSize());
        this.headerPanel.scale.setSize(this.headerPanel.scale.getMaximumSize());
    }

    void setPointer(MouseEvent e) {
        if (this.archivePanel.prefs.reloadButton.isEnabled()) {
            this.setNormalPointer();
            if (this.currentSelection != null) {
                if (Math.abs(e.getX() - this.currentSelection.getStartX()) <= 2) {
                    this.setMoveLeftPointer();
                }
                if (Math.abs(e.getX() - this.currentSelection.getStopX()) <= 2) {
                    this.setMoveRightPointer();
                }
            }
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(event.getX() - 94, event.getY() + 20);
    }

    long getMouseInstant(MouseEvent e) {
        if (this.zoomStack.isEmpty()) {
            return Long.MIN_VALUE;
        }
        this.previewLocator = this.zoomStack.peek().convertPixelToInstant(e.getX());
        return this.previewLocator;
    }

    void setMouseLabel(MouseEvent e) {
        long instant = this.getMouseInstant(e);
        if (instant == Long.MIN_VALUE) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(TimeEncoding.toCombinedFormat((long)instant));
        }
        this.dataViewer.signalMousePosition(instant);
    }

    public void zoomIn() {
        long stopInstant;
        long startInstant;
        ZoomSpec zoom = this.zoomStack.peek();
        JViewport vp = this.getViewport();
        zoom.viewLocation = zoom.convertPixelToInstant(vp.getViewPosition().x);
        if (this.currentSelection == null) {
            int extentWidth = vp.getExtentSize().width;
            int nextStartX = vp.getViewPosition().x + extentWidth / 3;
            int nextStopX = nextStartX + extentWidth / 3;
            startInstant = zoom.convertPixelToInstant(nextStartX);
            stopInstant = zoom.convertPixelToInstant(nextStopX);
            zoom.setSelectedRange(Long.MIN_VALUE, Long.MIN_VALUE);
        } else {
            startInstant = this.currentSelection.getStartInstant();
            stopInstant = this.currentSelection.getStopInstant();
            zoom.setSelectedRange(startInstant, stopInstant);
        }
        long range = stopInstant - startInstant;
        TimeInterval requestedInterval = this.archivePanel.getRequestedDataInterval();
        long zstart = startInstant - range * 2L;
        if (requestedInterval.hasStart()) {
            zstart = Math.max(zstart, requestedInterval.getStart());
        }
        long zstop = stopInstant + range * 2L;
        if (requestedInterval.hasEnd()) {
            zstop = Math.min(zstop, requestedInterval.getEnd());
        }
        zoom = new ZoomSpec(zstart, zstop, vp.getExtentSize().width, range);
        zoom.viewLocation = startInstant;
        this.zoomStack.push(zoom);
        this.resetSelection();
        this.refreshDisplay();
        this.setViewLocationFromZoomstack();
    }

    void setViewLocationFromZoomstack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataView.this.zoomStack.isEmpty()) {
                    return;
                }
                ZoomSpec currentZoom = DataView.this.zoomStack.peek();
                JViewport vp = DataView.this.getViewport();
                int x = (int)((double)(currentZoom.viewLocation - currentZoom.startInstant) / currentZoom.pixelRatio);
                vp.setViewPosition(new Point(x, vp.getViewPosition().y));
            }
        });
    }

    public void archiveLoadFinished() {
        for (IndexBox ib : this.indexBoxes.values()) {
            ib.dataLoadFinished();
        }
        if (this.zoomStack.isEmpty() || this.archivePanel.prefs.getStartTimestamp() != this.lastStartTimestamp || this.archivePanel.prefs.getEndTimestamp() != this.lastEndTimestamp) {
            int w = this.getViewport().getExtentSize().width;
            this.zoomStack.clear();
            TimeInterval receivedDataInterval = this.archivePanel.getReceivedDataInterval();
            TimeInterval requestedDataInterval = this.archivePanel.getRequestedDataInterval();
            long zstart = receivedDataInterval.getStart();
            if (requestedDataInterval.hasStart()) {
                zstart = Math.min(requestedDataInterval.getStart(), zstart);
            }
            long zstop = receivedDataInterval.getEnd();
            if (requestedDataInterval.hasEnd()) {
                zstop = Math.max(requestedDataInterval.getEnd(), zstop);
            }
            long range = zstop - zstart;
            this.zoomStack.push(new ZoomSpec(zstart -= range / 100L, zstop += range / 100L, w, zstop - zstart));
        }
        this.lastStartTimestamp = this.archivePanel.prefs.getStartTimestamp();
        this.lastEndTimestamp = this.archivePanel.prefs.getEndTimestamp();
        SwingUtilities.invokeLater(() -> {
            this.dataViewer.zoomInButton.setEnabled(true);
            this.dataViewer.zoomOutButton.setEnabled(false);
            this.dataViewer.showAllButton.setEnabled(true);
            this.refreshDisplay();
        });
    }

    void emitActionEvent(String cmd) {
        ActionEvent ae = new ActionEvent(this, 1001, cmd);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }

    void emitActionEvent(ActionEvent ae) {
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }

    void showAll() {
        while (this.zoomStack.size() > 1) {
            this.zoomStack.pop();
        }
        this.resetSelection();
        this.refreshDisplay(true);
        this.setViewLocationFromZoomstack();
    }

    void zoomOut() {
        if (this.zoomStack.size() > 1) {
            this.zoomStack.pop();
            ZoomSpec zoom = this.zoomStack.peek();
            if (zoom.selectionStart != Long.MIN_VALUE && zoom.selectionStop != Long.MIN_VALUE) {
                this.updateSelection(zoom.selectionStart, zoom.selectionStop);
                this.dataViewer.signalSelectionChange(this.currentSelection);
            }
            this.refreshDisplay();
            this.setViewLocationFromZoomstack();
        }
    }

    public void doMouseDragged(MouseEvent e) {
        this.indexPanel.doMouseDragged(e);
        this.dispatchEvent(new MouseEvent(e.getComponent(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
    }

    public void doMouseMoved(MouseEvent e) {
        this.headerPanel.doMouseMoved(e);
        this.setMouseLabel(e);
        this.setPointer(e);
    }

    public void doMousePressed(MouseEvent e) {
        this.indexPanel.doMousePressed(e);
    }

    public void doMouseReleased(MouseEvent e) {
        this.indexPanel.doMouseReleased(e);
    }

    public void doMouseExited(MouseEvent e) {
        this.dataViewer.signalMousePosition(Long.MIN_VALUE);
        this.mouseLocatorX = -1;
        this.repaint();
    }

    public void updateSelection(Long selectionStart, Long selectionStop) {
        if (!this.archivePanel.passiveUpdate && selectionStart != null && selectionStop != null) {
            long start = selectionStart;
            long stop = selectionStop;
            if (start != Long.MIN_VALUE && stop != Long.MIN_VALUE) {
                this.updateSelection(start, stop);
                this.emitActionEvent("histo_selection_finished");
            }
        }
    }

    public void selectionFinished() {
        for (String name : this.indexBoxes.keySet()) {
            this.emitActionEvent(name + "_selection_finished");
        }
    }

    void updateSelectionFields() {
        this.archivePanel.passiveUpdate = true;
        this.dataViewer.signalSelectionChange(this.currentSelection);
        this.archivePanel.passiveUpdate = false;
    }

    public List<String> getSelectedPackets(String type) {
        return this.indexBoxes.get(type).getPacketsForSelection(this.getSelection());
    }

    public void selectedTag(Yamcs.ArchiveTag tag) {
        this.archivePanel.passiveUpdate = true;
        if (tag.hasStart()) {
            this.dataViewer.signalSelectionStartChange(tag.getStart());
        } else {
            this.dataViewer.signalSelectionStartChange(this.archivePanel.getReceivedDataInterval().getStart());
        }
        this.archivePanel.passiveUpdate = false;
        if (tag.hasStop()) {
            this.dataViewer.signalSelectionStopChange(tag.getStop());
        } else {
            this.dataViewer.signalSelectionStopChange(this.archivePanel.getReceivedDataInterval().getStart());
        }
    }

    public void setMoveLeftPointer() {
        this.setCursor(Cursor.getPredefinedCursor(10));
    }

    public void setMoveRightPointer() {
        this.setCursor(Cursor.getPredefinedCursor(11));
    }

    public void setBusyPointer() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setNormalPointer() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void setStartLocator(long position) {
        this.startLocator = position;
    }

    void setStopLocator(long position) {
        this.stopLocator = position;
    }

    void setCurrentLocator(long position) {
        this.currentLocator = position;
        this.repaint();
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void resetSelection() {
        this.startX = -1;
        this.currentSelection = null;
        this.dataViewer.signalSelectionChange(null);
        this.repaint();
        this.emitActionEvent("selection_reset");
    }

    public SelectionImpl getSelection() {
        return this.currentSelection;
    }

    void updateSelection(long start, long stop) {
        if (this.currentSelection == null) {
            this.currentSelection = new SelectionImpl(start, stop);
        } else {
            this.currentSelection.set(start, stop);
        }
        this.startX = this.currentSelection.getStartX();
        this.stopX = this.currentSelection.getStopX();
        this.repaint();
    }

    public class IndexPanel
    extends Box {
        public IndexPanel() {
            super(1);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
        }

        public void doMousePressed(MouseEvent e) {
            if (DataView.this.zoomStack.isEmpty()) {
                return;
            }
            DataView.this.dragButton = e.getButton();
            if (DataView.this.dragButton == 1) {
                if (((DataView)DataView.this).dataViewer.replayEnabled && e.getClickCount() == 2) {
                    DataView.this.drawPreviewLocator = true;
                    DataView.this.previewLocatorAlpha = 0.8f;
                    DataView.this.previewLocatorX = e.getX();
                    DataView.this.archivePanel.seekReplay(DataView.this.previewLocator);
                    this.repaint();
                } else if (DataView.this.currentSelection != null && Math.abs(e.getX() - DataView.this.currentSelection.getStartX()) <= 2) {
                    DataView.this.deltaX = e.getX() - DataView.this.currentSelection.getStartX();
                    DataView.this.startX = DataView.this.currentSelection.getStopX();
                    this.doMouseDragged(e);
                } else if (DataView.this.currentSelection != null && Math.abs(e.getX() - DataView.this.currentSelection.getStopX()) <= 2) {
                    DataView.this.deltaX = e.getX() - DataView.this.currentSelection.getStopX();
                    DataView.this.startX = DataView.this.currentSelection.getStartX();
                    this.doMouseDragged(e);
                } else {
                    DataView.this.resetSelection();
                    this.doMouseDragged(e);
                }
            }
        }

        public void doMouseReleased(MouseEvent e) {
            if (!DataView.this.zoomStack.isEmpty() && e.getButton() == 1 && DataView.this.currentSelection != null) {
                if (DataView.this.startX == DataView.this.stopX) {
                    DataView.this.resetSelection();
                    DataView.this.updateSelectionFields();
                } else {
                    DataView.this.selectionFinished();
                }
            }
        }

        void doMouseDragged(MouseEvent e) {
            if (!DataView.this.zoomStack.isEmpty() && DataView.this.dragButton == 1) {
                DataView.this.stopX = e.getX() - DataView.this.deltaX;
                if (DataView.this.startX == -1) {
                    DataView.this.startX = DataView.this.stopX;
                }
                if (DataView.this.currentSelection == null) {
                    DataView.this.currentSelection = new SelectionImpl(DataView.this.startX, DataView.this.stopX);
                } else {
                    DataView.this.currentSelection.set(DataView.this.startX, DataView.this.stopX);
                }
                DataView.this.setMouseLabel(e);
                DataView.this.setPointer(e);
                this.repaint();
                DataView.this.updateSelectionFields();
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.getComponentCount() > 0 && !DataView.this.zoomStack.isEmpty()) {
                ZoomSpec zoom = DataView.this.zoomStack.peek();
                int h = this.getHeight();
                if (DataView.this.currentSelection != null) {
                    int offset = DataView.this.antsOffset - 8;
                    int x1 = DataView.this.currentSelection.getStartX();
                    int x2 = DataView.this.currentSelection.getStopX();
                    int yend = h;
                    boolean color = DataView.this.startColor;
                    g.setColor(new Color(224, 234, 242, 64));
                    g.fillRect(x1, 0, x2 - x1 + 1, h);
                    for (int y1 = offset; y1 < yend; y1 += 8) {
                        int y2 = y1 + 7;
                        if (y2 >= yend) {
                            y2 = yend - 1;
                        }
                        color = !color;
                        g.setColor(color ? Color.BLACK : Color.WHITE);
                        g.drawLine(x1, y1, x1, y2);
                        g.drawLine(x2, y1, x2, y2);
                    }
                }
                if (DataView.this.startLocator != Long.MIN_VALUE || DataView.this.stopLocator != Long.MIN_VALUE || DataView.this.currentLocator != Long.MIN_VALUE || DataView.this.drawPreviewLocator) {
                    int x;
                    int xmax = this.getSize().width - 6;
                    if (DataView.this.startLocator != Long.MIN_VALUE && (x = zoom.convertInstantToPixel(DataView.this.startLocator)) >= 0 && x < xmax) {
                        int[] px = new int[]{x, x + 6, x};
                        int[] py = new int[]{12, 6, 0};
                        g.setColor(DataView.this.handleFill);
                        g.fillPolygon(px, py, px.length);
                        g.setColor(Color.BLACK);
                        g.drawPolygon(px, py, px.length);
                        g.drawLine(x, 0, x, h - 1);
                    }
                    if (DataView.this.stopLocator != Long.MIN_VALUE && (x = zoom.convertInstantToPixel(DataView.this.stopLocator)) >= 0 && x < xmax) {
                        int[] px = new int[]{x, x - 6, x};
                        int[] py = new int[]{12, 6, 0};
                        g.setColor(DataView.this.handleFill);
                        g.fillPolygon(px, py, px.length);
                        g.setColor(Color.BLACK);
                        g.drawPolygon(px, py, px.length);
                        g.drawLine(x, 0, x, 0 + h - 1);
                    }
                    if (DataView.this.currentLocator != Long.MIN_VALUE && (x = zoom.convertInstantToPixel(DataView.this.currentLocator)) >= 0 && x < xmax) {
                        int[] px = new int[]{x - 4, x, x + 4};
                        int[] py = new int[]{12, 0, 12};
                        g.setColor(DataView.this.currentFill);
                        g.fillPolygon(px, py, px.length);
                        g.setColor(Color.BLACK);
                        g.drawPolygon(px, py, px.length);
                        g.drawLine(x, 12, x, h - 1);
                    }
                    if (DataView.this.drawPreviewLocator) {
                        int[] px = new int[]{DataView.this.previewLocatorX - 4, DataView.this.previewLocatorX, DataView.this.previewLocatorX + 4};
                        int[] py = new int[]{12, 0, 12};
                        float[] c = DataView.this.currentFill.getRGBColorComponents(null);
                        g.setColor(new Color(c[0], c[1], c[2], DataView.this.previewLocatorAlpha));
                        g.fillPolygon(px, py, px.length);
                        c = Color.BLACK.getRGBColorComponents(c);
                        g.setColor(new Color(c[0], c[1], c[2], DataView.this.previewLocatorAlpha));
                        g.drawPolygon(px, py, px.length);
                        g.drawLine(DataView.this.previewLocatorX, 12, DataView.this.previewLocatorX, h - 1);
                    }
                }
            }
        }
    }

    public class HeaderPanel
    extends Box {
        TagBox tagBox;
        TMScale scale;

        public HeaderPanel() {
            super(1);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
            this.tagBox = new TagBox(DataView.this);
            this.tagBox.setAlignmentX(0.0f);
            this.add(this.tagBox);
            this.scale = new TMScale();
            this.scale.setAlignmentX(0.0f);
            this.add(this.scale);
        }

        public void doMouseMoved(MouseEvent e) {
            if (DataView.this.zoomStack.isEmpty()) {
                return;
            }
            DataView.this.mouseLocatorX = e.getX();
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (DataView.this.mouseLocatorX > 0) {
                g.setColor(Color.DARK_GRAY);
                int tagBoxHeight = this.tagBox.getHeight();
                g.drawLine(DataView.this.mouseLocatorX, tagBoxHeight, DataView.this.mouseLocatorX, this.getHeight());
            }
        }
    }

    class SelectionImpl
    implements Selection {
        long start;
        long stop;

        SelectionImpl(int x1, int x2) {
            this.set(x1, x2);
        }

        SelectionImpl(long start1, long stop1) {
            this.set(start1, stop1);
        }

        @Override
        public long getStartInstant() {
            return this.start;
        }

        @Override
        public long getStopInstant() {
            return this.stop;
        }

        int getStartX() {
            ZoomSpec zoom = DataView.this.zoomStack.peek();
            return zoom.convertInstantToPixel(this.start);
        }

        int getStopX() {
            ZoomSpec zoom = DataView.this.zoomStack.peek();
            return zoom.convertInstantToPixel(this.stop);
        }

        public void set(long start1, long stop1) {
            if (start1 > stop1) {
                this.start = stop1;
                this.stop = start1;
            } else {
                this.start = start1;
                this.stop = stop1;
            }
        }

        public void set(int x1, int x2) {
            if (x1 > x2) {
                int xt = x1;
                x1 = x2;
                x2 = xt;
            }
            ZoomSpec zoom = DataView.this.zoomStack.peek();
            this.start = zoom.convertPixelToInstant(x1);
            this.stop = zoom.convertPixelToInstant(x2);
        }
    }
}

