/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.api.YamcsConnector;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.CommandHistoryRetrievalGui;
import org.yamcs.ui.PacketRetrievalGui;
import org.yamcs.ui.ParameterRetrievalGui;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.archivebrowser.ArchiveIndexReceiver;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.DataView;
import org.yamcs.ui.archivebrowser.IndexBox;
import org.yamcs.ui.archivebrowser.InstantFormat;
import org.yamcs.ui.archivebrowser.NavigatorItem;
import org.yamcs.ui.archivebrowser.Selection;
import org.yamcs.ui.archivebrowser.TagBox;

public abstract class DataViewer
extends NavigatorItem
implements ActionListener {
    private ArchivePanel archivePanel;
    private DataView dataView;
    public JToolBar buttonToolbar;
    private JMenu selectionMenu;
    private JMenuItem packetRetrieval;
    private JMenuItem parameterRetrieval;
    private JMenuItem cmdHistRetrieval;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton showAllButton;
    JButton newTagButton;
    boolean replayEnabled;
    private JFormattedTextField mouseLocator;
    private JFormattedTextField selectionStart;
    private JFormattedTextField selectionStop;
    private JLabel mouseLocatorLabel;
    private JLabel dottedSquare;
    PacketRetrievalGui packetGui;
    CommandHistoryRetrievalGui cmdHistGui;
    ParameterRetrievalGui parameterGui;
    private static Logger log = LoggerFactory.getLogger(DataViewer.class);

    public DataViewer(YamcsConnector yconnector, ArchiveIndexReceiver indexReceiver, ArchivePanel archivePanel, boolean replayEnabled) {
        super(yconnector, indexReceiver);
        this.archivePanel = archivePanel;
        this.replayEnabled = replayEnabled;
        this.selectionMenu = new JMenu("Selection");
        this.selectionMenu.setVisible(false);
        archivePanel.archiveBrowser.menuBar.add(this.selectionMenu);
        this.packetRetrieval = new JMenuItem("Export Telemetry Packets...");
        this.packetRetrieval.setToolTipText("Start packet retrieval of the selected telemetry packets");
        this.packetRetrieval.addActionListener(this);
        this.packetRetrieval.setActionCommand("start-packet-retrieval");
        this.packetRetrieval.setEnabled(false);
        this.selectionMenu.add(this.packetRetrieval);
        this.parameterRetrieval = new JMenuItem("Export Processed Parameters...");
        this.parameterRetrieval.setToolTipText("Start parameter retrieval for the selected time interval");
        this.parameterRetrieval.addActionListener(this);
        this.parameterRetrieval.setActionCommand("start-parameter-retrieval");
        this.parameterRetrieval.setEnabled(false);
        this.selectionMenu.add(this.parameterRetrieval);
        this.cmdHistRetrieval = new JMenuItem("Export Command History...");
        this.cmdHistRetrieval.setToolTipText("Start command history retrieval for the selected time interval");
        this.cmdHistRetrieval.addActionListener(this);
        this.cmdHistRetrieval.setActionCommand("start-cmdhist-retrieval");
        this.cmdHistRetrieval.setEnabled(false);
        this.selectionMenu.add(this.cmdHistRetrieval);
    }

    @Override
    public JComponent createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        contentPanel.setBackground(Color.WHITE);
        contentPanel.add((Component)this.createButtonToolbar(), "North");
        this.dataView = new DataView(this.archivePanel, this);
        this.dataView.addActionListener(this);
        contentPanel.add((Component)this.dataView, "Center");
        return contentPanel;
    }

    @Override
    public void onOpen() {
        this.selectionMenu.setVisible(true);
    }

    @Override
    public void onClose() {
        this.selectionMenu.setVisible(false);
    }

    @Override
    public JComponent createNavigatorInset() {
        Box vbox = Box.createVerticalBox();
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, UiColors.BORDER_COLOR);
        Border insideBorder = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        vbox.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
        InstantFormat iformat = new InstantFormat();
        Box mouseBox = Box.createHorizontalBox();
        this.mouseLocatorLabel = new JLabel("\u27a5");
        this.mouseLocatorLabel.setForeground(Color.LIGHT_GRAY);
        this.mouseLocatorLabel.setToolTipText("Mouse position");
        mouseBox.add(this.mouseLocatorLabel);
        this.mouseLocator = new JFormattedTextField(iformat);
        this.mouseLocator.setHorizontalAlignment(0);
        this.mouseLocator.setEditable(false);
        this.mouseLocator.setMaximumSize(new Dimension(150, this.mouseLocator.getPreferredSize().height));
        this.mouseLocator.setMinimumSize(this.mouseLocator.getMaximumSize());
        this.mouseLocator.setPreferredSize(this.mouseLocator.getMaximumSize());
        this.mouseLocator.setFont(this.mouseLocator.getFont().deriveFont(this.mouseLocator.getFont().getSize2D() - 3.0f));
        mouseBox.add(this.mouseLocator);
        Box selectionStartBox = Box.createHorizontalBox();
        this.dottedSquare = new JLabel("\u2b1a");
        this.dottedSquare.setForeground(Color.GRAY);
        this.dottedSquare.setToolTipText("Selected date range");
        selectionStartBox.add(this.dottedSquare);
        this.selectionStart = new JFormattedTextField(iformat);
        this.selectionStart.setHorizontalAlignment(0);
        this.selectionStart.setEditable(false);
        this.selectionStart.setMaximumSize(new Dimension(150, this.selectionStart.getPreferredSize().height));
        this.selectionStart.setMinimumSize(this.selectionStart.getMaximumSize());
        this.selectionStart.setPreferredSize(this.selectionStart.getMaximumSize());
        this.selectionStart.setFont(this.selectionStart.getFont().deriveFont(this.selectionStart.getFont().getSize2D() - 3.0f));
        selectionStartBox.add(this.selectionStart);
        this.selectionStart.addPropertyChangeListener("value", e -> this.dataView.updateSelection((Long)this.selectionStart.getValue(), (Long)this.selectionStop.getValue()));
        Box selectionStopBox = Box.createHorizontalBox();
        this.selectionStop = new JFormattedTextField(iformat);
        this.selectionStop.setHorizontalAlignment(0);
        this.selectionStop.setEditable(false);
        this.selectionStop.setMaximumSize(new Dimension(150, this.selectionStop.getPreferredSize().height));
        this.selectionStop.setMinimumSize(this.selectionStop.getMaximumSize());
        this.selectionStop.setPreferredSize(this.selectionStop.getMaximumSize());
        this.selectionStop.setFont(this.selectionStop.getFont().deriveFont(this.selectionStop.getFont().getSize2D() - 3.0f));
        selectionStopBox.add(this.selectionStop);
        this.selectionStop.addPropertyChangeListener("value", e -> this.dataView.updateSelection((Long)this.selectionStart.getValue(), (Long)this.selectionStop.getValue()));
        mouseBox.setAlignmentX(1.0f);
        vbox.add(mouseBox);
        selectionStartBox.setAlignmentX(1.0f);
        vbox.add(selectionStartBox);
        selectionStopBox.setAlignmentX(1.0f);
        vbox.add(selectionStopBox);
        return vbox;
    }

    public void signalMousePosition(long instant) {
        this.mouseLocatorLabel.setForeground(instant == Long.MIN_VALUE ? Color.LIGHT_GRAY : Color.GRAY);
        this.mouseLocator.setValue(instant);
    }

    public void signalSelectionChange(Selection selection) {
        if (selection != null) {
            this.signalSelectionStartChange(selection.getStartInstant());
            this.signalSelectionStopChange(selection.getStopInstant());
            if (selection.getStartInstant() != Long.MIN_VALUE || selection.getStopInstant() != Long.MIN_VALUE) {
                this.dottedSquare.setForeground(Color.BLUE);
            } else {
                this.dottedSquare.setForeground(Color.GRAY);
            }
            if (this.replayEnabled) {
                this.archivePanel.replayPanel.applySelectionButton.setEnabled(true);
            }
        } else {
            this.signalSelectionStartChange(Long.MIN_VALUE);
            this.signalSelectionStopChange(Long.MIN_VALUE);
            if (this.dottedSquare != null) {
                this.dottedSquare.setForeground(Color.GRAY);
            }
            if (this.replayEnabled) {
                this.archivePanel.replayPanel.applySelectionButton.setEnabled(false);
            }
        }
    }

    public void signalSelectionStartChange(long startInstant) {
        if (this.selectionStart != null) {
            this.selectionStart.setEditable(startInstant != Long.MIN_VALUE);
            this.selectionStart.setValue(startInstant);
        }
    }

    public void signalSelectionStopChange(long stopInstant) {
        if (this.selectionStop != null) {
            this.selectionStop.setEditable(stopInstant != Long.MIN_VALUE);
            this.selectionStop.setValue(stopInstant);
        }
    }

    public void addIndex(String tableName, String name) {
        this.addIndex(tableName, name, -1);
    }

    public void addIndex(String tableName, String name, int mergeTime) {
        this.dataView.addIndex(tableName, name, mergeTime);
        if (this.replayEnabled && "tm".equals(tableName)) {
            this.archivePanel.replayPanel.setDataViewer(this);
        }
    }

    public void addVerticalGlue() {
        this.dataView.addVerticalGlue();
    }

    private JToolBar createButtonToolbar() {
        this.buttonToolbar = new JToolBar("Button Toolbar");
        this.buttonToolbar.setAlignmentX(0.0f);
        this.buttonToolbar.setBackground(Color.WHITE);
        this.buttonToolbar.setFloatable(false);
        this.buttonToolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.zoomInButton = new JButton("Zoom In");
        this.zoomInButton.setActionCommand("zoomin");
        this.zoomInButton.addActionListener(this);
        this.zoomInButton.setEnabled(false);
        this.buttonToolbar.add(this.zoomInButton);
        this.zoomOutButton = new JButton("Zoom Out");
        this.zoomOutButton.setActionCommand("zoomout");
        this.zoomOutButton.addActionListener(this);
        this.zoomOutButton.setEnabled(false);
        this.buttonToolbar.add(this.zoomOutButton);
        this.showAllButton = new JButton("Show All");
        this.showAllButton.setActionCommand("showall");
        this.showAllButton.addActionListener(this);
        this.showAllButton.setEnabled(false);
        this.buttonToolbar.add(this.showAllButton);
        this.newTagButton = new JButton("New Tag");
        this.newTagButton.setVisible(this.archivePanel.archiveBrowser.indexReceiver.supportsTags());
        this.newTagButton.setEnabled(false);
        this.newTagButton.setToolTipText("Define a new tag for the current selection");
        this.newTagButton.addActionListener(this);
        this.newTagButton.setActionCommand("new-tag-button");
        this.buttonToolbar.add(this.newTagButton);
        return this.buttonToolbar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("showall")) {
            this.dataView.showAll();
            this.zoomOutButton.setEnabled(false);
        } else if (cmd.equals("zoomout")) {
            this.dataView.zoomOut();
            this.zoomOutButton.setEnabled(this.dataView.zoomStack.size() > 1);
        } else if (cmd.equals("zoomin")) {
            this.dataView.zoomIn();
            this.zoomOutButton.setEnabled(true);
        } else if (cmd.equalsIgnoreCase("completeness_selection_finished")) {
            if (this.indexReceiver.supportsTags()) {
                this.newTagButton.setEnabled(true);
            }
        } else if (cmd.toLowerCase().endsWith("selection_finished")) {
            if (this.indexReceiver.supportsTags()) {
                this.newTagButton.setEnabled(true);
            }
            if (cmd.startsWith("pp") || cmd.startsWith("tm")) {
                this.packetRetrieval.setEnabled(true);
                this.parameterRetrieval.setEnabled(true);
            } else if (cmd.startsWith("cmdhist")) {
                this.cmdHistRetrieval.setEnabled(true);
            }
        } else if (cmd.equalsIgnoreCase("selection_reset")) {
            if (this.newTagButton != null) {
                this.newTagButton.setEnabled(false);
            }
            this.packetRetrieval.setEnabled(false);
            this.parameterRetrieval.setEnabled(false);
            this.cmdHistRetrieval.setEnabled(false);
        } else if (cmd.equalsIgnoreCase("new-tag-button")) {
            DataView.SelectionImpl sel = this.dataView.getSelection();
            this.dataView.headerPanel.tagBox.createNewTag(sel.getStartInstant(), sel.getStopInstant());
        } else if (cmd.equalsIgnoreCase("insert-tag")) {
            TagBox.TagEvent te = (TagBox.TagEvent)e;
            this.indexReceiver.insertTag(this.archivePanel.archiveBrowser.getInstance(), te.newTag);
        } else if (cmd.equalsIgnoreCase("update-tag")) {
            TagBox.TagEvent te = (TagBox.TagEvent)e;
            this.indexReceiver.updateTag(this.archivePanel.archiveBrowser.getInstance(), te.oldTag, te.newTag);
        } else if (cmd.equalsIgnoreCase("delete-tag")) {
            TagBox.TagEvent te = (TagBox.TagEvent)e;
            this.indexReceiver.deleteTag(this.archivePanel.archiveBrowser.getInstance(), te.oldTag);
        } else if (cmd.equals("start-packet-retrieval")) {
            List<String> packets = Collections.emptyList();
            if (this.dataView.indexBoxes.containsKey("tm")) {
                packets = this.dataView.getSelectedPackets("tm");
            }
            DataView.SelectionImpl sel = this.dataView.getSelection();
            if (this.packetGui == null) {
                this.packetGui = new PacketRetrievalGui(this.yconnector.getConnectionParams(), this.getContentPanel());
            }
            this.packetGui.setValues(this.archivePanel.archiveBrowser.getInstance(), packets, sel.getStartInstant(), sel.getStopInstant());
            this.packetGui.setVisible(true);
        } else if (cmd.equals("start-parameter-retrieval")) {
            DataView.SelectionImpl sel = this.dataView.getSelection();
            if (this.parameterGui == null) {
                this.parameterGui = new ParameterRetrievalGui(this.yconnector.getConnectionParams(), this.getContentPanel());
            }
            this.parameterGui.setValues(this.archivePanel.archiveBrowser.getInstance(), sel.getStartInstant(), sel.getStopInstant());
            this.parameterGui.setVisible(true);
        } else if (cmd.equals("start-cmdhist-retrieval")) {
            DataView.SelectionImpl sel = this.dataView.getSelection();
            if (this.cmdHistGui == null) {
                this.cmdHistGui = new CommandHistoryRetrievalGui(this.yconnector.getConnectionParams(), this.getContentPanel());
            }
            this.cmdHistGui.setValues(this.archivePanel.archiveBrowser.getInstance(), null, sel.getStartInstant(), sel.getStopInstant());
            this.cmdHistGui.setVisible(true);
        }
    }

    public DataView getDataView() {
        return this.dataView;
    }

    @Override
    public void startReloading() {
        log.trace("startReloading. EDT? {} (should be false)", (Object)EventQueue.isDispatchThread());
        SwingUtilities.invokeLater(() -> {
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.showAllButton.setEnabled(false);
            if (this.replayEnabled) {
                this.archivePanel.replayPanel.applySelectionButton.setEnabled(false);
            }
        });
        for (IndexBox ib : this.dataView.indexBoxes.values()) {
            ib.startReloading();
        }
        this.dataView.headerPanel.tagBox.tags.clear();
    }

    @Override
    public void windowResized() {
        if (this.dataView.zoomStack.isEmpty() || this.dataView.zoomStack.size() == 1) {
            this.dataView.refreshDisplay(true);
            if (!this.dataView.zoomStack.isEmpty()) {
                this.dataView.setViewLocationFromZoomstack();
            }
        }
    }

    @Override
    public void receiveArchiveRecords(Yamcs.IndexResult ir) {
        log.trace("receiveArchiveRecords. EDT? {} (should be false)", (Object)EventQueue.isDispatchThread());
        if ("completeness".equals(ir.getType())) {
            if (this.dataView.indexBoxes.containsKey("completeness")) {
                this.dataView.indexBoxes.get("completeness").receiveArchiveRecords(ir.getRecordsList());
            }
        } else if ("histogram".equals(ir.getType())) {
            String tableName = ir.getTableName();
            if (this.dataView.indexBoxes.containsKey(tableName)) {
                this.dataView.indexBoxes.get(tableName).receiveArchiveRecords(ir.getRecordsList());
            }
        } else {
            System.out.println("Received archive records of type " + ir.getType() + " don't know what to do with them");
        }
    }

    @Override
    public void archiveLoadFinished() {
        log.trace("archiveLoadFinished. EDT? {} (should be false)", (Object)EventQueue.isDispatchThread());
        this.dataView.archiveLoadFinished();
    }

    @Override
    public void receiveTags(List<Yamcs.ArchiveTag> tagList) {
        this.dataView.headerPanel.tagBox.addTags(tagList);
    }

    @Override
    public void tagAdded(Yamcs.ArchiveTag ntag) {
        this.dataView.headerPanel.tagBox.addTag(ntag);
    }

    @Override
    public void tagRemoved(Yamcs.ArchiveTag rtag) {
        this.dataView.headerPanel.tagBox.removeTag(rtag);
    }

    @Override
    public void tagChanged(Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
        this.dataView.headerPanel.tagBox.updateTag(oldTag, newTag);
    }
}

