/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.PrefsObject;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.DataView;
import org.yamcs.ui.archivebrowser.IndexLine;
import org.yamcs.ui.archivebrowser.Selection;
import org.yamcs.ui.archivebrowser.Timeline;
import org.yamcs.ui.archivebrowser.ZoomSpec;

public class IndexBox
extends Box
implements MouseListener {
    private static final long serialVersionUID = 1L;
    DataView dataView;
    JLabel popupLabelItem;
    JSeparator popupLabelSeparator;
    JPopupMenu packetPopup;
    JMenuItem removePacketMenuItem;
    JMenuItem removeExceptPacketMenuItem;
    JMenuItem removePayloadMenuItem;
    JMenuItem changeColorMenuItem;
    JMenuItem copyOpsnameMenuItem;
    IndexLineSpec selectedPacket;
    static final int tmRowHeight = 20;
    HashMap<String, IndexLineSpec> allPackets;
    HashMap<String, ArrayList<IndexLineSpec>> groups;
    HashMap<String, TreeSet<ArchivePanel.IndexChunkSpec>> tmData;
    private ZoomSpec zoom;
    private String name;
    long mergeTime = -1L;
    Preferences prefs;
    private JPanel topPanel;
    private JPanel centerPanel;
    private List<IndexLine> indexLines = new ArrayList<IndexLine>();
    private JLabel titleLabel;

    IndexBox(DataView dataView, String name) {
        super(1);
        this.topPanel = new JPanel(new GridBagLayout());
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, UiColors.BORDER_COLOR);
        Border insideBorder = BorderFactory.createEmptyBorder(10, 0, 2, 0);
        this.topPanel.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
        this.topPanel.setBackground(Color.WHITE);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridx = 0;
        this.titleLabel = new JLabel(name);
        this.titleLabel.setBackground(Color.red);
        this.titleLabel.setMaximumSize(new Dimension(this.titleLabel.getMaximumSize().width, this.titleLabel.getPreferredSize().height));
        this.titleLabel.setForeground(new Color(51, 51, 51));
        this.topPanel.setMaximumSize(new Dimension(this.topPanel.getMaximumSize().width, this.titleLabel.getPreferredSize().height + 13));
        this.topPanel.add((Component)this.titleLabel, cons);
        this.topPanel.setAlignmentX(0.0f);
        this.add(this.topPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.centerPanel.setOpaque(false);
        this.centerPanel.setAlignmentX(0.0f);
        this.add(this.centerPanel);
        this.addMouseListener(this);
        this.dataView = dataView;
        this.name = name;
        this.allPackets = new HashMap();
        this.groups = new HashMap();
        this.tmData = new HashMap();
        this.prefs = Preferences.userNodeForPackage(IndexBox.class).node(name);
    }

    void removeIndexLines() {
        this.centerPanel.removeAll();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        g2d.setPaint(new GradientPaint(0.0f, this.topPanel.getHeight(), new Color(251, 251, 251), 0.0f, panelHeight, Color.WHITE));
        g2d.fillRect(0, this.topPanel.getHeight(), panelWidth, panelHeight - this.topPanel.getHeight());
    }

    protected void buildPopup() {
        if (this.groups.isEmpty()) {
            this.packetPopup = null;
        } else {
            this.packetPopup = new JPopupMenu();
            this.popupLabelItem = new JLabel();
            this.popupLabelItem.setEnabled(false);
            Box hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalGlue());
            hbox.add(this.popupLabelItem);
            hbox.add(Box.createHorizontalGlue());
            this.packetPopup.insert(hbox, 0);
            this.popupLabelSeparator = new JSeparator();
            this.packetPopup.add(this.popupLabelSeparator);
            JMenu packetmenu = new JMenu("Add Packets");
            this.packetPopup.add(packetmenu);
            this.removePacketMenuItem = new JMenuItem();
            this.removePacketMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexBox.this.removeSelectedPacket();
                }
            });
            this.packetPopup.add(this.removePacketMenuItem);
            this.removeExceptPacketMenuItem = new JMenuItem("Hide Other Packets");
            this.removeExceptPacketMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexBox.this.removeAllButThisLine();
                }
            });
            this.packetPopup.add(this.removeExceptPacketMenuItem);
            this.removePayloadMenuItem = new JMenuItem();
            this.removePayloadMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexBox.this.removeGroupLines();
                }
            });
            this.packetPopup.add(this.removePayloadMenuItem);
            this.copyOpsnameMenuItem = new JMenuItem("Copy Ops-Name to Clipboard");
            this.copyOpsnameMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (IndexBox.this.selectedPacket != null) {
                        StringSelection strsel = new StringSelection(IndexBox.this.selectedPacket.lineName);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(strsel, strsel);
                    }
                }
            });
            this.packetPopup.add(this.copyOpsnameMenuItem);
            this.changeColorMenuItem = new JMenuItem("Change Color");
            this.changeColorMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexBox.this.selectedPacket.newColor();
                    IndexBox.this.dataView.setBusyPointer();
                    IndexBox.this.redrawTmPanel(IndexBox.this.selectedPacket);
                    IndexBox.this.dataView.setNormalPointer();
                }
            });
            this.packetPopup.add(this.changeColorMenuItem);
            Object[] plkeys = this.groups.keySet().toArray(new String[0]);
            Arrays.sort(plkeys);
            for (Object key : plkeys) {
                JMenuItem menuItem;
                ArrayList<IndexLineSpec> tm = this.groups.get(key);
                JMenu submenu = new JMenu((String)key);
                packetmenu.add(submenu);
                Object[] tmarray = tm.toArray(new IndexLineSpec[0]);
                Arrays.sort(tmarray);
                for (Object pkt : tmarray) {
                    if (this.dataView.hideResponsePackets && ((IndexLineSpec)pkt).lineName.contains("_Resp_")) continue;
                    ((IndexLineSpec)pkt).assocMenuItem = menuItem = new JMenuItem(((IndexLineSpec)pkt).toString());
                    if (((IndexLineSpec)pkt).enabled) {
                        menuItem.setVisible(false);
                    }
                    menuItem.addActionListener((ActionListener)pkt);
                    submenu.add(menuItem);
                }
                submenu.addSeparator();
                menuItem = new JMenuItem("All Packets");
                menuItem.addActionListener(new ActionListener((String)key){
                    final /* synthetic */ String val$key;
                    {
                        this.val$key = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IndexBox.this.enableAllPackets(this.val$key);
                    }
                });
                submenu.add(menuItem);
            }
        }
    }

    void updatePrefsVisiblePackets() {
        ArrayList<String> visiblePackets = new ArrayList<String>();
        for (ArrayList<IndexLineSpec> plvec : this.groups.values()) {
            for (IndexLineSpec pkt : plvec) {
                if (!pkt.enabled) continue;
                visiblePackets.add(pkt.lineName);
            }
        }
        PrefsObject.putObject((Preferences)this.prefs, (String)"indexLines", visiblePackets);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.selectedPacket = null;
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void doMouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doMouseReleased(e);
    }

    void showPopup(MouseEvent e) {
        if (this.packetPopup != null) {
            if (this.selectedPacket != null) {
                this.popupLabelItem.setVisible(true);
                this.popupLabelSeparator.setVisible(true);
                this.removePayloadMenuItem.setVisible(true);
                this.removeExceptPacketMenuItem.setVisible(true);
                this.removePacketMenuItem.setVisible(true);
                this.copyOpsnameMenuItem.setVisible(true);
                this.changeColorMenuItem.setVisible(true);
                this.popupLabelItem.setText(this.selectedPacket.lineName);
                this.removePacketMenuItem.setText(String.format("Hide %s Packet", this.selectedPacket.lineName));
                this.removePayloadMenuItem.setText(String.format("Hide All %s Packets", this.selectedPacket.grpName));
            } else {
                this.popupLabelItem.setVisible(false);
                this.popupLabelSeparator.setVisible(false);
                this.removePayloadMenuItem.setVisible(false);
                this.removePacketMenuItem.setVisible(false);
                this.removeExceptPacketMenuItem.setVisible(false);
                this.copyOpsnameMenuItem.setVisible(false);
                this.changeColorMenuItem.setVisible(false);
            }
            this.packetPopup.validate();
            this.packetPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    void enableAllPackets(String plname) {
        ArrayList<IndexLineSpec> pltm = this.groups.get(plname);
        if (pltm != null) {
            for (IndexLineSpec pkt : pltm) {
                if (pkt.assocMenuItem == null) continue;
                pkt.assocMenuItem.setVisible(false);
                pkt.enabled = true;
            }
            this.updatePrefsVisiblePackets();
            this.dataView.refreshDisplay();
        }
    }

    void enableTMPacket(IndexLineSpec pkt) {
        pkt.assocMenuItem.setVisible(false);
        pkt.enabled = true;
        this.dataView.refreshDisplay();
        this.updatePrefsVisiblePackets();
    }

    void removeSelectedPacket() {
        this.dataView.setBusyPointer();
        this.selectedPacket.assocMenuItem.setVisible(true);
        this.selectedPacket.enabled = false;
        this.remove(this.selectedPacket.assocIndexLine);
        this.selectedPacket.assocIndexLine = null;
        this.updatePrefsVisiblePackets();
        if (this.getComponents().length == 0) {
            this.showEmptyLabel("Right click for " + this.name + " data");
        }
        this.dataView.refreshDisplay();
        this.dataView.setNormalPointer();
    }

    void removeGroupLines() {
        ArrayList<IndexLineSpec> pltm = this.groups.get(this.selectedPacket.grpName);
        if (pltm != null) {
            this.dataView.setBusyPointer();
            for (IndexLineSpec pkt : pltm) {
                if (pkt.assocMenuItem != null) {
                    pkt.assocMenuItem.setVisible(true);
                }
                pkt.enabled = false;
                if (pkt.assocIndexLine == null) continue;
                this.remove(pkt.assocIndexLine);
                pkt.assocIndexLine = null;
            }
            if (this.getComponents().length == 0) {
                this.showEmptyLabel("Right click for " + this.name + " data");
            }
            this.updatePrefsVisiblePackets();
            this.dataView.refreshDisplay();
            this.dataView.setNormalPointer();
        }
    }

    void removeAllButThisLine() {
        this.dataView.setBusyPointer();
        for (ArrayList<IndexLineSpec> plvec : this.groups.values()) {
            for (IndexLineSpec pkt : plvec) {
                if (this.selectedPacket == pkt) continue;
                if (pkt.assocMenuItem != null) {
                    pkt.assocMenuItem.setVisible(true);
                }
                pkt.enabled = false;
                if (pkt.assocIndexLine == null) continue;
                this.remove(pkt.assocIndexLine);
                pkt.assocIndexLine = null;
            }
        }
        this.updatePrefsVisiblePackets();
        this.dataView.refreshDisplay();
        this.dataView.setNormalPointer();
    }

    public String getPacketsStatus() {
        StringBuffer txt = new StringBuffer();
        for (String plname : this.groups.keySet()) {
            ArrayList<IndexLineSpec> plvec = this.groups.get(plname);
            int count = 0;
            for (IndexLineSpec pkt : plvec) {
                if (!pkt.enabled) continue;
                ++count;
            }
            String tmp = plname + " (" + count + "/" + plvec.size() + ")";
            if (txt.length() > 0) {
                txt.append(", ");
            }
            txt.append(tmp);
        }
        if (txt.length() == 0) {
            txt.append("(none)");
        }
        return txt.toString();
    }

    public void setToZoom(ZoomSpec zoom) {
        this.zoom = zoom;
        this.removeIndexLines();
        this.packetPopup = null;
        if (this.groups.isEmpty()) {
            this.showEmptyLabel("No " + this.name + " data loaded");
        } else {
            boolean empty = true;
            for (ArrayList<IndexLineSpec> plvec : this.groups.values()) {
                for (IndexLineSpec pkt : plvec) {
                    if (!pkt.enabled) continue;
                    empty = false;
                    IndexLine line = new IndexLine(this, pkt);
                    this.centerPanel.add(line);
                    this.indexLines.add(line);
                    this.redrawTmPanel(pkt);
                }
            }
            if (empty) {
                this.showEmptyLabel("Right click for " + this.name + " data");
            }
            this.buildPopup();
        }
    }

    private void showEmptyLabel(String msg) {
        JLabel nodata = new JLabel(msg);
        nodata.setFont(new Font("SansSerif", 2, nodata.getFont().getSize()));
        nodata.setForeground(Color.lightGray);
        nodata.addMouseListener(this);
        Box b = Box.createHorizontalBox();
        b.setBorder(BorderFactory.createEmptyBorder());
        b.add(nodata);
        b.add(Box.createHorizontalGlue());
        b.setMaximumSize(new Dimension(b.getMaximumSize().width, b.getPreferredSize().height));
        this.centerPanel.add(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveArchiveRecords(List<Yamcs.ArchiveRecord> records) {
        HashMap<String, TreeSet<ArchivePanel.IndexChunkSpec>> hashMap = this.tmData;
        synchronized (hashMap) {
            for (Yamcs.ArchiveRecord r : records) {
                int idx;
                Yamcs.NamedObjectId id = r.getId();
                String grpName = null;
                String shortName = null;
                if (!id.hasNamespace() && (idx = id.getName().lastIndexOf("/")) != -1) {
                    grpName = id.getName().substring(0, idx + 1);
                    shortName = id.getName().substring(idx + 1);
                }
                if (grpName == null) {
                    String[] nameparts = id.getName().split("[_\\.]", 2);
                    if (nameparts.length > 1) {
                        grpName = nameparts[0];
                        shortName = nameparts[1].replaceFirst("INST_", "").replaceFirst("Tlm_Pkt_", "");
                    } else {
                        grpName = "";
                        shortName = id.getName();
                    }
                }
                if (!this.tmData.containsKey(id.getName())) {
                    this.tmData.put(id.getName(), new TreeSet());
                }
                TreeSet<ArchivePanel.IndexChunkSpec> al = this.tmData.get(id.getName());
                String info = r.hasInfo() ? r.getInfo() : null;
                ArchivePanel.IndexChunkSpec tnew = new ArchivePanel.IndexChunkSpec(r.getFirst(), r.getLast(), r.getNum(), info);
                ArchivePanel.IndexChunkSpec told = al.floor(tnew);
                if (told == null || this.mergeTime == -1L || !told.merge(tnew, this.mergeTime)) {
                    al.add(tnew);
                }
                if (this.allPackets.containsKey(id.getName())) continue;
                IndexLineSpec pkt = new IndexLineSpec(id.getName(), grpName, shortName);
                this.allPackets.put(id.getName(), pkt);
                ArrayList<IndexLineSpec> plvec = this.groups.get(grpName);
                if (plvec == null) {
                    plvec = new ArrayList();
                    this.groups.put(grpName, plvec);
                }
                plvec.add(pkt);
            }
            this.titleLabel.setText(this.name + " " + this.getPacketsStatus());
        }
    }

    public void startReloading() {
        this.allPackets.clear();
        this.groups.clear();
        this.tmData.clear();
    }

    public List<String> getPacketsForSelection(Selection selection) {
        ArrayList<String> packets = new ArrayList<String>();
        for (ArrayList<IndexLineSpec> plvec : this.groups.values()) {
            for (IndexLineSpec pkt : plvec) {
                if (!pkt.enabled) continue;
                packets.add(pkt.lineName);
            }
        }
        return packets;
    }

    public void dataLoadFinished() {
        Object o = PrefsObject.getObject((Preferences)this.prefs, (String)"indexLines");
        if (o == null) {
            return;
        }
        ArrayList visibleLines = (ArrayList)o;
        for (String linename : visibleLines) {
            IndexLineSpec pkt = this.allPackets.get(linename);
            if (pkt != null) {
                pkt.enabled = true;
                continue;
            }
            ArchivePanel.debugLog("could not enable packet '" + linename + "', removing line from view");
        }
    }

    void redrawTmPanel(IndexLineSpec pkt) {
        JLabel pktlab;
        IndexLine indexLine = pkt.assocIndexLine;
        indexLine.setOpaque(false);
        int stopx = this.zoom.getPixels();
        Insets in = indexLine.getInsets();
        int panelw = this.zoom.getPixels();
        Font font = null;
        int y = 0;
        indexLine.removeAll();
        int x1 = 10;
        indexLine.setBackground(Color.RED);
        do {
            pktlab = new JLabel(pkt.lineName);
            pktlab.setForeground(pkt.color);
            if (font == null) {
                font = pktlab.getFont();
                font = font.deriveFont((float)(font.getSize() - 3));
            }
            pktlab.setFont(font);
            pktlab.setBounds(x1 + in.left, in.top, pktlab.getPreferredSize().width, pktlab.getPreferredSize().height);
            indexLine.add(pktlab);
            if (y != 0) continue;
            y = in.top + pktlab.getSize().height;
            indexLine.setPreferredSize(new Dimension(panelw, y + 20 + in.bottom));
            indexLine.setMinimumSize(indexLine.getPreferredSize());
            indexLine.setMaximumSize(indexLine.getPreferredSize());
        } while ((x1 += 600) < panelw - pktlab.getSize().width);
        TreeSet<ArchivePanel.IndexChunkSpec> ts = this.tmData.get(pkt.lineName);
        if (ts != null) {
            Timeline tmt = new Timeline(this, pkt, ts, this.zoom, in.left);
            tmt.setBounds(in.left, y, stopx, 20);
            indexLine.add(tmt);
        }
        indexLine.revalidate();
        indexLine.repaint();
    }

    public void setMergeTime(long mt) {
        this.mergeTime = mt;
    }

    class IndexLineSpec
    implements Comparable<IndexLineSpec>,
    ActionListener {
        String shortName;
        String lineName;
        String grpName;
        boolean enabled;
        Color color;
        JMenuItem assocMenuItem;
        JComponent assocLabel;
        IndexLine assocIndexLine;

        public IndexLineSpec(String lineName, String grpName, String shortName) {
            this.lineName = lineName;
            this.grpName = grpName;
            this.shortName = shortName;
            this.enabled = false;
            this.assocMenuItem = null;
            this.assocIndexLine = null;
            this.assocLabel = null;
            this.newColor();
        }

        public void newColor() {
            this.color = new Color((float)(Math.random() * 0.4 + 0.2), (float)(Math.random() * 0.4 + 0.2), (float)(Math.random() * 0.4 + 0.2));
        }

        public String toString() {
            return this.shortName;
        }

        @Override
        public int compareTo(IndexLineSpec o) {
            return this.shortName.compareTo(o.shortName);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            IndexBox.this.enableTMPacket(this);
        }
    }
}

