/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.yamcs.ui.archivebrowser.IndexBox;
import org.yamcs.utils.TimeEncoding;

class IndexLine
extends JPanel
implements MouseInputListener {
    private final IndexBox indexBox;
    private static final long serialVersionUID = 1L;
    IndexBox.IndexLineSpec pkt;

    IndexLine(IndexBox tmBox, IndexBox.IndexLineSpec pkt) {
        super(null, false);
        this.indexBox = tmBox;
        this.pkt = pkt;
        pkt.assocIndexLine = this;
        this.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.indexBox.getToolTipLocation(e);
    }

    private MouseEvent translateEvent(MouseEvent e) {
        MouseEvent me = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.indexBox);
        return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getXOnScreen(), me.getYOnScreen(), me.getClickCount(), me.isPopupTrigger(), e.getButton());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.indexBox.selectedPacket = this.pkt;
            this.indexBox.showPopup(this.translateEvent(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.indexBox.selectedPacket = this.pkt;
            this.indexBox.showPopup(this.translateEvent(e));
        }
        this.indexBox.doMouseReleased(this.translateEvent(e));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.indexBox.dispatchEvent(this.translateEvent(e));
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseEvent transEvent = this.translateEvent(e);
        this.setToolTipText(TimeEncoding.toCombinedFormat((long)this.indexBox.dataView.getMouseInstant(transEvent)));
        this.indexBox.dataView.setPointer(transEvent);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

