/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import org.yamcs.utils.TimeEncoding;

public class InstantFormat
extends DefaultFormatter {
    private static final long serialVersionUID = 1L;

    public InstantFormat() {
        this.setOverwriteMode(false);
    }

    @Override
    public Object stringToValue(String s) throws ParseException {
        if (s == null || s.isEmpty()) {
            return Long.MIN_VALUE;
        }
        try {
            return TimeEncoding.parse((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public String valueToString(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        long instant = (Long)obj;
        if (instant != Long.MIN_VALUE) {
            return TimeEncoding.toString((long)instant);
        }
        return "";
    }

    @Override
    public void install(JFormattedTextField ftf) {
        int savedCaretPos = ftf.getCaretPosition();
        super.install(ftf);
        if (savedCaretPos < ftf.getText().length()) {
            ftf.setCaretPosition(savedCaretPos);
        }
    }
}

