/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.datepicker.DatePicker;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.TimeInterval;

public class PrefsToolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox instances;
    DatePicker datePicker;
    Preferences prefs = Preferences.userNodeForPackage(ArchivePanel.class);
    public JButton reloadButton;

    public PrefsToolbar() {
        super(new FlowLayout(0));
        JLabel label = new JLabel("Archive Instance:");
        this.add(label);
        this.instances = new JComboBox();
        this.instances.setEditable(false);
        this.instances.setPreferredSize(new Dimension(100, this.instances.getPreferredSize().height));
        this.instances.setMaximumSize(new Dimension(300, this.instances.getPreferredSize().height));
        this.add(this.instances);
        this.add(new JSeparator(1));
        label = new JLabel("Reload Range:");
        this.add(label);
        this.datePicker = new DatePicker();
        this.datePicker.setMaximumSize(this.datePicker.getPreferredSize());
        this.add(this.datePicker);
        this.add(new JSeparator(1));
        this.reloadButton = new JButton("Reload");
        this.reloadButton.setActionCommand("reload");
        this.reloadButton.setEnabled(false);
        this.add(this.reloadButton);
        this.loadFromPrefs();
    }

    public void savePreferences() {
        this.prefs.put("instance", this.getInstance());
        this.prefs.putLong("rangeStart", this.getStartTimestamp());
        this.prefs.putLong("rangeEnd", this.getEndTimestamp());
    }

    public TimeInterval getInterval() {
        return this.datePicker.getInterval();
    }

    public long getEndTimestamp() {
        return this.datePicker.getEndTimestamp();
    }

    public long getStartTimestamp() {
        return this.datePicker.getStartTimestamp();
    }

    public void setInstances(List<String> archiveInstances) {
        this.instances.removeAllItems();
        for (String item : archiveInstances) {
            this.instances.addItem(item);
        }
        String preferred = this.prefs.get("instance", archiveInstances.get(0));
        if (archiveInstances.contains(preferred)) {
            this.instances.setSelectedItem(preferred);
        }
    }

    public void setVisiblePackets(Object[] packets) {
        StringBuffer strbuf = new StringBuffer();
        for (Object s : packets) {
            strbuf.append(" ");
            strbuf.append(s.toString());
        }
        this.prefs.put("packets", strbuf.toString().trim());
    }

    void loadFromPrefs() {
        this.datePicker.setStartTimestamp(this.prefs.getLong("rangeStart", TimeEncoding.currentInstant() - 2592000L));
        this.datePicker.setEndTimestamp(this.prefs.getLong("rangeEnd", TimeEncoding.currentInstant()));
    }

    public String getInstance() {
        return (String)this.instances.getSelectedItem();
    }

    public String[] getVisiblePackets() {
        String[] s = this.prefs.get("packets", "").split(" ");
        return s[0].equals("") ? new String[]{} : s;
    }
}

