/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.yamcs.api.ProcessorControlClient;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.protobuf.YamcsManagement;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.DataViewer;
import org.yamcs.utils.TimeEncoding;

public class ReplayPanel
extends JPanel {
    protected JLabel replayStartLabel;
    protected JLabel replayCurrentLabel;
    protected JLabel replayStopLabel;
    protected JLabel channelNameLabel;
    protected JLabel replayStatusLabel;
    protected JLabel replaySpeedLabel;
    protected ImageIcon replayStartIcon;
    protected ImageIcon replayStopIcon;
    protected JButton playStopButton;
    public JButton applySelectionButton;
    protected YamcsManagement.ProcessorInfo currentYProcInfo;
    int replayButtonFunction;
    static final int STOP = 0;
    static final int PLAY = 1;
    DataViewer dataViewer;
    ProcessorControlClient channelControl;
    long currentInstant;

    public ReplayPanel() {
        super(new BorderLayout());
        GridBagLayout lay = new GridBagLayout();
        JPanel centerPanel = new JPanel(lay);
        GridBagConstraints gbc = new GridBagConstraints();
        this.replayStatusLabel = new JLabel();
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        lay.setConstraints(this.replayStatusLabel, gbc);
        centerPanel.add(this.replayStatusLabel);
        JLabel lab = new JLabel("Name:");
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        lay.setConstraints(lab, gbc);
        centerPanel.add(lab);
        this.channelNameLabel = new JLabel();
        this.channelNameLabel.setPreferredSize(new Dimension(150, this.channelNameLabel.getPreferredSize().height));
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        lay.setConstraints(this.channelNameLabel, gbc);
        centerPanel.add(this.channelNameLabel);
        this.replayStartIcon = ArchivePanel.getIcon("start.gif");
        this.replayStopIcon = ArchivePanel.getIcon("stop.gif");
        this.playStopButton = new JButton(this.replayStopIcon);
        this.playStopButton.setEnabled(false);
        this.playStopButton.addActionListener(ae -> this.playOrStopPressed());
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.anchor = 11;
        gbc.fill = 0;
        lay.setConstraints(this.playStopButton, gbc);
        centerPanel.add(this.playStopButton);
        lab = new JLabel("Start:");
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        lay.setConstraints(lab, gbc);
        centerPanel.add(lab);
        this.replayStartLabel = new JLabel();
        this.replayStartLabel.setPreferredSize(new Dimension(150, this.replayStartLabel.getPreferredSize().height));
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        lay.setConstraints(this.replayStartLabel, gbc);
        centerPanel.add(this.replayStartLabel);
        lab = new JLabel("Current:");
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        lay.setConstraints(lab, gbc);
        centerPanel.add(lab);
        this.replayCurrentLabel = new JLabel();
        this.replayCurrentLabel.setPreferredSize(new Dimension(150, this.replayCurrentLabel.getPreferredSize().height));
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        lay.setConstraints(this.replayCurrentLabel, gbc);
        centerPanel.add(this.replayCurrentLabel);
        lab = new JLabel("Stop:");
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        lay.setConstraints(lab, gbc);
        centerPanel.add(lab);
        this.replayStopLabel = new JLabel();
        this.replayStopLabel.setPreferredSize(new Dimension(150, this.replayStopLabel.getPreferredSize().height));
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        lay.setConstraints(this.replayStopLabel, gbc);
        centerPanel.add(this.replayStopLabel);
        lab = new JLabel("Speed:");
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        lay.setConstraints(lab, gbc);
        centerPanel.add(lab);
        this.replaySpeedLabel = new JLabel();
        this.replaySpeedLabel.setPreferredSize(new Dimension(150, this.replaySpeedLabel.getPreferredSize().height));
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        lay.setConstraints(this.replaySpeedLabel, gbc);
        centerPanel.add(this.replaySpeedLabel);
        this.add((Component)centerPanel, "Center");
        Box buttonPanel = Box.createVerticalBox();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 50));
        this.applySelectionButton = new JButton("Apply Selection");
        this.applySelectionButton.setAlignmentX(0.5f);
        this.applySelectionButton.setEnabled(false);
        this.applySelectionButton.setToolTipText("Apply the selection to the replay");
        this.applySelectionButton.setActionCommand("apply");
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(this.applySelectionButton);
        buttonPanel.add(Box.createVerticalGlue());
        this.add((Component)buttonPanel, "East");
    }

    public void setDataViewer(DataViewer dataViewer) {
        this.dataViewer = dataViewer;
    }

    public void setProcessorControlClient(ProcessorControlClient cc) {
        this.channelControl = cc;
    }

    void playOrStopPressed() {
        if (this.currentYProcInfo != null) {
            if (this.replayButtonFunction == 0) {
                this.pauseReplay();
            } else {
                this.resumeReplay();
            }
        }
    }

    public void clearReplayPanel() {
        this.currentYProcInfo = null;
        for (Component c : this.getComponents()) {
            c.setEnabled(false);
        }
        this.replayStartLabel.setText("");
        this.replayStopLabel.setText("");
        this.replayCurrentLabel.setText("");
        this.dataViewer.getDataView().setStartLocator(this.dataViewer.getDataView().DO_NOT_DRAW);
        this.dataViewer.getDataView().setStopLocator(this.dataViewer.getDataView().DO_NOT_DRAW);
        this.dataViewer.getDataView().setCurrentLocator(this.dataViewer.getDataView().DO_NOT_DRAW);
    }

    public void updateProcessorInfol(YamcsManagement.ProcessorInfo ci) {
        if (!(this.currentYProcInfo != null && ci.getInstance().equals(this.currentYProcInfo.getInstance()) && ci.getName().equals(this.currentYProcInfo.getName()) && ci.hasReplayRequest())) {
            return;
        }
        this.currentYProcInfo = ci;
        this.updateReplayPanel();
    }

    public void setupReplayPanel(YamcsManagement.ProcessorInfo ci) {
        if (ci.hasReplayRequest()) {
            this.currentYProcInfo = ci;
            if (this.isVisible()) {
                this.playStopButton.setEnabled(true);
                this.replayCurrentLabel.setText("");
                this.dataViewer.getDataView().setCurrentLocator(this.dataViewer.getDataView().DO_NOT_DRAW);
                for (Component c : this.getComponents()) {
                    c.setEnabled(true);
                }
                this.updateReplayPanel();
            }
        } else {
            this.clearReplayPanel();
        }
    }

    private void updateReplayPanel() {
        if (this.currentYProcInfo.getReplayState() == Yamcs.ReplayStatus.ReplayState.RUNNING) {
            if (this.replayStopIcon == null) {
                this.playStopButton.setText("Stop");
            } else {
                this.playStopButton.setIcon(this.replayStopIcon);
            }
            this.playStopButton.setToolTipText("Stop replay and remain at the current position.");
            this.replayButtonFunction = 0;
        } else {
            if (this.replayStartIcon == null) {
                this.playStopButton.setText("Play");
            } else {
                this.playStopButton.setIcon(this.replayStartIcon);
            }
            this.playStopButton.setToolTipText("Start replay from the current position.");
            this.replayButtonFunction = 1;
        }
        Yamcs.ReplayRequest rr = this.currentYProcInfo.getReplayRequest();
        if (rr.hasUtcStart()) {
            this.replayStartLabel.setText(rr.getUtcStart());
        } else {
            this.replayStartLabel.setText(TimeEncoding.toString((long)rr.getStart()));
        }
        if (rr.hasUtcStop()) {
            this.replayStopLabel.setText(rr.getUtcStop());
        } else {
            this.replayStopLabel.setText(TimeEncoding.toString((long)rr.getStop()));
        }
        this.replaySpeedLabel.setText(this.getSpeedLabel(rr.getSpeed()));
        this.channelNameLabel.setText(this.currentYProcInfo.getName());
        this.dataViewer.getDataView().setStartLocator(rr.getStart());
        this.dataViewer.getDataView().setStopLocator(rr.getStop());
    }

    private String getSpeedLabel(Yamcs.ReplaySpeed speed) {
        switch (speed.getType()) {
            case AFAP: {
                return "As fast as possible";
            }
            case FIXED_DELAY: {
                return "Fixed delay " + (int)speed.getParam() + " ms";
            }
            case REALTIME: {
                return "Realtime x" + speed.getParam();
            }
        }
        return "unknown";
    }

    public void updateStatistics(YamcsManagement.Statistics stats) {
        if (this.currentYProcInfo != null && this.currentYProcInfo.hasReplayRequest() && this.currentYProcInfo.getInstance().equals(stats.getInstance()) && this.currentYProcInfo.getName().equals(stats.getYProcessorName())) {
            long pos = 0L;
            for (YamcsManagement.TmStatistics ts : stats.getTmstatsList()) {
                pos = Math.max(pos, ts.getLastPacketTime());
            }
            this.currentInstant = pos;
            this.replayCurrentLabel.setText(TimeEncoding.toString((long)this.currentInstant));
            this.dataViewer.getDataView().setCurrentLocator(this.currentInstant);
        }
    }

    void pauseReplay() {
        try {
            this.channelControl.pauseArchiveReplay(this.currentYProcInfo.getInstance(), this.currentYProcInfo.getName());
        }
        catch (Exception e) {
            this.debugLog("exception when stopping replay for channel " + this.currentYProcInfo.getName() + " :" + e.getMessage());
        }
    }

    void resumeReplay() {
        if (this.currentInstant == Long.MIN_VALUE) {
            this.debugLog("start replay from " + TimeEncoding.toString((long)this.currentYProcInfo.getReplayRequest().getStart()));
        } else {
            this.debugLog("start replay from " + TimeEncoding.toString((long)this.currentInstant));
        }
        try {
            this.channelControl.resumeArchiveReplay(this.currentYProcInfo.getInstance(), this.currentYProcInfo.getName());
        }
        catch (Exception e) {
            this.debugLog("exception when starting replay for channel " + this.currentYProcInfo.getInstance() + "." + this.currentYProcInfo.getName() + " :" + e.getMessage());
        }
    }

    void seekReplay(long newPosition) {
        this.debugLog("seeking replay to " + TimeEncoding.toString((long)newPosition));
        try {
            this.channelControl.seekArchiveReplay(this.currentYProcInfo.getInstance(), this.currentYProcInfo.getName(), newPosition);
        }
        catch (Exception e) {
            this.debugLog("exception when starting replay for channel " + this.currentYProcInfo.getInstance() + "." + this.currentYProcInfo.getName() + " :" + e.getMessage());
        }
    }

    private void debugLog(String string) {
        System.err.println(string);
    }

    public void channelStateChanged(YamcsManagement.ProcessorInfo ci) {
        this.currentYProcInfo = ci;
        this.updateReplayPanel();
    }
}

