/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.NavigatorItem;

public class SideNavigator
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private ArchivePanel archivePanel;
    private JPanel itemLabelsPanel;

    public SideNavigator(ArchivePanel archivePanel) {
        super(new BorderLayout());
        this.archivePanel = archivePanel;
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, UiColors.BORDER_COLOR);
        Border insideBorder = BorderFactory.createEmptyBorder(10, 0, 10, 0);
        this.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
        this.itemLabelsPanel = new JPanel(new GridBagLayout());
        this.add((Component)this.itemLabelsPanel, "North");
        this.add((Component)new JPanel(), "Center");
    }

    public void addItem(String name, int indent, NavigatorItem navigatorItem) {
        NavigatorItemLabel item = new NavigatorItemLabel(name, navigatorItem, indent);
        item.addMouseListener(this);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridx = 0;
        this.itemLabelsPanel.add((Component)item, cons);
    }

    public void updateActiveItem(NavigatorItem targetItem) {
        for (int i = 0; i < this.itemLabelsPanel.getComponentCount(); ++i) {
            Component component = this.itemLabelsPanel.getComponent(i);
            if (!(component instanceof NavigatorItemLabel)) continue;
            NavigatorItemLabel label = (NavigatorItemLabel)component;
            label.toggleState(label.getText().equals(targetItem.getLabelName()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof NavigatorItemLabel) {
            NavigatorItemLabel lbl = (NavigatorItemLabel)e.getSource();
            this.archivePanel.fireIntentionToSwitchActiveItem(lbl.getNavigatorItem());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static class NavigatorItemLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private final Color defaultBackground;
        private boolean on = false;
        private final NavigatorItem navigatorItem;

        public NavigatorItemLabel(String label, NavigatorItem navigatorItem, int indent) {
            super(label);
            this.navigatorItem = navigatorItem;
            int lpad = 10 + indent * 10;
            this.setBorder(BorderFactory.createEmptyBorder(3, lpad, 3, 10));
            this.defaultBackground = this.getBackground();
            this.setOpaque(true);
            this.setBackground(this.defaultBackground);
        }

        public NavigatorItem getNavigatorItem() {
            return this.navigatorItem;
        }

        public void toggleState(boolean on) {
            if (on && !this.on) {
                this.setBackground(UiColors.BORDER_COLOR);
            } else if (!on && this.on) {
                this.setDefaultBackground();
            }
            this.on = on;
        }

        public void setDefaultBackground() {
            this.setBackground(this.defaultBackground);
        }
    }
}

