/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import org.yamcs.ui.archivebrowser.ZoomSpec;
import org.yamcs.utils.TaiUtcConverter;
import org.yamcs.utils.TimeEncoding;

public class TMScale
extends JSlider {
    private static final long serialVersionUID = 1L;
    final SimpleDateFormat f_yyyy_MMM = TMScale.sdfFactory("yyyy\nMMM");
    final SimpleDateFormat f_MMM = TMScale.sdfFactory("MMM");
    final SimpleDateFormat f_yyyy_MM_dd = TMScale.sdfFactory("yyyy.MM\ndd");
    final SimpleDateFormat f_dd = TMScale.sdfFactory("dd");
    final SimpleDateFormat f_DDD = TMScale.sdfFactory("DDD");
    final SimpleDateFormat f_yyyy_DDD = TMScale.sdfFactory("yyyy\nDDD");
    final SimpleDateFormat f_yyyy_DDD_HH = TMScale.sdfFactory("yyyy/DDD\nHH");
    final SimpleDateFormat f_yyyy_MM_dd_HH = TMScale.sdfFactory("yyyy.MM.dd/DDD\nHH");
    final SimpleDateFormat f_yyyy_DDD_HH_mm = TMScale.sdfFactory("yyyy/DDD\nHH:mm");
    final SimpleDateFormat f_yyyy_MM_dd_HH_mm = TMScale.sdfFactory("yyyy.MM.dd/DDD\nHH:mm");
    final SimpleDateFormat f_HH = TMScale.sdfFactory("HH");
    final SimpleDateFormat f_HH_mm = TMScale.sdfFactory("HH:mm");
    final SimpleDateFormat f_mm = TMScale.sdfFactory("mm");
    Hashtable<Integer, JComponent> labels = new Hashtable();
    ZoomSpec zoom;
    long div;

    static SimpleDateFormat sdfFactory(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    public TMScale() {
        super(0, 0, 100, 100);
        this.setUI(new TMScaleUI(this));
        this.setBackground(Color.LIGHT_GRAY);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setPaintTrack(false);
        this.setFocusable(false);
        double wantedHeight = new JLabel("x").getPreferredSize().getHeight() * 2.0;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, (int)wantedHeight));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
    }

    private void addLabel(long instant, String labelString) {
        TwoLineLabel lab = new TwoLineLabel(this, labelString);
        this.labels.put((int)((instant - this.zoom.startInstant) / this.div), lab);
    }

    void setToZoom(ZoomSpec zoom) {
        block30: {
            long measure;
            Calendar cal;
            block26: {
                long instant;
                this.zoom = zoom;
                if (zoom.stopInstant - zoom.startInstant > 3153600000000L) {
                    throw new RuntimeException("Cannot show more than 100 years");
                }
                this.div = zoom.stopInstant - zoom.startInstant > 0xFFFFFFFL ? 1000L : 1L;
                this.labels.clear();
                cal = TMScale.getTruncatedCal(zoom.stopInstant);
                measure = (long)(500.0 * zoom.pixelRatio / 1000.0);
                if (measure <= 31536000L) break block26;
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    block29: {
                        SimpleDateFormat f;
                        block28: {
                            block27: {
                                if (cal.get(2) != 0) break block27;
                                f = this.f_yyyy_MMM;
                                break block28;
                            }
                            if (cal.get(2) % 3 != 0) break block29;
                            f = this.f_MMM;
                        }
                        this.addLabel(instant, f.format(cal.getTime()));
                    }
                    cal.add(2, -1);
                }
                break block30;
            }
            if (measure > 15552000L) {
                long instant;
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = cal.get(2) == 0 ? this.f_yyyy_MMM : this.f_MMM;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(2, -1);
                }
            } else if (measure > 2592000L) {
                long instant;
                cal.set(11, 0);
                cal.set(12, 0);
                int d = cal.get(5);
                d = d >= 22 ? 22 : (d >= 15 ? 15 : (d >= 8 ? 8 : 1));
                cal.set(5, d);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = d == 1 ? this.f_yyyy_MM_dd : this.f_dd;
                    this.addLabel(instant, f.format(cal.getTime()));
                    if (d == 1) {
                        cal.add(6, -1);
                        d = 22;
                    } else {
                        d -= 7;
                    }
                    cal.set(5, d);
                }
            } else if (measure > 691200L) {
                long instant;
                cal.set(11, 0);
                cal.set(12, 0);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = cal.get(7) == 2 ? this.f_yyyy_MM_dd : this.f_dd;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(6, -1);
                }
            } else if (measure > 86400L) {
                long instant;
                cal.set(11, 0);
                cal.set(12, 0);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = this.f_yyyy_MM_dd;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(6, -1);
                }
            } else if (measure > 10800L) {
                long instant;
                cal.set(12, 0);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = cal.get(10) == 0 ? this.f_yyyy_MM_dd_HH : this.f_HH;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(11, -1);
                }
            } else if (measure > 600L) {
                long instant;
                int m = cal.get(12);
                cal.set(12, m - m % 15);
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = cal.get(12) == 0 ? this.f_yyyy_MM_dd_HH : this.f_HH_mm;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(12, -15);
                }
            } else {
                long instant;
                while ((instant = TimeEncoding.fromCalendar((Calendar)cal)) > zoom.startInstant) {
                    SimpleDateFormat f = cal.get(12) % 10 == 0 ? this.f_yyyy_MM_dd_HH_mm : this.f_HH_mm;
                    this.addLabel(instant, f.format(cal.getTime()));
                    cal.add(12, -1);
                }
            }
        }
        this.setLabelTable(this.labels);
        this.setMinimum(0);
        this.setMaximum((int)((zoom.stopInstant - zoom.startInstant) / this.div));
        this.updateFontSize();
    }

    private Font getLabelFont() {
        return this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f);
    }

    static Calendar getTruncatedCal(long instant) {
        TaiUtcConverter.DateTimeComponents dtc = TimeEncoding.toUtc((long)instant);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(dtc.year, dtc.month - 1, dtc.day, dtc.hour, dtc.minute, 0);
        cal.set(14, 0);
        cal.setFirstDayOfWeek(2);
        return cal;
    }

    public void updateFontSize() {
        for (JComponent comp : this.labels.values()) {
            JLabel lbl = (JLabel)comp;
            Font smallerFont = this.getLabelFont();
            lbl.setFont(smallerFont);
            lbl.setSize(lbl.getPreferredSize());
        }
    }

    static class TMScaleUI
    extends BasicSliderUI {
        TMScaleUI(JSlider slider) {
            super(slider);
        }

        @Override
        protected Dimension getThumbSize() {
            if (this.slider.getOrientation() == 0) {
                return new Dimension(0, 0);
            }
            return super.getThumbSize();
        }

        @Override
        protected void calculateTickRect() {
            super.calculateTickRect();
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y += this.getHeightOfTallestLabel();
            }
        }

        @Override
        protected void calculateLabelRect() {
            super.calculateLabelRect();
            if (this.slider.getOrientation() == 0) {
                this.labelRect.y = this.trackRect.y + this.trackRect.height;
            }
        }

        @Override
        protected void calculateTrackBuffer() {
            this.trackBuffer = 0;
        }

        @Override
        public void paintTicks(Graphics g) {
            if (this.slider.getOrientation() == 0) {
                Dictionary dict = this.slider.getLabelTable();
                if (dict != null) {
                    g.setColor(Color.BLACK);
                    g.translate(0, this.tickRect.y);
                    Enumeration e = dict.keys();
                    while (e.hasMoreElements()) {
                        Integer tsint = (Integer)e.nextElement();
                        int ts = tsint;
                        int labelCenter = this.xPositionForValue(ts);
                        this.paintMajorTickForHorizSlider(g, this.tickRect, labelCenter);
                    }
                    g.translate(0, -this.tickRect.y);
                }
            } else {
                super.paintTicks(g);
            }
        }

        @Override
        protected int getTickLength() {
            return 6;
        }

        @Override
        protected int getHeightOfHighValueLabel() {
            return super.getHeightOfHighValueLabel() - 3;
        }

        @Override
        protected int getHeightOfLowValueLabel() {
            return super.getHeightOfLowValueLabel() - 3;
        }

        @Override
        protected void installListeners(JSlider jslider) {
            super.installListeners(jslider);
            jslider.removeMouseListener(this.trackListener);
            jslider.removeMouseMotionListener(this.trackListener);
        }
    }

    static class TwoLineLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        int lineHeight;
        String[] textlines;

        TwoLineLabel(TMScale scale, String text) {
            super(text);
            this.setFont(scale.getLabelFont());
            this.lineHeight = this.getPreferredSize().height;
            this.textlines = text.toUpperCase().split("\\n");
            if (this.textlines.length > 1) {
                this.setText(this.textlines[0]);
                int w0 = this.getPreferredSize().width;
                this.setText(this.textlines[1]);
                int w1 = this.getPreferredSize().width;
                int newWidth = Math.max(w0, w1);
                this.setPreferredSize(new Dimension(newWidth, this.lineHeight * 2));
            } else {
                this.setText(this.textlines[0]);
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.lineHeight * 2));
            }
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
        }

        @Override
        public void paint(Graphics g) {
            if (this.textlines.length > 1) {
                this.setText(this.textlines[0]);
                super.paint(g);
                this.setText(this.textlines[1]);
                g.translate(0, this.lineHeight);
                super.paint(g);
                g.translate(0, -this.lineHeight);
            } else {
                g.translate(0, this.lineHeight);
                super.paint(g);
                g.translate(0, -this.lineHeight);
            }
        }
    }
}

