/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.archivebrowser.DataView;
import org.yamcs.ui.archivebrowser.TagEditDialog;
import org.yamcs.ui.archivebrowser.TagTimeline;
import org.yamcs.ui.archivebrowser.ZoomSpec;
import org.yamcs.utils.TimeEncoding;

public class TagBox
extends Box
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private DataView dataView;
    boolean drawPreviewLocator;
    long startLocator;
    long stopLocator;
    long currentLocator;
    final long DO_NOT_DRAW = Long.MIN_VALUE;
    JLabel tagLabelItem;
    JPopupMenu editTagPopup;
    JPopupMenu newTagPopup;
    JMenuItem removeTagMenuItem;
    JMenuItem editTagMenuItem;
    int selectedRow = -1;
    int selectedIndex = -1;
    List<List<Yamcs.ArchiveTag>> tags = new ArrayList<List<Yamcs.ArchiveTag>>();
    TagEditDialog tagEditDialog;
    ZoomSpec zoom;

    private void buildTagEditDialog() {
        if (this.tagEditDialog == null) {
            this.tagEditDialog = new TagEditDialog(null);
            this.tagEditDialog.setModal(true);
        }
    }

    TagBox(DataView dataView) {
        super(3);
        this.dataView = dataView;
        this.currentLocator = Long.MIN_VALUE;
        this.stopLocator = Long.MIN_VALUE;
        this.startLocator = Long.MIN_VALUE;
        this.drawPreviewLocator = false;
        this.setOpaque(false);
        ToolTipManager ttmgr = ToolTipManager.sharedInstance();
        ttmgr.setInitialDelay(0);
        ttmgr.setReshowDelay(0);
        ttmgr.setDismissDelay(Integer.MAX_VALUE);
        this.buildPopup();
        this.addMouseListener(this);
    }

    private void insertTag(Yamcs.ArchiveTag tag) {
        boolean inserted = false;
        for (List<Yamcs.ArchiveTag> atl : this.tags) {
            int min = 0;
            int max = atl.size() - 1;
            while (min <= max) {
                int mid = min + max >> 1;
                Yamcs.ArchiveTag midtag = atl.get(mid);
                if (tag.hasStop() && midtag.hasStart() && tag.getStop() < midtag.getStart()) {
                    max = mid - 1;
                    continue;
                }
                if (!tag.hasStart() || !midtag.hasStop() || tag.getStart() <= midtag.getStop()) break;
                min = mid + 1;
            }
            if (min <= max) continue;
            atl.add(min, tag);
            inserted = true;
            break;
        }
        if (!inserted) {
            ArrayList<Yamcs.ArchiveTag> atl = new ArrayList<Yamcs.ArchiveTag>();
            atl.add(tag);
            this.tags.add(atl);
        }
    }

    protected void buildPopup() {
        this.editTagPopup = new JPopupMenu();
        this.tagLabelItem = new JLabel();
        this.tagLabelItem.setEnabled(false);
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.tagLabelItem);
        hbox.add(Box.createHorizontalGlue());
        this.editTagPopup.insert(hbox, 0);
        this.editTagPopup.addSeparator();
        this.editTagMenuItem = new JMenuItem("Edit Tag");
        this.editTagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagBox.this.buildTagEditDialog();
                Yamcs.ArchiveTag selectedTag = TagBox.this.tags.get(TagBox.this.selectedRow).get(TagBox.this.selectedIndex);
                TagBox.this.tagEditDialog.fillFrom(selectedTag);
                TagBox.this.tagEditDialog.setVisible(true);
                if (TagBox.this.tagEditDialog.ok) {
                    TagBox.this.dataView.emitActionEvent(new TagEvent((Object)this, "update-tag", selectedTag, TagBox.this.tagEditDialog.getTag()));
                }
            }
        });
        this.editTagPopup.add(this.editTagMenuItem);
        this.removeTagMenuItem = new JMenuItem("Remove Tag");
        this.removeTagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Yamcs.ArchiveTag selectedTag = TagBox.this.tags.get(TagBox.this.selectedRow).get(TagBox.this.selectedIndex);
                int answer = JOptionPane.showConfirmDialog(null, "Remove " + selectedTag.getName() + " ?", "Are you sure?", 0);
                if (answer == 0) {
                    TagBox.this.dataView.emitActionEvent(new TagEvent((Object)this, "delete-tag", selectedTag, null));
                }
            }
        });
        this.editTagPopup.add(this.removeTagMenuItem);
        this.newTagPopup = new JPopupMenu();
        JMenuItem newTagMenuItem = new JMenuItem("New Tag");
        newTagMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagBox.this.buildTagEditDialog();
                TagBox.this.tagEditDialog.setVisible(true);
                if (TagBox.this.tagEditDialog.ok) {
                    TagBox.this.dataView.emitActionEvent(new TagEvent((Object)this, "insert-tag", null, TagBox.this.tagEditDialog.getTag()));
                }
            }
        });
        this.newTagPopup.add(newTagMenuItem);
    }

    public void createNewTag(long start, long stop) {
        this.buildTagEditDialog();
        this.tagEditDialog.startTextField.setValue(start);
        this.tagEditDialog.stopTextField.setValue(stop);
        this.tagEditDialog.setVisible(true);
        if (this.tagEditDialog.ok) {
            this.dataView.emitActionEvent(new TagEvent((Object)this, "insert-tag", null, this.tagEditDialog.getTag()));
        }
    }

    public void doMousePressed(MouseEvent e, int row, int index) {
        this.selectedRow = row;
        this.selectedIndex = index;
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        } else if (e.getButton() == 1 && this.selectedRow != -1 && this.selectedIndex != -1) {
            this.dataView.selectedTag(this.tags.get(this.selectedRow).get(this.selectedIndex));
        }
    }

    void showPopup(MouseEvent e) {
        if (this.selectedIndex != -1) {
            Yamcs.ArchiveTag selectedTag = this.tags.get(this.selectedRow).get(this.selectedIndex);
            this.tagLabelItem.setText(selectedTag.getName());
            this.editTagPopup.validate();
            this.editTagPopup.show(e.getComponent(), e.getX(), e.getY());
        } else {
            this.newTagPopup.validate();
            this.newTagPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(event.getX() - 94, event.getY() + 20);
    }

    void setToZoom(ZoomSpec zoom) {
        this.zoom = zoom;
        this.redrawTags();
    }

    void redrawTags() {
        this.removeAll();
        if (!this.tags.isEmpty()) {
            int row = this.tags.size() - 1;
            Insets in = this.getInsets();
            ListIterator<List<Yamcs.ArchiveTag>> it = this.tags.listIterator(this.tags.size());
            while (it.hasPrevious()) {
                List<Yamcs.ArchiveTag> lat = it.previous();
                TagTimeline tt = new TagTimeline(this, lat, this.zoom, row--, in.left);
                this.add(tt);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.doMousePressed(e, -1, -1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public static void main(String[] args) {
        TimeEncoding.setUp();
        JFrame frame = new JFrame();
        frame.setSize(new Dimension(1000, 100));
        TagBox atb = new TagBox(null);
        atb.setToZoom(new ZoomSpec(0L, 3600000L, 3600000, 10800000L));
        frame.add(atb);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public void addTags(List<Yamcs.ArchiveTag> tagList) {
        for (Yamcs.ArchiveTag tag : tagList) {
            this.insertTag(tag);
        }
        if (!this.dataView.zoomStack.empty()) {
            this.redrawTags();
        }
    }

    public void addTag(Yamcs.ArchiveTag tag) {
        this.insertTag(tag);
        this.redrawTags();
    }

    public void removeTag(Yamcs.ArchiveTag rtag) {
        long t = rtag.hasStart() ? rtag.getStart() : rtag.getStop();
        for (List<Yamcs.ArchiveTag> tagList : this.tags) {
            int id = TagTimeline.time2Tag(tagList, t);
            if (id == -1 || !rtag.equals((Object)tagList.get(id))) continue;
            tagList.remove(id);
            if (tagList.isEmpty()) {
                this.tags.remove(tagList);
            }
            this.redrawTags();
            return;
        }
        JOptionPane.showMessageDialog(null, "Could not find  " + rtag.toString() + " to remove");
    }

    public void updateTag(Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
        long t = oldTag.hasStart() ? oldTag.getStart() : oldTag.getStop();
        for (List<Yamcs.ArchiveTag> tagList : this.tags) {
            int id = TagTimeline.time2Tag(tagList, t);
            if (id == -1 || !oldTag.equals((Object)tagList.get(id))) continue;
            tagList.remove(id);
            this.insertTag(newTag);
            this.redrawTags();
            return;
        }
        JOptionPane.showMessageDialog(null, "Could not find  " + oldTag.toString() + " to remove");
    }

    public static class TagEvent
    extends ActionEvent {
        public Yamcs.ArchiveTag newTag;
        public Yamcs.ArchiveTag oldTag;

        public TagEvent(Object source, String command, Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
            super(source, 1001, command);
            this.newTag = newTag;
            this.oldTag = oldTag;
        }
    }
}

