/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.archivebrowser.ColorRenderer;
import org.yamcs.ui.archivebrowser.ColorUtils;
import org.yamcs.ui.archivebrowser.InstantFormat;
import org.yamcs.ui.archivebrowser.TimeFieldVerifier;

public class TagEditDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel jPanel1 = null;
    private JLabel nameLabel = null;
    private JLabel startLabel = null;
    private JLabel stopLabel = null;
    private JLabel descriptionLabel = null;
    JTextField nameTextField = null;
    public JFormattedTextField startTextField = null;
    public JFormattedTextField stopTextField = null;
    private JEditorPane descriptionEditorPane = null;
    private JLabel jLabel = null;
    private InstantFormat iformat = new InstantFormat();
    public boolean ok = false;
    private JLabel jLabel1 = null;
    private JComboBox colorComboBox = null;

    public TagEditDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(356, 332);
        this.setTitle("Edit Tag");
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("ok")) {
            try {
                long start = (Long)this.startTextField.getValue();
                long stop = (Long)this.stopTextField.getValue();
                if (start == Long.MIN_VALUE && stop == Long.MIN_VALUE) {
                    JOptionPane.showMessageDialog(this, "At least one of start or stop has to be specified", "Please specify the start or stop", 0);
                    return;
                }
                if (start != Long.MIN_VALUE && stop != Long.MIN_VALUE && start > stop) {
                    JOptionPane.showMessageDialog(this, "Stop has to be greater than start", "Invalid times", 0);
                    return;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error parsing time: " + e1.getMessage(), "Error parsing time", 0);
                return;
            }
            this.ok = true;
            this.setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.ok = false;
            this.setVisible(false);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Edit Tag");
            this.jLabel.setHorizontalAlignment(0);
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout);
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getJPanel1(), "Center");
            this.jContentPane.add((Component)this.jLabel, "North");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("  OK  ");
            this.okButton.setActionCommand("ok");
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(this);
            this.cancelButton.setVerifyInputWhenFocusTarget(false);
        }
        return this.cancelButton;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.ipadx = 2;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.gridy = 3;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Color: ");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridheight = 2;
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.fill = 0;
            gridBagConstraints31.gridy = 2;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 0;
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.gridwidth = 1;
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.ipadx = 2;
            gridBagConstraints3.gridy = 4;
            this.descriptionLabel = new JLabel();
            this.descriptionLabel.setText("Description: ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.ipadx = 2;
            gridBagConstraints2.gridy = 2;
            this.stopLabel = new JLabel();
            this.stopLabel.setText("Stop: ");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.ipadx = 2;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridy = 1;
            this.startLabel = new JLabel();
            this.startLabel.setText("Start: ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.ipadx = 2;
            gridBagConstraints.gridy = 0;
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name: ");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.nameLabel, gridBagConstraints);
            this.jPanel1.add((Component)this.startLabel, gridBagConstraints1);
            this.jPanel1.add((Component)this.stopLabel, gridBagConstraints2);
            this.jPanel1.add((Component)this.descriptionLabel, gridBagConstraints3);
            this.jPanel1.add((Component)this.getNameTextField(), gridBagConstraints11);
            this.jPanel1.add((Component)this.getStartTextField(), gridBagConstraints21);
            this.jPanel1.add((Component)this.getStopTextField(), gridBagConstraints31);
            this.jPanel1.add((Component)this.getDescriptionEditorPane(), gridBagConstraints5);
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints6);
            this.jPanel1.add((Component)this.getColorComboBox(), gridBagConstraints7);
        }
        return this.jPanel1;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
        }
        return this.nameTextField;
    }

    private JTextField getStartTextField() {
        if (this.startTextField == null) {
            this.startTextField = new JFormattedTextField(this.iformat);
            this.startTextField.setMinimumSize(new Dimension(180, this.startTextField.getPreferredSize().height));
            this.startTextField.setInputVerifier(new TimeFieldVerifier());
        }
        return this.startTextField;
    }

    private JTextField getStopTextField() {
        if (this.stopTextField == null) {
            this.stopTextField = new JFormattedTextField(this.iformat);
            this.stopTextField.setMinimumSize(new Dimension(180, this.stopTextField.getPreferredSize().height));
            this.stopTextField.setInputVerifier(new TimeFieldVerifier());
        }
        return this.stopTextField;
    }

    private JEditorPane getDescriptionEditorPane() {
        if (this.descriptionEditorPane == null) {
            this.descriptionEditorPane = new JEditorPane();
        }
        return this.descriptionEditorPane;
    }

    public void fillFrom(Yamcs.ArchiveTag tag) {
        this.nameTextField.setText(tag.getName());
        if (tag.hasStart()) {
            this.startTextField.setValue(tag.getStart());
        } else {
            this.startTextField.setValue(Long.MIN_VALUE);
        }
        if (tag.hasStop()) {
            this.stopTextField.setValue(tag.getStop());
        } else {
            this.stopTextField.setValue(Long.MIN_VALUE);
        }
        if (tag.hasDescription()) {
            this.descriptionEditorPane.setText(tag.getDescription());
        } else {
            this.descriptionEditorPane.setText("");
        }
        if (tag.hasColor()) {
            this.colorComboBox.setSelectedItem(tag.getColor());
        }
    }

    private JComboBox getColorComboBox() {
        if (this.colorComboBox == null) {
            this.colorComboBox = new JComboBox<Object>(ColorUtils.colors.keySet().toArray());
            this.colorComboBox.setPreferredSize(new Dimension(180, this.colorComboBox.getPreferredSize().height));
            this.colorComboBox.setRenderer(new ColorRenderer(this.colorComboBox.getPreferredSize().height - 2));
        }
        return this.colorComboBox;
    }

    public Yamcs.ArchiveTag getTag() {
        long stop;
        Yamcs.ArchiveTag.Builder atb = Yamcs.ArchiveTag.newBuilder();
        atb.setName(this.nameTextField.getText());
        atb.setColor((String)this.colorComboBox.getSelectedItem());
        long start = (Long)this.startTextField.getValue();
        if (start != Long.MIN_VALUE) {
            atb.setStart(start);
        }
        if ((stop = ((Long)this.stopTextField.getValue()).longValue()) != Long.MIN_VALUE) {
            atb.setStop(stop);
        }
        if (!this.descriptionEditorPane.getText().isEmpty()) {
            atb.setDescription(this.descriptionEditorPane.getText());
        }
        return atb.build();
    }
}

