/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.archivebrowser.ColorUtils;
import org.yamcs.ui.archivebrowser.TagBox;
import org.yamcs.ui.archivebrowser.ZoomSpec;
import org.yamcs.utils.TimeEncoding;

public class TagTimeline
extends JPanel
implements MouseInputListener {
    private static final long serialVersionUID = 1L;
    private final TagBox tagBox;
    List<Yamcs.ArchiveTag> tags;
    ZoomSpec zoom;
    int leftDelta;
    BufferedImage image = null;
    int row;
    Font f;
    Yamcs.ArchiveTag lastMouseTag = null;

    TagTimeline(TagBox tagBox, List<Yamcs.ArchiveTag> tags, ZoomSpec zoom, int row, int leftDelta) {
        this.tagBox = tagBox;
        this.zoom = zoom;
        this.tags = tags;
        this.row = row;
        this.leftDelta = leftDelta;
        JLabel l = new JLabel("X");
        this.f = TagTimeline.deriveFont(l.getFont());
        l.setFont(this.f);
        this.setMinimumSize(new Dimension(0, 2 + l.getPreferredSize().height));
        this.setPreferredSize(this.getMinimumSize());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 2 + l.getPreferredSize().height));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setOpaque(false);
    }

    private static Font deriveFont(Font f) {
        return f.deriveFont(0, f.getSize2D() - 2.0f);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.tagBox.getToolTipLocation(e);
    }

    private MouseEvent translateEvent(MouseEvent e, Component dest) {
        return SwingUtilities.convertMouseEvent(e.getComponent(), e, dest);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        long t = this.zoom.convertPixelToInstant(e.getX());
        int index = TagTimeline.time2Tag(this.tags, t);
        this.tagBox.doMousePressed(this.translateEvent(e, this.tagBox), this.row, index);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getParent().dispatchEvent(this.translateEvent(e, this.getParent()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        long t = this.zoom.convertPixelToInstant(e.getX() + this.leftDelta);
        int index = TagTimeline.time2Tag(this.tags, t);
        Yamcs.ArchiveTag at = null;
        if (index != -1) {
            at = this.tags.get(index);
        }
        if (at == this.lastMouseTag) {
            return;
        }
        this.lastMouseTag = at;
        if (at != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            StringBuilder sb = new StringBuilder();
            sb.append("<html>").append(at.getName()).append("<hr>");
            if (at.hasStart()) {
                sb.append("Start: ").append(TimeEncoding.toString((long)at.getStart())).append("<br>");
            }
            if (at.hasStop()) {
                sb.append("Stop: ").append(TimeEncoding.toString((long)at.getStop())).append("<br>");
            }
            if (at.hasDescription()) {
                sb.append(at.getDescription());
            }
            sb.append("</html>");
            this.setToolTipText(sb.toString());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setToolTipText(null);
        }
    }

    static int time2Tag(List<Yamcs.ArchiveTag> tagList, long t) {
        int min = 0;
        int max = tagList.size() - 1;
        while (min <= max) {
            int mid = min + max >> 1;
            Yamcs.ArchiveTag atmid = tagList.get(mid);
            if (!atmid.hasStart() || atmid.getStart() <= t) {
                if (!atmid.hasStop() || atmid.getStop() >= t) {
                    return mid;
                }
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchEvent(new MouseEvent(e.getComponent(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D big = this.image.createGraphics();
            big.setComposite(AlphaComposite.getInstance(1));
            big.fillRect(0, 0, this.getWidth(), this.getHeight());
            big.setComposite(AlphaComposite.getInstance(3));
            for (Yamcs.ArchiveTag at : this.tags) {
                Color fgcolor;
                Color bgcolor;
                if (at.hasColor()) {
                    bgcolor = ColorUtils.getColor(at.getColor());
                    fgcolor = ColorUtils.getOpposite(at.getColor());
                } else {
                    bgcolor = Color.white;
                    fgcolor = Color.black;
                }
                big.setColor(bgcolor);
                long start = at.hasStart() ? at.getStart() : this.zoom.startInstant;
                int x1 = this.zoom.convertInstantToPixel(start);
                long stop = at.hasStop() ? at.getStop() : this.zoom.stopInstant;
                int x2 = this.zoom.convertInstantToPixel(stop);
                if (x1 <= 0 && x2 < 0) continue;
                if (x1 < 0) {
                    x1 = 0;
                }
                int width = x2 - x1 <= 1 ? 1 : x2 - x1 - 1;
                big.fillRect(x1 - this.leftDelta, 0, width, this.getHeight());
                big.setColor(fgcolor);
                big.setFont(this.f);
                Rectangle2D bounds = this.f.getStringBounds(at.getName(), big.getFontRenderContext());
                if ((double)width > bounds.getWidth()) {
                    LineMetrics lm = this.f.getLineMetrics(at.getName(), big.getFontRenderContext());
                    big.drawString(at.getName(), x1 - this.leftDelta + 1, (int)lm.getAscent() + 1);
                }
                big.setColor(Color.DARK_GRAY);
                big.drawRect(x1 - this.leftDelta, 0, width - 1, this.getHeight() - 1);
            }
        }
        g.drawImage(this.image, 0, 0, this);
    }
}

