/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.ui.archivebrowser.IndexBox;
import org.yamcs.ui.archivebrowser.ZoomSpec;
import org.yamcs.utils.TaiUtcConverter;
import org.yamcs.utils.TimeEncoding;

class Timeline
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private final IndexBox tmBox;
    TreeSet<ArchivePanel.IndexChunkSpec> tmspec;
    IndexBox.IndexLineSpec pkt;
    Color color;
    ZoomSpec zoom;
    int leftDelta;
    BufferedImage image = null;

    Timeline(IndexBox tmBox, IndexBox.IndexLineSpec pkt, TreeSet<ArchivePanel.IndexChunkSpec> tmspec, ZoomSpec zoom, int leftDelta) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.tmBox = tmBox;
        this.pkt = pkt;
        this.color = pkt.color;
        this.zoom = zoom;
        this.leftDelta = leftDelta;
        this.addMouseListener(this);
        this.setOpaque(false);
        this.tmspec = tmspec;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return this.tmBox.getToolTipLocation(e);
    }

    private MouseEvent translateEvent(MouseEvent e, Component dest) {
        MouseEvent me = SwingUtilities.convertMouseEvent(e.getComponent(), e, dest);
        return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getXOnScreen(), me.getYOnScreen(), me.getClickCount(), me.isPopupTrigger(), e.getButton());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.tmBox.selectedPacket = this.pkt;
            this.tmBox.showPopup(this.translateEvent(e, this.tmBox));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.tmBox.selectedPacket = this.pkt;
            this.tmBox.showPopup(this.translateEvent(e, this.tmBox));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        MouseEvent transEvent = this.translateEvent(e, this.tmBox);
        this.setToolTipText(TimeEncoding.toCombinedFormat((long)this.tmBox.dataView.getMouseInstant(transEvent)));
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tt = TimeEncoding.toCombinedFormat((long)this.tmBox.dataView.getMouseInstant(this.translateEvent(e, this.tmBox)));
        ArchivePanel.IndexChunkSpec c1 = this.zoom.convertPixelToChunk(this.translateEvent(e, this.tmBox).getX());
        ArchivePanel.IndexChunkSpec chunk = this.tmspec.floor(c1);
        if (!(chunk != null && chunk.stopInstant >= c1.startInstant || (chunk = this.tmspec.ceiling(c1)) != null && chunk.startInstant <= c1.stopInstant)) {
            return tt;
        }
        TaiUtcConverter.DateTimeComponents dtcStart = TimeEncoding.toUtc((long)chunk.startInstant);
        TaiUtcConverter.DateTimeComponents dtcStop = TimeEncoding.toUtc((long)chunk.stopInstant);
        String timestring = dtcStart.year == dtcStop.year && dtcStart.doy == dtcStop.doy ? String.format("%s - %s", TimeEncoding.toCombinedFormat((long)chunk.startInstant), dtcStop.toIso8860String()) : String.format("%s - %s", TimeEncoding.toCombinedFormat((long)chunk.startInstant), TimeEncoding.toCombinedFormat((long)chunk.stopInstant));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(tt).append("<hr>Index Record: ").append(chunk.tmcount).append(" Packets");
        if (chunk.tmcount > 1) {
            sb.append(" @ ").append(chunk.getFrequency()).append("Hz");
        }
        sb.append("<br>").append(timestring);
        if (chunk.info != null) {
            sb.append("<br>").append(chunk.info);
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D big = this.image.createGraphics();
            big.setComposite(AlphaComposite.getInstance(1));
            big.fillRect(0, 0, this.getWidth(), this.getHeight());
            big.setComposite(AlphaComposite.getInstance(3));
            big.setColor(this.color);
            for (ArchivePanel.IndexChunkSpec pkt : this.tmspec) {
                int x1 = this.zoom.convertInstantToPixel(pkt.startInstant);
                int x2 = this.zoom.convertInstantToPixel(pkt.stopInstant);
                int width = x2 - x1 <= 1 ? 1 : x2 - x1 - 1;
                big.fillRect(x1 - this.leftDelta, 0, width, this.getHeight());
            }
        }
        g.drawImage(this.image, 0, 0, this);
    }
}

