/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import org.yamcs.ui.archivebrowser.ArchivePanel;

public class ZoomSpec {
    long startInstant;
    long stopInstant;
    long selectionStart;
    long selectionStop;
    long viewLocation;
    long viewTimeWindow;
    double pixelRatio;

    ZoomSpec(long start, long stop, int pixelwidth, long viewTimeWindow) {
        this.startInstant = start;
        this.stopInstant = stop;
        this.viewTimeWindow = viewTimeWindow;
        this.viewLocation = start;
        this.setPixels(pixelwidth);
        this.selectionStart = Long.MIN_VALUE;
        this.selectionStop = Long.MIN_VALUE;
    }

    void setSelectedRange(long selectionStart, long selectionStop) {
        this.selectionStart = selectionStart;
        this.selectionStop = selectionStop;
    }

    void setPixels(int pixelwidth) {
        this.pixelRatio = (double)this.viewTimeWindow / (double)pixelwidth;
    }

    int getPixels() {
        return this.convertInstantToPixel(this.stopInstant);
    }

    int convertInstantToPixel(long ms) {
        return (int)Math.round((double)(ms - this.startInstant) / this.pixelRatio);
    }

    long convertPixelToInstant(int x) {
        return (long)((double)x * this.pixelRatio) + this.startInstant;
    }

    public ArchivePanel.IndexChunkSpec convertPixelToChunk(int x) {
        return new ArchivePanel.IndexChunkSpec((long)((double)x * this.pixelRatio) + this.startInstant, (long)((double)(x + 1) * this.pixelRatio) + this.startInstant - 1L, 0, null);
    }

    public String toString() {
        return "start: " + this.startInstant + " stop:" + this.stopInstant + " viewTimeWindow: " + this.viewTimeWindow + " pixelRatio: " + this.pixelRatio;
    }
}

