/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.datepicker;

import java.awt.Component;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jdatepicker.DateModel;
import net.sourceforge.jdatepicker.JDateComponentFactory;
import net.sourceforge.jdatepicker.impl.JDatePickerImpl;
import net.sourceforge.jdatepicker.impl.UtilCalendarModel;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.TimeInterval;

public final class DatePicker
extends JPanel {
    MyDatePicker start;
    MyDatePicker end;
    JComboBox<String> fixedRangesComboBox;

    public DatePicker() {
        this.setLayout(new BoxLayout(this, 0));
        String[] fixedRanges = new String[]{"Select Last...", "day", "week", "month", "3 months", "6 months", "12 months"};
        int[][] fixedRangesTime = new int[][]{new int[0], {5, 1}, {3, 1}, {2, 1}, {2, 3}, {2, 6}, {2, 12}};
        this.fixedRangesComboBox = new JComboBox<String>(fixedRanges);
        this.fixedRangesComboBox.setSelectedIndex(0);
        this.start = new MyDatePicker();
        this.end = new MyDatePicker();
        this.fixedRangesComboBox.addActionListener(e -> {
            int idx = this.fixedRangesComboBox.getSelectedIndex();
            if (idx != 0) {
                Calendar startCal = Calendar.getInstance();
                startCal.set(11, 0);
                startCal.set(12, 0);
                startCal.set(13, 0);
                startCal.set(14, 0);
                startCal.add(5, 1);
                this.end.setTime(startCal);
                Calendar endCal = Calendar.getInstance();
                int[] x = fixedRangesTime[idx];
                endCal.add(x[0], -x[1]);
                this.start.setTime(endCal);
            }
        });
        this.add((Component)this.start.datePicker);
        this.add((Component)this.end.datePicker);
        this.add(this.fixedRangesComboBox);
    }

    public long getStartTimestamp() {
        if (this.start.getValue() == null) {
            return Long.MIN_VALUE;
        }
        return TimeEncoding.fromCalendar((Calendar)this.start.getValue());
    }

    public long getEndTimestamp() {
        if (this.end.getValue() == null) {
            return Long.MIN_VALUE;
        }
        return TimeEncoding.fromCalendar((Calendar)this.end.getValue());
    }

    public TimeInterval getInterval() {
        TimeInterval ti = new TimeInterval();
        Calendar calStart = this.start.getValue();
        Calendar calEnd = this.end.getValue();
        if (calStart != null) {
            ti.setStart(TimeEncoding.fromCalendar((Calendar)calStart));
        }
        if (calEnd != null) {
            ti.setEnd(TimeEncoding.fromCalendar((Calendar)calEnd));
        }
        return ti;
    }

    public void setStartTimestamp(long t) {
        this.start.setTime(TimeEncoding.toCalendar((long)t));
    }

    public void setEndTimestamp(long t) {
        this.end.setTime(TimeEncoding.toCalendar((long)t));
    }

    class MyDatePicker {
        JDatePickerImpl datePicker;
        YamcsDateTimeFormatter formatter = new YamcsDateTimeFormatter();
        UtilCalendarModel calendarModel = new UtilCalendarModel();
        Calendar calendar = null;

        MyDatePicker() {
            this.datePicker = (JDatePickerImpl)JDateComponentFactory.createJDatePicker((DateModel)this.calendarModel, (JFormattedTextField.AbstractFormatter)this.formatter);
            this.datePicker.getModel().setSelected(true);
            this.datePicker.setTextEditable(true);
            this.datePicker.addActionListener(e -> {
                if (DatePicker.this.fixedRangesComboBox.getSelectedIndex() != 0) {
                    DatePicker.this.fixedRangesComboBox.setSelectedIndex(0);
                }
            });
        }

        public Calendar getValue() {
            if (this.calendar == null) {
                return null;
            }
            Calendar cal = (Calendar)this.calendarModel.getValue();
            this.copyHhMmSs(this.calendar, cal);
            return cal;
        }

        public void setTime(Calendar cal) {
            if (cal == null) {
                this.calendar = null;
                this.calendarModel.setValue(null);
            } else {
                if (this.calendar == null) {
                    this.calendar = Calendar.getInstance();
                }
                this.calendar.setTime(cal.getTime());
                this.calendarModel.setValue((Object)cal);
            }
        }

        void copyHhMmSs(Calendar from, Calendar to) {
            to.set(11, from.get(11));
            to.set(12, from.get(12));
            to.set(13, from.get(13));
            to.set(14, from.get(14));
        }

        private class YamcsDateTimeFormatter
        extends JFormattedTextField.AbstractFormatter {
            private static final long serialVersionUID = -4371640422279341322L;

            private YamcsDateTimeFormatter() {
            }

            @Override
            public Object stringToValue(String dateString) throws ParseException {
                String[] patterns;
                if (dateString.isEmpty()) {
                    MyDatePicker.this.calendar = null;
                    return null;
                }
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat simpleDateFormatter = new SimpleDateFormat();
                simpleDateFormatter.setCalendar(MyDatePicker.this.calendar);
                for (String p : patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"}) {
                    simpleDateFormatter.applyPattern(p);
                    try {
                        Date date = simpleDateFormatter.parse(dateString);
                        cal.setTime(date);
                        MyDatePicker.this.copyHhMmSs(cal, MyDatePicker.this.calendar);
                        return cal;
                    }
                    catch (ParseException parseException) {
                    }
                }
                JOptionPane.showMessageDialog(null, "The date can only be in one of the following formats:\nyyyy-mm-dd\nyyyy-mm-ddThh:mm:ss\nyyyy-mm-ddThh:mm:ss.sss.", "Unparseable date error!", 0);
                throw new ParseException("Not a valid YAMCS DateTime string", 0);
            }

            @Override
            public String valueToString(Object value) {
                if (MyDatePicker.this.calendar == null) {
                    MyDatePicker.this.calendar = Calendar.getInstance();
                    MyDatePicker.this.calendar.set(11, 0);
                    MyDatePicker.this.calendar.set(12, 0);
                    MyDatePicker.this.calendar.set(13, 0);
                    MyDatePicker.this.calendar.set(14, 0);
                }
                if (value != null) {
                    Calendar cal = (Calendar)value;
                    MyDatePicker.this.copyHhMmSs(MyDatePicker.this.calendar, cal);
                    SimpleDateFormat simpleDateFormatter = new SimpleDateFormat();
                    simpleDateFormatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
                    return simpleDateFormatter.format(cal.getTime());
                }
                MyDatePicker.this.calendar = null;
                return null;
            }
        }
    }
}

