/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.utils.TimeEncoding;

public class EventDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final KeyStroke KEY_ESC = KeyStroke.getKeyStroke(27, 0);
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel labelSource;
    private JTextField textFieldSource;
    private JLabel labelType;
    private JTextField textFieldType;
    private JLabel labelSequenceNum;
    private JTextField textFieldSequenceNo;
    private JLabel labelGenerationTime;
    private JTextField textFieldGenerationTime;
    private JLabel labelReceptionTime;
    private JTextField textFieldReceptionTime;
    private JLabel labelSeverity;
    private JTextField textFieldSeverity;
    private JLabel labelMessage;
    private JScrollPane scrollPane1;
    private JTextArea textAreaMessage;
    private JPanel buttonBar;
    private JButton okButton;

    public EventDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.getRootPane().getInputMap(2).put(KEY_ESC, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                EventDialog.this.dispatchEvent(new WindowEvent(EventDialog.this, 201));
            }
        });
    }

    public void setEvent(Yamcs.Event event) {
        this.textFieldSource.setText(event.getSource());
        this.textFieldGenerationTime.setText(TimeEncoding.toCombinedFormat((long)event.getGenerationTime()));
        this.textFieldReceptionTime.setText(TimeEncoding.toCombinedFormat((long)event.getReceptionTime()));
        this.textAreaMessage.setText(event.getMessage());
        this.textAreaMessage.setCaretPosition(0);
        this.textFieldSequenceNo.setText(Integer.toString(event.getSeqNumber()));
        this.textFieldSeverity.setText(event.getSeverity().toString());
        this.textFieldType.setText(event.getType());
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.labelSource = new JLabel();
        this.textFieldSource = new JTextField();
        this.labelType = new JLabel();
        this.textFieldType = new JTextField();
        this.labelSequenceNum = new JLabel();
        this.textFieldSequenceNo = new JTextField();
        this.labelGenerationTime = new JLabel();
        this.textFieldGenerationTime = new JTextField();
        this.labelReceptionTime = new JLabel();
        this.textFieldReceptionTime = new JTextField();
        this.labelSeverity = new JLabel();
        this.textFieldSeverity = new JTextField();
        this.labelMessage = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.textAreaMessage = new JTextArea();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.setTitle("Event - detailed view");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.labelSource.setText("Source");
        this.labelSource.setBackground(Color.white);
        this.contentPanel.add((Component)this.labelSource, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldSource.setEditable(false);
        this.textFieldSource.setColumns(20);
        this.contentPanel.add((Component)this.textFieldSource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelType.setText("Type");
        this.contentPanel.add((Component)this.labelType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldType.setEditable(false);
        this.textFieldType.setColumns(20);
        this.contentPanel.add((Component)this.textFieldType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelSequenceNum.setText("Sequence number");
        this.contentPanel.add((Component)this.labelSequenceNum, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldSequenceNo.setEditable(false);
        this.contentPanel.add((Component)this.textFieldSequenceNo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelGenerationTime.setText("Generation time");
        this.contentPanel.add((Component)this.labelGenerationTime, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldGenerationTime.setEditable(false);
        this.textFieldGenerationTime.setColumns(20);
        this.contentPanel.add((Component)this.textFieldGenerationTime, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelReceptionTime.setText("Reception time");
        this.contentPanel.add((Component)this.labelReceptionTime, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldReceptionTime.setEditable(false);
        this.textFieldReceptionTime.setColumns(20);
        this.contentPanel.add((Component)this.textFieldReceptionTime, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelSeverity.setText("Severity");
        this.contentPanel.add((Component)this.labelSeverity, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.textFieldSeverity.setEditable(false);
        this.textFieldSeverity.setColumns(20);
        this.contentPanel.add((Component)this.textFieldSeverity, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.labelMessage.setText("Message");
        this.contentPanel.add((Component)this.labelMessage, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.textAreaMessage.setLineWrap(true);
        this.textAreaMessage.setRows(10);
        this.textAreaMessage.setWrapStyleWord(true);
        this.textAreaMessage.setEditable(false);
        this.textAreaMessage.setColumns(40);
        this.scrollPane1.setViewportView(this.textAreaMessage);
        this.contentPanel.add((Component)this.scrollPane1, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventDialog.this.dispose();
            }
        });
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

