/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.PrefsObject;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.eventviewer.EventTableModel;
import org.yamcs.ui.eventviewer.EventTableRenderer;

public class EventTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon INFO_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level0s.png"));
    private static final ImageIcon WATCH_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level1s.png"));
    private static final ImageIcon WARNING_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level2s.png"));
    private static final ImageIcon ERROR_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/error.png"));
    private static final ImageIcon DISTRESS_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level3s.png"));
    private static final ImageIcon CRITICAL_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level4s.png"));
    private static final ImageIcon SEVERE_ICON = new ImageIcon(EventTable.class.getResource("/org/yamcs/images/level5s.png"));
    private final EventTableRenderer renderer = new EventTableRenderer();
    private boolean inLayout;
    private Preferences uiPrefs;

    public EventTable(EventTableModel model) {
        super(model);
        this.setShowHorizontalLines(true);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.uiPrefs = Preferences.userNodeForPackage(EventTable.class);
        Object columnOrder = PrefsObject.getObject((Preferences)this.uiPrefs, (String)"ColumnOrder");
        if (columnOrder != null) {
            this.setColumnOrder((int[])columnOrder);
        }
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isRowSelected(row)) {
            c.setBackground(this.getBackground());
            int modelRow = this.convertRowIndexToModel(row);
            Yamcs.Event event = (Yamcs.Event)this.getModel().getValueAt(modelRow, 4);
            if (event.getSeverity() == Yamcs.Event.EventSeverity.ERROR) {
                c.setBackground(UiColors.ERROR_FAINT_BG);
            } else if (event.getSeverity() == Yamcs.Event.EventSeverity.WARNING) {
                c.setBackground(UiColors.WARNING_FAINT_BG);
            } else if (event.getSeverity() == Yamcs.Event.EventSeverity.WATCH) {
                c.setBackground(UiColors.WARNING_FAINT_BG);
            } else if (event.getSeverity() == Yamcs.Event.EventSeverity.DISTRESS) {
                c.setBackground(UiColors.DISTRESS_FAINT_BG);
            } else if (event.getSeverity() == Yamcs.Event.EventSeverity.CRITICAL) {
                c.setBackground(UiColors.CRITICAL_FAINT_BG);
            } else if (event.getSeverity() == Yamcs.Event.EventSeverity.SEVERE) {
                c.setBackground(UiColors.SEVERE_FAINT_BG);
            }
        }
        ((JComponent)c).setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UiColors.BORDER_COLOR));
        return c;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.convertColumnIndexToModel(column) == 4) {
            return this.renderer;
        }
        if (this.convertColumnIndexToModel(column) == 0) {
            return new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                    int modelRow = EventTable.this.convertRowIndexToModel(row);
                    Yamcs.Event event = (Yamcs.Event)EventTable.this.getModel().getValueAt(modelRow, 4);
                    if (event.getSeverity() == Yamcs.Event.EventSeverity.ERROR) {
                        this.setIcon(ERROR_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.INFO) {
                        this.setIcon(INFO_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.WATCH) {
                        this.setIcon(WATCH_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.WARNING) {
                        this.setIcon(WARNING_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.DISTRESS) {
                        this.setIcon(DISTRESS_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.CRITICAL) {
                        this.setIcon(CRITICAL_ICON);
                    } else if (event.getSeverity() == Yamcs.Event.EventSeverity.SEVERE) {
                        this.setIcon(SEVERE_ICON);
                    }
                    return this;
                }
            };
        }
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
        };
    }

    private void setColumnOrder(int[] indices) {
        int i;
        TableColumn[] columns = new TableColumn[this.columnModel.getColumnCount()];
        for (i = 0; i < this.columnModel.getColumnCount(); ++i) {
            columns[i] = this.columnModel.getColumn(i);
        }
        while (this.columnModel.getColumnCount() > 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
        for (i = 0; i < indices.length; ++i) {
            if (indices[i] >= columns.length) continue;
            this.columnModel.addColumn(columns[indices[i]]);
            columns[indices[i]] = null;
        }
        for (TableColumn column : columns) {
            if (column == null) continue;
            this.columnModel.addColumn(column);
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.hasExcessWidth();
    }

    @Override
    public void doLayout() {
        if (this.hasExcessWidth()) {
            this.autoResizeMode = 4;
        }
        this.inLayout = true;
        super.doLayout();
        this.inLayout = false;
        this.autoResizeMode = 0;
    }

    protected boolean hasExcessWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((resizingColumn = this.getTableHeader().getResizingColumn()) != null && this.autoResizeMode == 0 && !this.inLayout) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    public void storePreferences() {
        int[] columnOrder = new int[this.columnModel.getColumnCount()];
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            columnOrder[i] = this.columnModel.getColumn(i).getModelIndex();
        }
        PrefsObject.putObject((Preferences)this.uiPrefs, (String)"ColumnOrder", (Object)columnOrder);
    }
}

