/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.eventviewer.FilteringRulesTable;
import org.yamcs.utils.TimeEncoding;

class EventTableModel
extends AbstractTableModel
implements Observer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EventTableModel.class);
    private static List<String> columnNames = new ArrayList<String>();
    private List<GeneratedMessage.GeneratedExtension<Yamcs.Event, Descriptors.FieldDescriptor.Type>> extensions = new ArrayList<GeneratedMessage.GeneratedExtension<Yamcs.Event, Descriptors.FieldDescriptor.Type>>();
    private ExtensionRegistry registry;
    public static final int SOURCE_COL = 0;
    public static final int GENERATION_TIME_COL = 1;
    public static final int RECEPTION_TIME_COL = 2;
    public static final int EVENT_TYPE_COL = 3;
    public static final int EVENT_TEXT_COL = 4;
    public static final int FIRST_EXTENSION_COL = 5;
    private Vector<Yamcs.Event> allEvents = null;
    private Vector<Yamcs.Event> visibleEvents = null;
    FilteringRulesTable filteringTable = null;

    public EventTableModel(FilteringRulesTable table, List<Map<String, String>> extraColumns) {
        columnNames.add("Source");
        columnNames.add("Generation Time");
        columnNames.add("Reception Time");
        columnNames.add("Type");
        columnNames.add("Description");
        this.allEvents = new Vector();
        this.visibleEvents = new Vector();
        this.filteringTable = table;
        this.filteringTable.registerObserver(this);
        if (extraColumns != null) {
            for (Map<String, String> col : extraColumns) {
                if (this.registry == null) {
                    this.registry = ExtensionRegistry.newInstance();
                }
                try {
                    Class<?> extensionClazz = Class.forName(col.get("class"));
                    Field field = extensionClazz.getField(col.get("extension"));
                    GeneratedMessage.GeneratedExtension extension = (GeneratedMessage.GeneratedExtension)field.get(null);
                    this.extensions.add((GeneratedMessage.GeneratedExtension<Yamcs.Event, Descriptors.FieldDescriptor.Type>)extension);
                    this.registry.add(extension);
                    log.info("Installing extension " + extension.getDescriptor().getFullName());
                }
                catch (IllegalAccessException e) {
                    log.error("Could not load extension class", (Throwable)e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not load extension class", (Throwable)e);
                    continue;
                }
                catch (SecurityException e) {
                    log.error("Could not load extension class", (Throwable)e);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    log.error("Could not load extension class", (Throwable)e);
                    continue;
                }
                columnNames.add(col.get("label"));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.visibleEvents.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        Yamcs.Event event = this.visibleEvents.elementAt(rowIndex);
        if (columnIndex == 0) {
            value = event.getSource();
        } else if (columnIndex == 4) {
            value = event;
        } else if (columnIndex == 3) {
            value = event.getType();
        } else if (columnIndex == 1) {
            value = TimeEncoding.toString((long)event.getGenerationTime());
        } else if (columnIndex == 2) {
            value = TimeEncoding.toString((long)event.getReceptionTime());
        } else if (columnIndex >= 5) {
            int extensionIndex = columnIndex - 5;
            if (columnIndex - 5 < this.extensions.size()) {
                value = event.getExtension(this.extensions.get(extensionIndex));
            }
        }
        return value;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames.get(col);
    }

    public void addEvents(List<Yamcs.Event> eventList) {
        List<Yamcs.Event> newEvents = eventList;
        if (!this.extensions.isEmpty()) {
            try {
                newEvents = new ArrayList<Yamcs.Event>(eventList.size());
                for (Yamcs.Event evt : eventList) {
                    newEvents.add(Yamcs.Event.parseFrom((byte[])evt.toByteArray(), (ExtensionRegistryLite)this.registry));
                }
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
        this.allEvents.addAll(newEvents);
        int firstr = this.visibleEvents.size();
        for (Yamcs.Event event : newEvents) {
            if (!this.filteringTable.isEventVisible(event)) continue;
            this.visibleEvents.add(event);
        }
        int lastr = this.visibleEvents.size() - 1;
        if (firstr <= lastr) {
            this.fireTableRowsInserted(firstr, lastr);
        }
    }

    public void addEvent(Yamcs.Event event) {
        Yamcs.Event newEvent = event;
        if (!this.extensions.isEmpty()) {
            try {
                newEvent = Yamcs.Event.parseFrom((byte[])event.toByteArray(), (ExtensionRegistryLite)this.registry);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
        this.allEvents.add(newEvent);
        if (this.filteringTable.isEventVisible(newEvent)) {
            this.visibleEvents.add(newEvent);
            int addedRow = this.visibleEvents.size() - 1;
            this.fireTableRowsInserted(addedRow, addedRow);
        }
    }

    public Yamcs.Event getEvent(int row) {
        return this.visibleEvents.elementAt(row);
    }

    public void clear() {
        this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        this.allEvents.clear();
        this.visibleEvents.clear();
        this.fireTableDataChanged();
    }

    public void applyNewFilteringRules() {
        this.visibleEvents.clear();
        for (Yamcs.Event event : this.allEvents) {
            if (!this.filteringTable.isEventVisible(event)) continue;
            this.visibleEvents.add(event);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.applyNewFilteringRules();
    }
}

