/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.UiColors;

class EventTableRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint() {
    }

    public void firePropertyChange() {
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public int updateCalculatedHeight(JTable table, Object value, int row) {
        Yamcs.Event event = (Yamcs.Event)value;
        String[] lines = event.getMessage().split("\n");
        if (lines.length > 5) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                buf.append(lines[i]).append("\n");
            }
            buf.append("[truncated]");
            this.setText(buf.toString());
        } else {
            this.setText(event.getMessage());
        }
        int wantedHeight = (int)this.getPreferredSize().getHeight() + table.getIntercellSpacing().height;
        if (wantedHeight != table.getRowHeight(row)) {
            table.setRowHeight(row, wantedHeight);
        }
        return wantedHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.updateCalculatedHeight(table, value, row);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            Yamcs.Event event = (Yamcs.Event)value;
            switch (event.getSeverity()) {
                case ERROR: {
                    this.setForeground(UiColors.ERROR_FAINT_FG);
                    this.setBackground(UiColors.ERROR_FAINT_BG);
                    break;
                }
                case WATCH: {
                    this.setForeground(UiColors.WATCH_FAINT_FG);
                    this.setBackground(UiColors.WATCH_FAINT_BG);
                    break;
                }
                case WARNING: {
                    this.setForeground(UiColors.WARNING_FAINT_FG);
                    this.setBackground(UiColors.WARNING_FAINT_BG);
                    break;
                }
                case DISTRESS: {
                    this.setForeground(UiColors.DISTRESS_FAINT_FG);
                    this.setBackground(UiColors.DISTRESS_FAINT_BG);
                    break;
                }
                case CRITICAL: {
                    this.setForeground(UiColors.CRITICAL_FAINT_FG);
                    this.setBackground(UiColors.CRITICAL_FAINT_BG);
                    break;
                }
                case SEVERE: {
                    this.setForeground(UiColors.SEVERE_FAINT_FG);
                    this.setBackground(UiColors.SEVERE_FAINT_BG);
                    break;
                }
                default: {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
        }
        return this;
    }
}

