/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import com.csvreader.CsvWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.ConfigurationException;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsException;
import org.yamcs.api.YamcsConnectDialog;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.eventviewer.AlertType;
import org.yamcs.ui.eventviewer.EventDialog;
import org.yamcs.ui.eventviewer.EventReceiver;
import org.yamcs.ui.eventviewer.EventTable;
import org.yamcs.ui.eventviewer.EventTableModel;
import org.yamcs.ui.eventviewer.EventTableRenderer;
import org.yamcs.ui.eventviewer.FilteringRule;
import org.yamcs.ui.eventviewer.FilteringRulesTable;
import org.yamcs.ui.eventviewer.PreferencesDialog;
import org.yamcs.ui.eventviewer.YamcsEventReceiver;
import org.yamcs.utils.TimeEncoding;

public class EventViewer
extends JFrame
implements ActionListener,
ItemListener,
MenuListener,
ConnectionListener {
    static Logger log = LoggerFactory.getLogger(EventViewer.class);
    final Color iconColorGreen = new Color(8828810);
    final Color iconColorRed = new Color(12093063);
    Color iconColorGrey;
    EventTableModel tableModel;
    TableRowSorter<EventTableModel> tableSorter;
    public JTextArea logTextArea;
    JMenuItem miAutoScroll;
    JMenuItem miShowErrors;
    JMenuItem miRetrievePast;
    EventTable eventTable;
    JScrollPane eventPane;
    Map<String, JLabel> linkLabel;
    Map<String, Icon> linkOKIcon;
    Map<String, Icon> linkNOKIcon;
    List<JCheckBox> columnCheckbox;
    JFileChooser filechooser;
    PreferencesDialog preferencesDialog;
    EventReceiver eventReceiver;
    YamcsConnector yconnector;
    String currentUrl;
    String currentChannel;
    boolean connected = false;
    Thread connectingThread;
    private String soundFile;
    List<Map<String, String>> extraColumns;
    List<Map<String, String>> linkStatus;
    private Clip alertClip;
    private JPopupMenu popupMenu;
    private FilteringRulesTable rules;
    private JMenu viewMenu = null;
    private HashMap<JCheckBoxMenuItem, Integer> viewMenuFilterChkBoxes;
    boolean authenticationEnabled = false;

    private void readConfiguration() throws ConfigurationException {
        YConfiguration cfg = null;
        cfg = YConfiguration.getConfiguration((String)"event-viewer");
        if (cfg.containsKey("soundfile")) {
            this.soundFile = cfg.getString("soundfile");
        }
        if (cfg.containsKey("extraColumns")) {
            this.extraColumns = cfg.getList("extraColumns");
        }
        this.linkStatus = cfg.containsKey("linkstatus") ? cfg.getList("linkstatus") : new ArrayList<Map<String, String>>();
    }

    public FilteringRulesTable getFilteringRulesTable() {
        if (this.rules == null) {
            this.rules = new FilteringRulesTable();
        }
        return this.rules;
    }

    public EventTableModel getEventTable() {
        return this.tableModel;
    }

    public EventViewer(YamcsConnector yc, EventReceiver eventReceiver) throws ConfigurationException {
        YConfiguration config = YConfiguration.getConfiguration((String)"yamcs-ui");
        if (config.containsKey("authenticationEnabled")) {
            this.authenticationEnabled = config.getBoolean("authenticationEnabled");
        }
        this.yconnector = yc;
        this.eventReceiver = eventReceiver;
        this.readConfiguration();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                EventViewer.this.eventTable.storePreferences();
                EventViewer.this.dispose();
            }
        });
        this.setIconImage(this.getIcon("yamcs-event-32.png").getImage());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("shutting down");
                EventViewer.this.yconnector.disconnect();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        int menuKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem menuItem = new JMenuItem("Connect to Yamcs...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, menuKey));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("connect");
        menu.add(menuItem);
        menu.addSeparator();
        this.miRetrievePast = new JMenuItem("Retrieve Past Events...");
        this.miRetrievePast.addActionListener(this);
        this.miRetrievePast.setActionCommand("retrieve_past");
        menu.add(this.miRetrievePast);
        this.miRetrievePast.setEnabled(false);
        menu.addSeparator();
        menuItem = new JMenuItem("Save As...", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, menuKey));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("save");
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Quit", 81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, menuKey));
        menuItem.getAccessibleContext().setAccessibleDescription("Quit the event viewer");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("exit");
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuItem = new JMenuItem("Preferences", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, menuKey));
        menuItem.getAccessibleContext().setAccessibleDescription("Edit preferences");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("preferences");
        menu.add(menuItem);
        menuBar.add(menu);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(86);
        this.viewMenu.addMenuListener(this);
        this.miAutoScroll = new JCheckBoxMenuItem("Auto-Scroll");
        this.miAutoScroll.setSelected(true);
        this.viewMenu.add(this.miAutoScroll);
        this.viewMenu.addSeparator();
        menuItem = new JMenuItem("Clear", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, menuKey));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("clear");
        this.viewMenu.add(menuItem);
        menuBar.add(this.viewMenu);
        this.populateViewMenu();
        this.viewMenu.addSeparator();
        Box panel = Box.createHorizontalBox();
        this.getContentPane().add((Component)panel, "South");
        panel.add(Box.createHorizontalStrut(20));
        panel.add(Box.createHorizontalGlue());
        this.linkOKIcon = new HashMap<String, Icon>();
        this.linkNOKIcon = new HashMap<String, Icon>();
        this.linkLabel = new HashMap<String, JLabel>();
        for (Map<String, String> link : this.linkStatus) {
            this.linkOKIcon.put(link.get("name"), this.getIcon(link.get("okicon")));
            this.linkNOKIcon.put(link.get("name"), this.getIcon(link.get("nokicon")));
            JLabel label = new JLabel(this.linkNOKIcon.get(link.get("name")));
            label.setOpaque(true);
            label.setBorder(BorderFactory.createEtchedBorder(1));
            this.linkLabel.put(link.get("name"), label);
            panel.add(label);
        }
        this.tableModel = new EventTableModel(this.getFilteringRulesTable(), this.extraColumns);
        this.eventTable = new EventTable(this.tableModel);
        this.eventTable.setAutoResizeMode(3);
        this.eventTable.setPreferredScrollableViewportSize(new Dimension(920, 400));
        this.tableSorter = new TableRowSorter<EventTableModel>(this.tableModel);
        this.eventTable.setRowSorter(this.tableSorter);
        TableColumnModel tcm = this.eventTable.getColumnModel();
        tcm.getColumn(this.eventTable.convertColumnIndexToView(0)).setMaxWidth(200);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(1)).setMaxWidth(200);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(2)).setMaxWidth(200);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(3)).setMaxWidth(150);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(0)).setPreferredWidth(100);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(1)).setPreferredWidth(200);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(2)).setPreferredWidth(100);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(3)).setPreferredWidth(100);
        tcm.getColumn(this.eventTable.convertColumnIndexToView(4)).setPreferredWidth(400);
        this.eventPane = new JScrollPane(this.eventTable, 22, 30);
        JPanel filterablePane = new JPanel(new BorderLayout());
        filterablePane.add((Component)this.eventPane, "Center");
        JPanel filterPane = new JPanel(new BorderLayout());
        final JTextField filterField = new JTextField();
        filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EventViewer.this.updateRowFilter(filterField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EventViewer.this.updateRowFilter(filterField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EventViewer.this.updateRowFilter(filterField.getText());
            }
        });
        filterPane.add((Component)filterField, "Center");
        filterPane.add((Component)new JLabel("Filter:"), "West");
        filterablePane.add((Component)filterPane, "North");
        this.logTextArea = new JTextArea(5, 20);
        this.logTextArea.setEditable(false);
        JScrollPane logPane = new JScrollPane(this.logTextArea, 22, 30);
        JSplitPane split = new JSplitPane(0, filterablePane, logPane);
        split.setResizeWeight(1.0);
        split.setContinuousLayout(true);
        this.getContentPane().add((Component)split, "Center");
        this.popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("New filtering rule");
        item.setActionCommand("new_rule_popup");
        item.addActionListener(this);
        this.popupMenu.add(item);
        item = new JMenuItem("Details...");
        item.setActionCommand("show_event_details");
        item.addActionListener(this);
        this.popupMenu.add(item);
        this.popupMenu.setBorder(new BevelBorder(0));
        this.eventTable.addMouseListener(new MousePopupListener());
        this.pack();
        this.setLocation(30, 30);
        this.setVisible(true);
        eventReceiver.setEventViewer(this);
        this.yconnector.addConnectionListener((ConnectionListener)this);
    }

    private void updateRowFilter(String filterText) {
        final String lcFilterText = filterText.toLowerCase();
        this.tableSorter.setRowFilter(new RowFilter<EventTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends EventTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(lcFilterText)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public void populateViewMenu() {
        if (this.viewMenuFilterChkBoxes == null) {
            this.viewMenuFilterChkBoxes = new HashMap(25);
        }
        for (JCheckBoxMenuItem item : this.viewMenuFilterChkBoxes.keySet()) {
            this.viewMenu.remove(item);
        }
        this.viewMenuFilterChkBoxes.clear();
        JCheckBoxMenuItem item = null;
        Vector<FilteringRule> rules = this.getFilteringRulesTable().getRules();
        String label = "";
        for (int i = 0; i < rules.size(); ++i) {
            FilteringRule rule = rules.elementAt(i);
            label = rule.isShowOn() ? "Show - " : "Hide - ";
            label = label + rule.getName();
            item = new JCheckBoxMenuItem(label);
            item.setSelected(rule.isActive());
            this.getFilteringRulesTable().writeFilteringRules();
            item.addActionListener(this);
            item.setActionCommand("switch_rule_status");
            this.viewMenu.add(item);
            this.viewMenuFilterChkBoxes.put(item, i);
        }
    }

    private void showEventInDetailDialog(Yamcs.Event event) {
        EventDialog detailDialog = new EventDialog(this);
        detailDialog.setEvent(event);
        detailDialog.setVisible(true);
    }

    public ImageIcon getIcon(String imagename) {
        return new ImageIcon(this.getClass().getResource("/org/yamcs/images/" + imagename));
    }

    public void updateStatus(String name, String status) {
        SwingUtilities.invokeLater(() -> {
            StringBuffer title = new StringBuffer("Event Viewer");
            JLabel label = this.linkLabel.get(name);
            if (this.yconnector.isConnected()) {
                if (this.miRetrievePast != null) {
                    this.miRetrievePast.setEnabled(true);
                }
                title.append(" (connected)");
                if (status.equals("OK")) {
                    label.setBackground(this.iconColorGreen);
                    label.setIcon(this.linkOKIcon.get(name));
                } else if (status.equals("DISABLED")) {
                    label.setBackground(this.iconColorRed);
                    label.setIcon(this.linkNOKIcon.get(name));
                } else {
                    title.append(" (not connected)");
                    label.setBackground(this.iconColorGrey);
                    label.setIcon(this.linkOKIcon.get(name));
                }
            } else if (this.yconnector.isConnecting()) {
                if (this.miRetrievePast != null) {
                    this.miRetrievePast.setEnabled(false);
                }
                title.append(" (connecting)");
                label.setBackground(this.iconColorGrey);
            } else {
                if (this.miRetrievePast != null) {
                    this.miRetrievePast.setEnabled(false);
                }
                title.append(" (not connected)");
                label.setBackground(this.iconColorGrey);
            }
            this.setTitle(title.toString());
        });
    }

    public void connected(String url) {
        this.log("Connected to " + url);
    }

    public void connecting(String url) {
        this.log("Connecting to " + url);
    }

    public void disconnected() {
        this.log("Disconnected");
    }

    public void connectionFailed(String url, YamcsException exception) {
        this.log("Connection to " + url + " failed: " + exception);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("connect")) {
            YamcsConnectDialog.YamcsConnectDialogResult r = YamcsConnectDialog.showDialog((JFrame)this, (boolean)true, (boolean)this.authenticationEnabled);
            if (r.isOk()) {
                this.yconnector.connect(r.getConnectionProperties());
            }
        } else if (cmd.equals("retrieve_past")) {
            this.eventReceiver.retrievePastEvents();
        } else if (cmd.equals("switch_rule_status")) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            int index = this.viewMenuFilterChkBoxes.get(item);
            this.getFilteringRulesTable().switchRuleActivation(index, item.isSelected());
        } else if (cmd.equals("clear")) {
            this.clearTable();
        } else if (cmd.equals("save")) {
            if (this.getColumnsCheckBox() == 0) {
                this.saveTableAs();
            }
        } else if (cmd.equals("exit")) {
            this.processWindowEvent(new WindowEvent(this, 201));
        } else if (cmd.equals("preferences")) {
            this.getPreferencesDialog().setVisible(true);
        } else if (cmd.equals("new_rule_popup")) {
            int[] rows;
            for (int row : rows = this.eventTable.getSelectedRows()) {
                FilteringRule rule = new FilteringRule();
                Yamcs.Event event = ((EventTableModel)this.eventTable.getModel()).getEvent(row);
                rule.setSource(event.getSource());
                rule.setEventType(event.getType());
                rule.setEventText(event.getMessage());
                rule.setSeverity(event.getSeverity());
                this.getPreferencesDialog().addNewRule(rule);
            }
            this.getPreferencesDialog().setVisible(true);
        } else if (cmd.equals("show_event_details")) {
            this.showEventInDetailDialog(((EventTableModel)this.eventTable.getModel()).getEvent(this.tableSorter.convertRowIndexToModel(this.eventTable.getSelectedRow())));
        }
    }

    private void showAlertPopupDialog(Yamcs.Event event) {
        int messageType = 1;
        switch (event.getSeverity()) {
            case INFO: {
                messageType = 1;
                break;
            }
            case WARNING: {
                messageType = 2;
                break;
            }
            case ERROR: {
                messageType = 0;
                break;
            }
            default: {
                messageType = 1;
            }
        }
        JOptionPane.showMessageDialog(this, event.toString(), "Alert message", messageType);
    }

    private PreferencesDialog getPreferencesDialog() {
        if (this.preferencesDialog == null) {
            this.preferencesDialog = new PreferencesDialog((Window)this, Dialog.ModalityType.APPLICATION_MODAL);
        }
        return this.preferencesDialog;
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    public void log(String s) {
        SwingUtilities.invokeLater(() -> this.logTextArea.append(TimeEncoding.toCombinedFormat((long)TimeEncoding.currentInstant()) + " " + s + "\n"));
    }

    void clearTable() {
        this.tableModel.clear();
        this.eventTable.repaint();
    }

    void showMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Event Viewer", 0);
    }

    private int getColumnsCheckBox() {
        String[] colNames = new String[this.eventTable.getColumnCount()];
        int i = 0;
        for (int col = 0; col < this.eventTable.getColumnCount(); ++col) {
            colNames[i] = this.getColumnName(col);
            ++i;
        }
        Object[] obj = new Object[this.eventTable.getColumnCount() + 1];
        obj[0] = "Select columns to be saved:";
        this.columnCheckbox = new ArrayList<JCheckBox>();
        i = 1;
        for (String mc : colNames) {
            JCheckBox box = new JCheckBox(mc);
            box.setSelected(true);
            this.columnCheckbox.add(box);
            obj[i] = box;
            ++i;
        }
        return JOptionPane.showConfirmDialog(this, obj, "Save", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTableAs() {
        int ret;
        if (this.filechooser == null) {
            this.filechooser = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public File getSelectedFile() {
                    File file = super.getSelectedFile();
                    if (this.getFileFilter() instanceof ExtendedFileFilter) {
                        file = ((ExtendedFileFilter)this.getFileFilter()).appendExtensionIfNeeded(file);
                    }
                    return file;
                }

                @Override
                public void approveSelection() {
                    int response;
                    File file = this.getSelectedFile();
                    if (file.exists() && (response = JOptionPane.showConfirmDialog(EventViewer.this.filechooser, "The file " + file + " already exists. Do you want to replace the existing file?", "Overwrite file", 0)) != 0) {
                        return;
                    }
                    super.approveSelection();
                }
            };
            this.filechooser.setMultiSelectionEnabled(false);
            ExtendedFileFilter csvFilter = new ExtendedFileFilter("csv", "CSV File");
            this.filechooser.addChoosableFileFilter(csvFilter);
            ExtendedFileFilter txtFilter = new ExtendedFileFilter("txt", "Text File");
            this.filechooser.addChoosableFileFilter(txtFilter);
            this.filechooser.setFileFilter(csvFilter);
        }
        if ((ret = this.filechooser.showSaveDialog(this)) == 0) {
            File file = this.filechooser.getSelectedFile();
            try (CsvWriter writer = null;){
                writer = new CsvWriter((OutputStream)new FileOutputStream(file), '\t', Charset.forName("UTF-8"));
                ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
                for (int i = 0; i < this.columnCheckbox.size(); ++i) {
                    if (!this.columnCheckbox.get(i).isSelected()) continue;
                    selectedColumns.add(i);
                }
                String[] colNames = new String[selectedColumns.size()];
                int i = 0;
                Iterator iterator = selectedColumns.iterator();
                while (iterator.hasNext()) {
                    int col = (Integer)iterator.next();
                    colNames[i] = this.getColumnName(col);
                    ++i;
                }
                writer.writeRecord(colNames);
                writer.setForceQualifier(true);
                for (int row = 0; row < this.eventTable.getRowCount(); ++row) {
                    String[] rec = new String[selectedColumns.size()];
                    i = 0;
                    Iterator iterator2 = selectedColumns.iterator();
                    while (iterator2.hasNext()) {
                        int col = (Integer)iterator2.next();
                        rec[i] = this.getColumnValue(col, row);
                        ++i;
                    }
                    writer.writeRecord(rec);
                }
            }
            this.log("Saved table to " + file.getAbsolutePath());
        }
    }

    private String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Source";
            }
            case 1: {
                return "Generation Time";
            }
            case 2: {
                return "Reception Time";
            }
            case 3: {
                return "Event Type";
            }
            case 4: {
                return "Event Text";
            }
        }
        return this.tableModel.getColumnName(col);
    }

    private String getColumnValue(int col, int row) {
        row = this.tableSorter.convertRowIndexToModel(row);
        switch (col) {
            case 4: {
                return ((Yamcs.Event)this.tableModel.getValueAt(row, col)).getMessage();
            }
        }
        return (String)this.tableModel.getValueAt(row, col);
    }

    public void addEvents(List<Yamcs.Event> events) {
        SwingUtilities.invokeLater(() -> {
            this.tableModel.addEvents(events);
            this.eventTable.revalidate();
            this.eventPane.validate();
            if (this.miAutoScroll.isSelected()) {
                this.updateVerticalScrollPosition();
            }
        });
    }

    public void addEvent(Yamcs.Event event) {
        SwingUtilities.invokeLater(() -> {
            this.tableModel.addEvent(event);
            this.eventTable.revalidate();
            this.eventPane.validate();
            if (this.miAutoScroll.isSelected()) {
                this.updateVerticalScrollPosition();
            }
            AlertType alert = this.getFilteringRulesTable().getAlertType(event);
            if (alert.alertSound) {
                this.playAlertSound();
            }
            if (alert.alertPopup) {
                this.showAlertPopupDialog(event);
            }
        });
    }

    private void updateVerticalScrollPosition() {
        if (this.eventTable.getRowCount() <= 0) {
            return;
        }
        int row = this.eventTable.convertRowIndexToView(this.eventTable.getRowCount() - 1);
        int col = this.eventTable.convertColumnIndexToView(0);
        Rectangle rect = this.eventTable.getCellRect(row, col, true);
        int x = this.eventTable.getVisibleRect().x;
        int y = rect.y;
        int textViewColumn = this.eventTable.convertColumnIndexToView(4);
        TableCellRenderer renderer = this.eventTable.getCellRenderer(row, textViewColumn);
        if (renderer instanceof EventTableRenderer) {
            Object value = this.eventTable.getValueAt(row, textViewColumn);
            int actualHeight = ((EventTableRenderer)renderer).updateCalculatedHeight(this.eventTable, value, row);
            y += actualHeight - rect.height;
        }
        rect.setLocation(new Point(x, y));
        this.eventTable.scrollRectToVisible(rect);
    }

    private void playAlertSound() {
        new Thread(() -> this.playSoundFile()).start();
    }

    private Clip getAlertClip() {
        if (this.alertClip == null) {
            String defFileName = "/org/yamcs/sounds/alert.wav";
            try {
                AudioInputStream inputStream = null;
                inputStream = this.soundFile == null ? AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(defFileName))) : AudioSystem.getAudioInputStream(new File(this.soundFile));
                AudioFormat format = inputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.alertClip = (Clip)AudioSystem.getLine(info);
                this.alertClip.open(inputStream);
            }
            catch (Exception e) {
                log.warn("Error occured while playing sound clip ", (Throwable)e);
                this.alertClip = null;
            }
        }
        return this.alertClip;
    }

    private void playSoundFile() {
        Clip clip = null;
        try {
            clip = this.getAlertClip();
            if (clip == null) {
                return;
            }
            clip.stop();
            clip.setFramePosition(0);
            clip.start();
            Thread.sleep(clip.getMicrosecondLength());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            System.err.println("Error occured while playing the clip: " + e.getMessage());
        }
        finally {
            if (clip != null) {
                clip.stop();
                clip.setFramePosition(0);
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Usage event-viewer.sh yamcsurl");
        System.err.println("Example:\n\tevent-viewer.sh http://localhost:8090/yops");
        System.exit(-1);
    }

    void test(EventViewer ev) {
        Yamcs.Event event;
        Yamcs.Event.Builder builder;
        int evId;
        for (evId = 0; evId < 12; ++evId) {
            builder = Yamcs.Event.newBuilder();
            builder.setGenerationTime(5000L);
            builder.setReceptionTime(56000L);
            builder.setMessage("This is eventX message");
            builder.setSource("ACES");
            builder.setType("ASW_CMD_ERR aaa");
            builder.setSeqNumber(evId);
            builder.setSeverity(Yamcs.Event.EventSeverity.ERROR);
            event = builder.build();
            ev.addEvent(event);
        }
        for (evId = 0; evId < 12; ++evId) {
            builder = Yamcs.Event.newBuilder();
            builder.setGenerationTime(5000L);
            builder.setReceptionTime(56000L);
            builder.setMessage("This is event message");
            builder.setSource("ACES_X");
            builder.setType("ASW_CMD_ERR");
            builder.setSeqNumber(evId);
            event = builder.build();
            ev.addEvent(event);
        }
    }

    public static void main(String[] args) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (args.length > 1) {
            EventViewer.printUsageAndExit();
        }
        YConfiguration.setup();
        YamcsConnectionProperties ycd = null;
        if (args.length == 1) {
            if (args[0].startsWith("http")) {
                ycd = YamcsConnectionProperties.parse((String)args[0]);
            } else {
                EventViewer.printUsageAndExit();
            }
        }
        YamcsConnector yconnector = new YamcsConnector("EventViewer");
        YamcsEventReceiver eventReceiver = new YamcsEventReceiver(yconnector);
        new EventViewer(yconnector, eventReceiver);
        if (ycd != null) {
            yconnector.connect(ycd);
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.populateViewMenu();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public List<String> getParameterLinkStatus() {
        ArrayList<String> parameterLinks = new ArrayList<String>();
        for (Map<String, String> link : this.linkStatus) {
            parameterLinks.add(link.get("name"));
        }
        return parameterLinks;
    }

    class ExtendedFileFilter
    extends FileFilter {
        public String ext;
        private String desc;

        public ExtendedFileFilter(String ext, String desc) {
            this.ext = ext;
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("." + this.ext);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public File appendExtensionIfNeeded(File f) {
            return this.accept(f) ? f : new File(f.getPath() + "." + this.ext);
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
            if (e.getClickCount() == 2) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                EventViewer.this.showEventInDetailDialog(((EventTableModel)target.getModel()).getEvent(EventViewer.this.tableSorter.convertRowIndexToModel(row)));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = EventViewer.this.eventTable.rowAtPoint(e.getPoint());
                if (!EventViewer.this.eventTable.getSelectionModel().isSelectedIndex(row)) {
                    EventViewer.this.eventTable.getSelectionModel().setSelectionInterval(row, row);
                } else {
                    EventViewer.this.popupMenu.show(EventViewer.this.eventTable, e.getX(), e.getY());
                }
            }
        }
    }
}

