/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.util.HashSet;
import java.util.Set;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.eventviewer.AlertSetting;

public class FilteringRule {
    private boolean removable = true;
    private String name = "";
    private boolean isActive = true;
    private String source = "*";
    private String eventType = "*";
    private String eventText = "*";
    private AlertSetting alertType = AlertSetting.AlertNone;
    private boolean isShowOn = true;
    Set<Yamcs.Event.EventSeverity> severities = new HashSet<Yamcs.Event.EventSeverity>();

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventText() {
        return this.eventText;
    }

    public void setEventText(String eventText) {
        this.eventText = eventText;
    }

    public AlertSetting getAlertType() {
        return this.alertType;
    }

    public void setAlertType(AlertSetting alertType) {
        this.alertType = alertType;
    }

    public boolean isShowOn() {
        return this.isShowOn;
    }

    public void setShowOn(boolean isShowOn) {
        this.isShowOn = isShowOn;
    }

    public boolean matchSeverity(Yamcs.Event.EventSeverity severity) {
        return this.severities.contains(severity);
    }

    public void copyFrom(FilteringRule other) {
        this.name = other.name;
        this.isActive = other.isActive;
        this.source = other.source;
        this.eventType = other.eventType;
        this.eventText = other.eventText;
        this.alertType = other.alertType;
        this.severities = new HashSet<Yamcs.Event.EventSeverity>(other.severities);
        this.isShowOn = other.isShowOn;
    }

    public String getSeverityAsText() {
        return this.severities.toString();
    }

    public void setSeverityFromText(String text) {
    }

    public void setSeverity(Yamcs.Event.EventSeverity eventSeverity) {
        this.severities.clear();
        this.severities.add(eventSeverity);
    }

    public String getAlertAsText() {
        String text = "None";
        switch (this.alertType) {
            case AlertNone: {
                text = "None";
                break;
            }
            case AlertPopUp: {
                text = "PopUp";
                break;
            }
            case AlertSound: {
                text = "Sound";
                break;
            }
            default: {
                text = "None";
            }
        }
        return text;
    }

    public void setAlertFromText(String text) {
        this.alertType = text.equals("None") ? AlertSetting.AlertNone : (text.equals("Sound") ? AlertSetting.AlertSound : AlertSetting.AlertPopUp);
    }

    public String getShowAsText() {
        return this.isShowOn ? "Yes" : "No";
    }

    public static class FilteringRuleFactory {
        private FilteringRuleFactory() {
        }

        public static FilteringRule createDefaultFilteringRule() {
            FilteringRule rule = new FilteringRule();
            rule.setName("Other");
            rule.setRemovable(false);
            return rule;
        }

        public static FilteringRule createWarningAndErrorsFilteringRule() {
            FilteringRule rule = new FilteringRule();
            rule.setName("Warnings & Errors");
            rule.setSource("*");
            rule.setEventType("*");
            rule.setEventText("*");
            rule.setAlertType(AlertSetting.AlertNone);
            rule.setShowOn(true);
            rule.setActive(true);
            rule.setSeverityFromText("Warning & Error");
            rule.setRemovable(false);
            return rule;
        }
    }
}

