/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.table.AbstractTableModel;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.eventviewer.AlertSetting;
import org.yamcs.ui.eventviewer.AlertType;
import org.yamcs.ui.eventviewer.FilteringRule;
import org.yamcs.ui.eventviewer.GlobUtils;

public class FilteringRulesTable
extends AbstractTableModel {
    private Vector<FilteringRule> rules = null;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private static final String FILTERING_RULES_NUM_KEY = "/Filtering/NoOfRules";
    static final String[] columnNames = new String[]{"Active", "Rule name", "Source", "Event Type", "Event Message", "Severity", "Alert", "Show"};
    private TheObservable theObservable = new TheObservable();
    public static final int ACTIVE_COL = 0;
    public static final int RULE_NAME_COL = 1;
    public static final int SOURCE_COL = 2;
    public static final int EVENT_TYPE_COL = 3;
    public static final int EVENT_MESSAGE_COL = 4;
    public static final int SEVERITY_COL = 5;
    public static final int ALERT_COL = 6;
    public static final int SHOW_COL = 7;

    public FilteringRulesTable() {
        this.readFilteringRules();
    }

    public void registerObserver(Observer observer) {
        this.theObservable.addObserver(observer);
    }

    public void doNotifyAllObservers() {
        this.theObservable.doNotifyAllObservers();
    }

    public void addRule(FilteringRule rule, int index) {
        this.rules.insertElementAt(rule, index);
        this.fireTableRowsInserted(index, index);
        this.theObservable.forceChanged();
        this.writeFilteringRules();
    }

    public FilteringRule getRule(int index) {
        return this.rules.elementAt(index);
    }

    public void switchRuleActivation(int index, boolean active) {
        this.getRule(index).setActive(active);
        this.theObservable.forceChanged();
        this.doNotifyAllObservers();
        this.writeFilteringRules();
    }

    public int getSize() {
        return this.rules.size();
    }

    public void removeRule(int index) {
        this.rules.remove(index);
        this.fireTableRowsDeleted(index, index);
        this.theObservable.forceChanged();
        this.writeFilteringRules();
    }

    public Vector<FilteringRule> getRules() {
        return this.rules;
    }

    public void switchRules(int xpos, int ypos) {
        FilteringRule tempRule = this.rules.set(xpos, this.rules.elementAt(ypos));
        this.rules.set(ypos, tempRule);
        if (xpos > ypos) {
            int temp = xpos;
            xpos = ypos;
            ypos = temp;
        }
        this.fireTableRowsUpdated(xpos, ypos);
        this.theObservable.forceChanged();
        this.writeFilteringRules();
    }

    public Vector<String> getNames() {
        Vector<String> names = new Vector<String>();
        for (FilteringRule rule : this.rules) {
            names.add(rule.getName());
        }
        return names;
    }

    private FilteringRule matchFilteringRule(Yamcs.Event event) {
        for (FilteringRule rule : this.rules) {
            if (!rule.isActive() || !GlobUtils.isMatchGlob(rule.getSource(), event.getSource()) || !GlobUtils.isMatchGlob(rule.getEventType(), event.getType()) || !GlobUtils.isMatchGlob(rule.getEventText(), event.getMessage()) || !rule.matchSeverity(event.getSeverity())) continue;
            return rule;
        }
        return FilteringRule.FilteringRuleFactory.createDefaultFilteringRule();
    }

    public FilteringRule getFilteringRule(int index) {
        return this.rules.elementAt(index);
    }

    public boolean isEventVisible(Yamcs.Event event) {
        FilteringRule rule = this.matchFilteringRule(event);
        return rule.isShowOn();
    }

    public void writeFilteringRules() {
        try {
            if (Preferences.userRoot().nodeExists("/Filtering")) {
                Preferences.userRoot().node("/Filtering").removeNode();
            }
            this.prefs.putInt(FILTERING_RULES_NUM_KEY, this.rules.size());
            for (int i = 0; i < this.rules.size(); ++i) {
                String ruleNoKey = "/Filtering/Rule" + i;
                this.prefs.put(ruleNoKey + "/Name", this.rules.elementAt(i).getName());
                this.prefs.put(ruleNoKey + "/Source", this.rules.elementAt(i).getSource());
                this.prefs.put(ruleNoKey + "/EventType", this.rules.elementAt(i).getEventType());
                this.prefs.put(ruleNoKey + "/EventText", this.rules.elementAt(i).getEventText());
                this.prefs.put(ruleNoKey + "/AlertType", this.rules.elementAt(i).getAlertType().toString());
                this.prefs.putBoolean(ruleNoKey + "/IsShowOn", this.rules.elementAt(i).isShowOn());
                this.prefs.putBoolean(ruleNoKey + "/IsActive", this.rules.elementAt(i).isActive());
                this.prefs.put(ruleNoKey + "/Severity", this.rules.elementAt(i).getSeverityAsText());
            }
        }
        catch (BackingStoreException e) {
            this.prefs.putInt(FILTERING_RULES_NUM_KEY, 0);
        }
    }

    private FilteringRule readFilteringRule(int ruleNo) {
        FilteringRule rule = new FilteringRule();
        String ruleNoKey = "/Filtering/Rule" + ruleNo;
        rule.setName(this.prefs.get(ruleNoKey + "/Name", ""));
        rule.setSource(this.prefs.get(ruleNoKey + "/Source", ""));
        rule.setEventType(this.prefs.get(ruleNoKey + "/EventType", ""));
        rule.setEventText(this.prefs.get(ruleNoKey + "/EventText", ""));
        rule.setAlertType(AlertSetting.valueOf(this.prefs.get(ruleNoKey + "/AlertType", "None")));
        rule.setShowOn(this.prefs.getBoolean(ruleNoKey + "/IsShowOn", false));
        rule.setActive(this.prefs.getBoolean(ruleNoKey + "/IsActive", false));
        rule.setSeverityFromText(this.prefs.get(ruleNoKey + "/Severity", "All"));
        return rule;
    }

    private void readFilteringRules() {
        this.rules = new Vector();
        int rulesNo = this.getNumOfFilteringRules();
        for (int i = 0; i < rulesNo; ++i) {
            this.rules.add(this.readFilteringRule(i));
        }
        if (this.rules.size() == 0) {
            this.rules.add(FilteringRule.FilteringRuleFactory.createWarningAndErrorsFilteringRule());
            this.rules.add(FilteringRule.FilteringRuleFactory.createDefaultFilteringRule());
        }
        this.theObservable.forceChanged();
    }

    private int getNumOfFilteringRules() {
        return this.prefs.getInt(FILTERING_RULES_NUM_KEY, 0);
    }

    public AlertType getAlertType(Yamcs.Event event) {
        AlertType alert = new AlertType();
        FilteringRule rule = this.matchFilteringRule(event);
        switch (rule.getAlertType()) {
            case AlertNone: {
                alert.alertPopup = false;
                alert.alertSound = false;
                break;
            }
            case AlertPopUp: {
                alert.alertPopup = true;
                alert.alertSound = false;
                break;
            }
            case AlertSound: {
                alert.alertPopup = false;
                alert.alertSound = true;
                break;
            }
            default: {
                alert.alertPopup = false;
                alert.alertSound = false;
            }
        }
        return alert;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Boolean.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FilteringRule rule = this.getFilteringRule(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = rule.isActive();
                break;
            }
            case 1: {
                value = rule.getName();
                break;
            }
            case 2: {
                value = rule.getSource();
                break;
            }
            case 3: {
                value = rule.getEventType();
                break;
            }
            case 4: {
                value = rule.getEventText();
                break;
            }
            case 5: {
                value = rule.getSeverityAsText();
                break;
            }
            case 6: {
                value = rule.getAlertAsText();
                break;
            }
            case 7: {
                value = rule.getShowAsText();
                break;
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FilteringRule rule = this.getFilteringRule(rowIndex);
        switch (columnIndex) {
            case 0: {
                rule.setActive((Boolean)aValue);
                break;
            }
            case 1: {
                rule.setName((String)aValue);
                break;
            }
            case 2: {
                rule.setSource((String)aValue);
                break;
            }
            case 3: {
                rule.setEventType((String)aValue);
                break;
            }
            case 4: {
                rule.setEventText((String)aValue);
                break;
            }
            case 5: {
                rule.setSeverityFromText((String)aValue);
                break;
            }
            case 6: {
                rule.setAlertFromText((String)aValue);
                break;
            }
            case 7: {
                rule.setShowOn(((String)aValue).equalsIgnoreCase("Yes"));
                break;
            }
        }
        this.writeFilteringRules();
        this.theObservable.forceChanged();
    }

    class TheObservable
    extends Observable {
        TheObservable() {
        }

        public void forceChanged() {
            this.setChanged();
        }

        public void doNotifyAllObservers() {
            this.notifyObservers();
        }
    }
}

