/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

final class GlobUtils {
    GlobUtils() {
    }

    public static String globToRegExp(String glob) {
        return glob.replace("[", "\\[").replace("]", "\\]").replace(".", "[.]").replace("*", ".*").replace("?", ".");
    }

    public static boolean isMatch(String regex, String matched) {
        Pattern patt = Pattern.compile(regex);
        return patt.matcher(matched).matches();
    }

    public static synchronized boolean isMatchGlob(String glob, String matched) {
        if (glob.equals("*")) {
            return true;
        }
        return GlobUtils.isMatch(GlobUtils.globToRegExp(glob), matched);
    }

    public static List<String> getAllMatched(String[] expressions, String glob) {
        ArrayList<String> matched = new ArrayList<String>();
        String regex = GlobUtils.globToRegExp(glob);
        for (String expression : expressions) {
            if (!GlobUtils.isMatch(regex, expression)) continue;
            matched.add(expression);
        }
        return matched;
    }
}

