/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.yamcs.ui.eventviewer.EventViewer;
import org.yamcs.ui.eventviewer.FilteringRule;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelRules = null;
    private JPanel jPanelAlerts = null;
    private JPanel jPanelLeft = null;
    private JPanel jPanelRight = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonClose = null;
    private JButton jButtonCancel = null;
    private JPanel jPanelWest = null;
    private JPanel jPanelSouth = null;
    private EventViewer eventViewer = null;
    private JTable filteredTable = null;
    private JButton jButtonAdd = null;
    private JButton jButtonRemove = null;
    private JButton jButtonMoveUp = null;
    private JButton jButtonMoveDown = null;

    public PreferencesDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    public PreferencesDialog(Frame owner, String title) {
        super(owner, title);
        this.initialize();
    }

    public PreferencesDialog(Window owner, Dialog.ModalityType modalityType) {
        super(owner, modalityType);
        this.initialize();
    }

    public PreferencesDialog(Window owner, String title, Dialog.ModalityType modalityType) {
        super(owner, title, modalityType);
        this.initialize();
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setPreferredSize(new Dimension(260, 270));
            this.jTabbedPane.setName("");
            this.jTabbedPane.addTab("Filtering table", null, this.getJPanelRules(), "Configuration of event filtering rules");
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelRules() {
        if (this.jPanelRules == null) {
            this.jPanelRules = new JPanel();
            this.jPanelRules.setLayout(new BorderLayout());
            this.jPanelRules.add((Component)this.getJPanelLeft(), "Center");
            this.jPanelRules.add((Component)this.getJPanelRight(), "East");
        }
        return this.jPanelRules;
    }

    private JPanel getJPanelAlerts() {
        if (this.jPanelAlerts == null) {
            this.jPanelAlerts = new JPanel();
            this.jPanelAlerts.setLayout(new BorderLayout());
        }
        return this.jPanelAlerts;
    }

    private JPanel getJPanelLeft() {
        if (this.jPanelLeft == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jPanelLeft = new JPanel();
            this.jPanelLeft.setLayout(new BoxLayout(this.jPanelLeft, 1));
            this.jPanelLeft.add(this.getJScrollPane());
        }
        return this.jPanelLeft;
    }

    private JPanel getJPanelRight() {
        if (this.jPanelRight == null) {
            this.jPanelRight = new JPanel();
            this.jPanelRight.setLayout(new BorderLayout());
            this.jPanelRight.add((Component)this.getJPanelWest(), "North");
            this.jPanelRight.add((Component)this.getJPanelSouth(), "South");
        }
        return this.jPanelRight;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJFilteredTable());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridLayout(2, 1, 5, 3));
            this.jPanelButtons.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.jPanelButtons.add(this.getJButtonClose());
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText(" Close ");
            this.jButtonClose.setActionCommand("close");
            this.jButtonClose.addActionListener(this);
        }
        return this.jButtonClose;
    }

    private JButton getJButtonMoveUp() {
        if (this.jButtonMoveUp == null) {
            this.jButtonMoveUp = new JButton();
            this.jButtonMoveUp.setText("Up");
            this.jButtonMoveUp.setActionCommand("move_up_rule");
            this.jButtonMoveUp.addActionListener(this);
        }
        return this.jButtonMoveUp;
    }

    private JButton getJButtonMoveDown() {
        if (this.jButtonMoveDown == null) {
            this.jButtonMoveDown = new JButton();
            this.jButtonMoveDown.setText("Down");
            this.jButtonMoveDown.setActionCommand("move_down_rule");
            this.jButtonMoveDown.addActionListener(this);
        }
        return this.jButtonMoveDown;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setActionCommand("cancel");
            this.jButtonCancel.addActionListener(this);
        }
        return this.jButtonCancel;
    }

    private JPanel getJPanelWest() {
        if (this.jPanelWest == null) {
            this.jPanelWest = new JPanel();
            this.jPanelWest.setLayout(new GridLayout(5, 1, 5, 3));
            this.jPanelWest.add(this.getJButtonAdd());
            this.jPanelWest.add(this.getJButtonRemove());
            this.jPanelWest.add(this.getJButtonMoveUp());
            this.jPanelWest.add(this.getJButtonMoveDown());
        }
        return this.jPanelWest;
    }

    private JButton getJButtonAdd() {
        if (this.jButtonAdd == null) {
            this.jButtonAdd = new JButton("Add");
            this.jButtonAdd.setActionCommand("add_rule");
            this.jButtonAdd.addActionListener(this);
        }
        return this.jButtonAdd;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton("Delete");
            this.jButtonRemove.setActionCommand("delete_rule");
            this.jButtonRemove.addActionListener(this);
        }
        return this.jButtonRemove;
    }

    private JPanel getJPanelSouth() {
        if (this.jPanelSouth == null) {
            this.jPanelSouth = new JPanel();
            this.jPanelSouth.setLayout(new BorderLayout());
            this.jPanelSouth.add((Component)this.getJPanelButtons(), "East");
        }
        return this.jPanelSouth;
    }

    public static void main(String[] args) {
        PreferencesDialog diag = new PreferencesDialog(null, Dialog.ModalityType.MODELESS);
        diag.setVisible(true);
    }

    private void initialize() {
        this.eventViewer = (EventViewer)this.getOwner();
        this.setLocationByPlatform(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width / 2, screenSize.height / 3);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Preferences");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PreferencesDialog.this.eventViewer.getFilteringRulesTable().doNotifyAllObservers();
            }
        });
    }

    public JTable getJFilteredTable() {
        if (this.filteredTable == null) {
            this.filteredTable = new JTable(this.eventViewer.getFilteringRulesTable()){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return true;
                }
            };
            this.filteredTable.getSelectionModel().setSelectionMode(0);
            TableColumnModel tcm = this.filteredTable.getColumnModel();
            tcm.getColumn(0).setMaxWidth(80);
            tcm.getColumn(5).setMaxWidth(140);
            tcm.getColumn(6).setMaxWidth(80);
            tcm.getColumn(7).setMaxWidth(80);
            tcm.getColumn(0).setPreferredWidth(80);
            tcm.getColumn(1).setPreferredWidth(200);
            tcm.getColumn(2).setPreferredWidth(300);
            tcm.getColumn(3).setPreferredWidth(300);
            tcm.getColumn(4).setPreferredWidth(300);
            tcm.getColumn(5).setPreferredWidth(120);
            tcm.getColumn(6).setPreferredWidth(120);
            tcm.getColumn(7).setPreferredWidth(120);
            JCheckBox checkBox = new JCheckBox();
            TableColumn activeColumn = tcm.getColumn(0);
            activeColumn.setCellEditor(new DefaultCellEditor(checkBox));
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("Info");
            comboBox.addItem("Warning");
            comboBox.addItem("Error");
            comboBox.addItem("Warning & Error");
            comboBox.addItem("All");
            TableColumn severityColumn = tcm.getColumn(5);
            severityColumn.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem("Sound");
            comboBox.addItem("PopUp");
            comboBox.addItem("None");
            TableColumn alertColumn = tcm.getColumn(6);
            alertColumn.setCellEditor(new DefaultCellEditor(comboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText("Click to edit");
            alertColumn.setCellRenderer(renderer);
            comboBox = new JComboBox();
            comboBox.addItem("Yes");
            comboBox.addItem("No");
            TableColumn showColumn = tcm.getColumn(7);
            showColumn.setCellEditor(new DefaultCellEditor(comboBox));
            renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText("Click to edit");
            showColumn.setCellRenderer(renderer);
        }
        return this.filteredTable;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setSize(new Dimension(479, 259));
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("close")) {
            this.setVisible(false);
            this.eventViewer.getFilteringRulesTable().doNotifyAllObservers();
        } else if (action.equals("add_rule")) {
            this.addNewRule();
        } else if (action.equals("delete_rule")) {
            this.deleteRule();
        } else if (action.equals("move_up_rule")) {
            this.moveUpRule();
        } else if (action.equals("move_down_rule")) {
            this.moveDownRule();
        } else assert (false);
    }

    private void moveUpRule() {
        this.moveRule(-1);
    }

    private void moveDownRule() {
        this.moveRule(1);
    }

    private void moveRule(int direction) {
        if (direction != -1 && direction != 1) {
            return;
        }
        int selected = this.filteredTable.getSelectedRow();
        if (selected == -1) {
            return;
        }
        int current = selected;
        int future = selected + direction;
        if (future < 0 || future >= this.filteredTable.getRowCount()) {
            return;
        }
        this.eventViewer.getFilteringRulesTable().switchRules(current, future);
        this.filteredTable.getSelectionModel().setSelectionInterval(future, future);
    }

    private void addNewRule() {
        int selected = this.filteredTable.getSelectedRow();
        if (selected == -1) {
            selected = 0;
        }
        FilteringRule rule = new FilteringRule();
        rule.setName("Filtering rule");
        this.eventViewer.getFilteringRulesTable().addRule(rule, selected);
        this.filteredTable.getSelectionModel().setSelectionInterval(selected, selected);
    }

    public void addNewRule(FilteringRule rule) {
        rule.setName(rule.getSource() + " - " + rule.getEventType());
        this.eventViewer.getFilteringRulesTable().addRule(rule, 0);
        this.filteredTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void deleteRule() {
        int selected = this.filteredTable.getSelectedRow();
        if (selected == -1) {
            return;
        }
        this.eventViewer.getFilteringRulesTable().removeRule(selected);
    }
}

