/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.eventviewer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.yamcs.YamcsException;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.rest.BulkRestDataReceiver;
import org.yamcs.api.rest.RestClient;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.api.ws.WebSocketClientCallback;
import org.yamcs.api.ws.WebSocketRequest;
import org.yamcs.api.ws.WebSocketResponseHandler;
import org.yamcs.protobuf.Pvalue;
import org.yamcs.protobuf.Web;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.eventviewer.EventReceiver;
import org.yamcs.ui.eventviewer.EventViewer;
import org.yamcs.utils.TimeEncoding;

public class YamcsEventReceiver
implements ConnectionListener,
EventReceiver,
WebSocketClientCallback,
WebSocketResponseHandler {
    EventViewer eventViewer;
    YamcsConnector yconnector;

    public YamcsEventReceiver(YamcsConnector yconnector) {
        this.yconnector = yconnector;
        yconnector.addConnectionListener((ConnectionListener)this);
    }

    @Override
    public void setEventViewer(EventViewer ev) {
        this.eventViewer = ev;
    }

    public void onMessage(Web.WebSocketServerMessage.WebSocketSubscriptionData data) {
        if (data.hasEvent()) {
            Yamcs.Event ev = data.getEvent();
            this.eventViewer.addEvent(ev);
        }
        if (data.hasParameterData()) {
            Pvalue.ParameterData par = data.getParameterData();
            this.eventViewer.updateStatus(par.getParameter(0).getId().getName(), par.getParameter(0).getEngValue().getStringValue());
        }
    }

    public void connected(String url) {
        WebSocketRequest wsr = new WebSocketRequest("events", "subscribe");
        this.yconnector.performSubscription(wsr, (WebSocketClientCallback)this, (WebSocketResponseHandler)this);
        for (String parameter : this.eventViewer.getParameterLinkStatus()) {
            Web.ParameterSubscriptionRequest.Builder b = Web.ParameterSubscriptionRequest.newBuilder();
            b.addId(Yamcs.NamedObjectId.newBuilder().setName(parameter).build());
            b.setAbortOnInvalid(false);
            WebSocketRequest wsrLink = new WebSocketRequest("parameter", "subscribe", (Message)b.build());
            this.yconnector.performSubscription(wsrLink, (WebSocketClientCallback)this, (WebSocketResponseHandler)this);
        }
    }

    @Override
    public void retrievePastEvents() {
        PastEventParams params = YarchPastEventsDialog.showDialog(this.eventViewer);
        if (!params.ok) {
            return;
        }
        RestClient restClient = this.yconnector.getRestClient();
        StringBuilder resource = new StringBuilder().append("/archive/" + this.yconnector.getConnectionParams().getInstance() + "/downloads/events?");
        resource.append("start=" + TimeEncoding.toString((long)params.start));
        resource.append("&stop=" + TimeEncoding.toString((long)params.stop));
        final int batchSize = 1000;
        final ArrayList evList = new ArrayList(batchSize);
        final AtomicInteger count = new AtomicInteger();
        CompletableFuture f = restClient.doBulkGetRequest(resource.toString(), new BulkRestDataReceiver(){

            public void receiveData(byte[] data) throws YamcsApiException {
                try {
                    evList.add(Yamcs.Event.parseFrom((byte[])data));
                    if (evList.size() == batchSize) {
                        count.addAndGet(batchSize);
                        YamcsEventReceiver.this.eventViewer.addEvents(new ArrayList<Yamcs.Event>(evList));
                        evList.clear();
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new YamcsApiException("Error parsing index result: " + e.getMessage());
                }
            }

            public void receiveException(Throwable t) {
                t.printStackTrace();
                YamcsEventReceiver.this.eventViewer.log("Received error when downloading events: " + t.getMessage());
            }
        });
        f.whenComplete((result, exception) -> {
            if (exception == null) {
                count.addAndGet(evList.size());
                this.eventViewer.addEvents(evList);
                this.eventViewer.log("Past Event retrieval finished; retrieved " + count.get() + " events");
            } else {
                exception.printStackTrace();
                count.addAndGet(evList.size());
                this.eventViewer.addEvents(evList);
                this.eventViewer.log("Past Event retrieval finished with error; retrieved " + count.get() + " events");
            }
        });
    }

    public void connecting(String url) {
    }

    public void connectionFailed(String url, YamcsException exception) {
        this.eventViewer.log("Connection to " + url + " failed: " + exception.getMessage());
    }

    public void disconnected() {
        this.eventViewer.log("Disconnected ");
    }

    public void log(String message) {
    }

    public void onException(Web.WebSocketServerMessage.WebSocketExceptionData e) {
        this.eventViewer.log("Received error on subscription: " + e.getMessage());
    }

    static class YarchPastEventsDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private PastEventParams params = new PastEventParams(TimeEncoding.getWallclockTime() - 2592000000L, TimeEncoding.getWallclockTime());
        JTextField startTextField;
        JTextField stopTextField;
        private JTextField instanceTextField;
        static YarchPastEventsDialog dialog;

        YarchPastEventsDialog(JFrame parent) {
            super(parent, "Retrieve past events", true);
            JPanel inputPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            inputPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
            this.getContentPane().add((Component)inputPanel, "Center");
            JLabel lab = new JLabel("Start: ");
            lab.setHorizontalAlignment(4);
            c.gridy = 1;
            c.gridx = 0;
            c.anchor = 13;
            inputPanel.add((Component)lab, c);
            this.startTextField = new JTextField(TimeEncoding.toString((long)this.params.start));
            c.gridy = 1;
            c.gridx = 1;
            c.anchor = 17;
            inputPanel.add((Component)this.startTextField, c);
            lab = new JLabel("Stop: ");
            lab.setHorizontalAlignment(4);
            c.gridy = 2;
            c.gridx = 0;
            c.anchor = 13;
            inputPanel.add((Component)lab, c);
            this.stopTextField = new JTextField(TimeEncoding.toString((long)this.params.stop));
            c.gridy = 2;
            c.gridx = 1;
            c.anchor = 17;
            inputPanel.add((Component)this.stopTextField, c);
            JPanel buttonPanel = new JPanel();
            this.getContentPane().add((Component)buttonPanel, "South");
            JButton button = new JButton("OK");
            button.setActionCommand("ok");
            button.addActionListener(this);
            this.getRootPane().setDefaultButton(button);
            buttonPanel.add(button);
            button = new JButton("Cancel");
            button.setActionCommand("cancel");
            button.addActionListener(this);
            buttonPanel.add(button);
            this.setMinimumSize(new Dimension(150, 100));
            this.setLocationRelativeTo(parent);
            this.setDefaultCloseOperation(2);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ok")) {
                try {
                    this.params.start = TimeEncoding.parse((String)this.startTextField.getText());
                    this.params.stop = TimeEncoding.parse((String)this.stopTextField.getText());
                    this.params.ok = true;
                    this.setVisible(false);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (e.getActionCommand().equals("cancel")) {
                this.params.ok = false;
                this.setVisible(false);
            }
        }

        public static final PastEventParams showDialog(JFrame parent) {
            if (dialog == null) {
                dialog = new YarchPastEventsDialog(parent);
            }
            dialog.setVisible(true);
            return YarchPastEventsDialog.dialog.params;
        }
    }

    static class PastEventParams {
        boolean ok;
        long start;
        long stop;

        public PastEventParams(long start, long stop) {
            this.start = start;
            this.stop = stop;
        }
    }
}

