/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.yamcs.ConfigurationException;
import org.yamcs.api.ProcessorControlClient;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.ui.archivebrowser.ArchiveBrowser;
import org.yamcs.ui.archivebrowser.ArchiveIndexReceiver;
import org.yamcs.ui.archivebrowser.Selection;
import org.yamcs.ui.yamcsmonitor.ArchiveProcWidget;
import org.yamcs.ui.yamcsmonitor.ProcessorWidget;
import org.yamcs.ui.yamcsmonitor.YamcsMonitor;

public class ArchiveBrowserSelector
extends ArchiveBrowser
implements ActionListener {
    boolean isHrdpPlaying;
    JMenuItem showCindexMenuItem;

    public ArchiveBrowserSelector(Component parent, YamcsConnector yconnector, ArchiveIndexReceiver indexReceiver, ProcessorControlClient processorControl, boolean isAdmin) throws ConfigurationException, IOException {
        super(yconnector, indexReceiver, true);
        ArrayList<JMenu> customMenus = new ArrayList<JMenu>();
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu menu = this.menuBar.getMenu(i);
            if (!menu.getText().equals("Selection")) continue;
            customMenus.add(menu);
        }
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.menuBar.add(menu);
        JMenuItem closeMenuItem = new JMenuItem("Close", 87);
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeMenuItem.getAccessibleContext().setAccessibleDescription("Close the window");
        closeMenuItem.addActionListener(this);
        closeMenuItem.setActionCommand("close");
        menu.add(closeMenuItem);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        this.menuBar.add(viewMenu);
        JMenu toolsMenu = this.getToolsMenu();
        if (toolsMenu != null) {
            this.menuBar.add(toolsMenu);
        }
        for (JMenu customMenu : customMenus) {
            this.menuBar.add(customMenu);
        }
        viewMenu.addSeparator();
        if (isAdmin) {
            JMenuItem dassArcReplayMenuItem = new JMenuItem("Show DaSS Archive Replay Command for Current Selection", 68);
            dassArcReplayMenuItem.setEnabled(false);
            dassArcReplayMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            dassArcReplayMenuItem.getAccessibleContext().setAccessibleDescription("Show the HLCL command for a Col-CC DaSS archive replay to copy it to the clipboard.");
            dassArcReplayMenuItem.addActionListener(this);
            dassArcReplayMenuItem.setActionCommand("show-dass-arc");
            viewMenu.add(dassArcReplayMenuItem);
        }
        JMenuItem rawPacketDumpCmdMenuItem = new JMenuItem("Show Raw Packet Dump Command for Current Selection", 82);
        rawPacketDumpCmdMenuItem.setEnabled(false);
        rawPacketDumpCmdMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        rawPacketDumpCmdMenuItem.getAccessibleContext().setAccessibleDescription("Show the command line of a raw packet dump to copy it to the clipboard.");
        rawPacketDumpCmdMenuItem.addActionListener(this);
        rawPacketDumpCmdMenuItem.setActionCommand("show-raw-packet-dump");
        viewMenu.add(rawPacketDumpCmdMenuItem);
        this.archivePanel.openItem("Telemetry");
        this.setDefaultCloseOperation(1);
        this.archivePanel.replayPanel.applySelectionButton.addActionListener(this);
        this.archivePanel.replayPanel.setProcessorControlClient(processorControl);
        this.archivePanel.replayPanel.clearReplayPanel();
        yconnector.addConnectionListener((ConnectionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        String cmd = ae.getActionCommand();
        if (cmd.equals("apply")) {
            Selection sel = this.archivePanel.getSelection();
            if (sel == null) {
                this.showError("Select the range you want to apply. Then try again");
            } else {
                ArrayList<String> packets = new ArrayList<String>(this.archivePanel.getSelectedPackets("tm"));
                packets.addAll(this.archivePanel.getSelectedPackets("pp"));
                ProcessorWidget widget = YamcsMonitor.theApp.getActiveProcessorWidget();
                if (widget instanceof ArchiveProcWidget) {
                    ((ArchiveProcWidget)widget).apply(this.getInstance(), sel.getStartInstant(), sel.getStopInstant(), packets.toArray(new String[0]));
                    this.showInfo("A new selection was applied.\nLook at the \"New Processor\" section in the Yamcs Monitor window to check.");
                } else {
                    this.showError("Cannot apply selection for the currently selected processor type");
                }
            }
        } else if (cmd.equalsIgnoreCase("close")) {
            this.setVisible(false);
        } else if (cmd.toLowerCase().endsWith("selection_finished")) {
            this.archivePanel.replayPanel.applySelectionButton.setEnabled(true);
        } else if (cmd.equalsIgnoreCase("selection_reset")) {
            this.archivePanel.replayPanel.applySelectionButton.setEnabled(false);
        } else if (cmd.equals("histo_selection_finished")) {
            this.archivePanel.replayPanel.applySelectionButton.setEnabled(true);
        }
    }
}

