/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.yamcsmonitor.ProcessorWidget;
import org.yamcs.ui.yamcsmonitor.YamcsMonitor;
import org.yamcs.utils.TimeEncoding;

public class ArchiveProcWidget
extends ProcessorWidget {
    String archiveInstance;
    long start;
    long stop;
    JList<String> packetList;
    JLabel startLabel;
    JLabel stopLabel;
    JLabel instanceLabel;
    JCheckBox loopButton;
    JRadioButton speedRealtimeRadio;
    JRadioButton speedFixedRadio;

    public ArchiveProcWidget(String channelType) {
        super(channelType);
    }

    @Override
    public JComponent createConfigurationPanel() {
        JPanel configurationPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        configurationPanel.setLayout(gridbag);
        JButton button = new JButton("Select Range From Archive...");
        button.addActionListener(ae -> YamcsMonitor.theApp.showArchiveBrowserSelector());
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gridbag.setConstraints(button, gbc);
        configurationPanel.add(button);
        JLabel label = new JLabel("Start:", 4);
        label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gridbag.setConstraints(label, gbc);
        configurationPanel.add(label);
        this.startLabel = new JLabel();
        this.startLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.startLabel.getMaximumSize().height));
        this.startLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gridbag.setConstraints(this.startLabel, gbc);
        configurationPanel.add(this.startLabel);
        label = new JLabel("Stop:", 4);
        label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gridbag.setConstraints(label, gbc);
        configurationPanel.add(label);
        this.stopLabel = new JLabel();
        this.stopLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.stopLabel.getMaximumSize().height));
        this.stopLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gridbag.setConstraints(this.stopLabel, gbc);
        configurationPanel.add(this.stopLabel);
        label = new JLabel("Instance:", 4);
        label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gridbag.setConstraints(label, gbc);
        configurationPanel.add(label);
        this.instanceLabel = new JLabel();
        this.instanceLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gridbag.setConstraints(this.instanceLabel, gbc);
        configurationPanel.add(this.instanceLabel);
        this.packetList = new JList();
        this.packetList.setSelectionMode(2);
        this.packetList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.packetList.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Vector<String> vec = new Vector<String>();
                ListModel<String> lm = ArchiveProcWidget.this.packetList.getModel();
                for (int i = 0; i < lm.getSize(); ++i) {
                    if (ArchiveProcWidget.this.packetList.isSelectedIndex(i)) continue;
                    vec.add(lm.getElementAt(i));
                }
                ArchiveProcWidget.this.packetList.setListData(vec);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.packetList);
        scrollPane.setPreferredSize(new Dimension(150, 80));
        scrollPane.setBorder(BorderFactory.createBevelBorder(1));
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gridbag.setConstraints(scrollPane, gbc);
        configurationPanel.add(scrollPane);
        Box hbox = Box.createHorizontalBox();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gridbag.setConstraints(hbox, gbc);
        configurationPanel.add(hbox);
        label = new JLabel("Speed:");
        hbox.add(label);
        this.speedRealtimeRadio = new JRadioButton("Realtime");
        this.speedRealtimeRadio.setToolTipText("Play telemetry at a speed according to their CCSDS timestamps.");
        hbox.add(this.speedRealtimeRadio);
        this.speedFixedRadio = new JRadioButton("Fixed");
        this.speedFixedRadio.setToolTipText("Play telemetry at 1 packet per second, ignoring CCSDS timestamps.");
        this.speedFixedRadio.setSelected(true);
        hbox.add(this.speedFixedRadio);
        ButtonGroup group = new ButtonGroup();
        group.add(this.speedRealtimeRadio);
        group.add(this.speedFixedRadio);
        this.loopButton = new JCheckBox("Loop Replay");
        this.loopButton.setToolTipText("When checked, replay restarts after it has ended. Otherwise it is stopped.");
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gridbag.setConstraints(this.loopButton, gbc);
        configurationPanel.add(this.loopButton);
        return configurationPanel;
    }

    void apply(String archiveInstance, long start, long stop, String[] packets) {
        this.archiveInstance = archiveInstance;
        this.start = start;
        this.stop = stop;
        this.startLabel.setText(TimeEncoding.toOrdinalDateTime((long)start));
        this.stopLabel.setText(TimeEncoding.toOrdinalDateTime((long)stop));
        this.instanceLabel.setText(archiveInstance);
        this.packetList.setListData((String[])packets);
        this.nameComponent.setText("Archive");
    }

    @Override
    public void activate() {
    }

    @Override
    public boolean requiresArchiveBrowser() {
        return true;
    }

    @Override
    public Yamcs.ReplayRequest getReplayRequest() {
        if (this.start < 0L) {
            YamcsMonitor.theApp.showMessage("Please specify a start date and a stop date first.");
            return null;
        }
        Yamcs.ReplayRequest.Builder rr = Yamcs.ReplayRequest.newBuilder().setEndAction(Yamcs.EndAction.STOP).setStart(this.start).setStop(this.stop).setSpeed(Yamcs.ReplaySpeed.newBuilder().setType(Yamcs.ReplaySpeed.ReplaySpeedType.AFAP).build());
        if (this.loopButton.isSelected()) {
            rr.setEndAction(Yamcs.EndAction.LOOP);
        } else {
            rr.setEndAction(Yamcs.EndAction.STOP);
        }
        Yamcs.ReplaySpeed.Builder rs = Yamcs.ReplaySpeed.newBuilder();
        if (this.speedRealtimeRadio.isSelected()) {
            rs.setType(Yamcs.ReplaySpeed.ReplaySpeedType.REALTIME);
            rs.setParam(1.0f);
        } else if (this.speedFixedRadio.isSelected()) {
            rs.setType(Yamcs.ReplaySpeed.ReplaySpeedType.FIXED_DELAY);
            rs.setParam(200.0f);
        } else {
            rs.setType(Yamcs.ReplaySpeed.ReplaySpeedType.AFAP);
        }
        rr.setSpeed(rs.build());
        ListModel<String> model = this.packetList.getModel();
        Yamcs.PacketReplayRequest.Builder prr = Yamcs.PacketReplayRequest.newBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            prr.addNameFilter(Yamcs.NamedObjectId.newBuilder().setName(model.getElementAt(i).toString()));
        }
        rr.setPacketRequest(prr);
        return rr.build();
    }
}

