/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.yamcs.protobuf.YamcsManagement;

class ClientTableModel
extends AbstractTableModel {
    private ArrayList<YamcsManagement.ClientInfo> clients = new ArrayList();
    private final String[] columnNames = new String[]{"Id", "User", "Application", "Instance", "Processor"};

    ClientTableModel() {
    }

    public void clear() {
        int len = this.clients.size();
        if (len > 0) {
            this.clients.clear();
            this.fireTableRowsDeleted(0, len - 1);
        }
    }

    public void populate(List<YamcsManagement.ClientInfo> clientsInfo) {
        int len = this.clients.size();
        if (len > 0) {
            this.clients.clear();
            this.fireTableRowsDeleted(0, len - 1);
        }
        for (YamcsManagement.ClientInfo ci : clientsInfo) {
            this.clients.add(ci);
        }
        if (this.clients.size() > 0) {
            this.fireTableRowsInserted(0, this.clients.size() - 1);
        }
    }

    public void updateClient(YamcsManagement.ClientInfo clientInfo) {
        boolean found = false;
        for (int i = 0; i < this.clients.size(); ++i) {
            YamcsManagement.ClientInfo ci = this.clients.get(i);
            if (ci.getId() != clientInfo.getId()) continue;
            this.clients.set(i, clientInfo);
            this.fireTableRowsUpdated(i, i);
            found = true;
            break;
        }
        if (!found) {
            this.clients.add(clientInfo);
            int last = this.clients.size() - 1;
            this.fireTableRowsInserted(last, last);
        }
    }

    public YamcsManagement.ClientInfo get(int index) {
        return this.clients.get(index);
    }

    public void removeClient(int id) {
        for (int i = 0; i < this.clients.size(); ++i) {
            YamcsManagement.ClientInfo ci = this.clients.get(i);
            if (ci.getId() != id) continue;
            this.clients.remove(i);
            this.fireTableRowsDeleted(i, i);
            break;
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.clients.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        YamcsManagement.ClientInfo c = this.clients.get(row);
        Object o = null;
        switch (col) {
            case 0: {
                o = c.getId();
                break;
            }
            case 1: {
                o = c.getUsername();
                break;
            }
            case 2: {
                o = c.getApplicationName();
                break;
            }
            case 3: {
                o = c.getInstance();
                break;
            }
            case 4: {
                o = c.getProcessorName();
            }
        }
        return o;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

