/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.yamcs.api.YamcsConnector;
import org.yamcs.protobuf.Commanding;
import org.yamcs.ui.CommandQueueControlClient;
import org.yamcs.ui.CommandQueueListener;
import org.yamcs.ui.yamcsmonitor.YamcsMonitor;
import org.yamcs.utils.TimeEncoding;

public class CommandQueueDisplay
extends JSplitPane
implements ActionListener,
CommandQueueListener {
    DefaultTableModel commandTableModel;
    HashMap<String, QueuesTableModel> queuesModels = new HashMap();
    TableRowSorter<QueuesTableModel> queueSorter;
    JFrame frame;
    JTable queueTable;
    JTable commandTable;
    JScrollPane queueScroll;
    QueuesTableModel currentQueuesModel;
    QueuesTableModel emptyQueuesModel;
    boolean isAdmin;
    static long oldCommandWarningTime = 60L;
    CommandQueueControlClient commandQueueControl;
    final String[] queueStateItems = new String[]{"BLOCKED", "DISABLED", "ENABLED"};
    private volatile String selectedInstance;

    public CommandQueueDisplay(YamcsConnector yconnector, boolean isAdmin) {
        super(0);
        this.isAdmin = isAdmin;
        this.commandQueueControl = new CommandQueueControlClient(yconnector);
        this.emptyQueuesModel = new QueuesTableModel(null, null);
        this.queueTable = new JTable(this.emptyQueuesModel);
        this.queueTable.getTableHeader().setReorderingAllowed(false);
        this.queueTable.setAutoCreateColumnsFromModel(false);
        JComboBox<String> combo = new JComboBox<String>(this.queueStateItems);
        combo.setEditable(false);
        this.queueTable.setRowHeight(combo.getPreferredSize().height);
        this.queueTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(combo));
        this.queueSorter = new TableRowSorter<QueuesTableModel>(this.emptyQueuesModel);
        this.queueSorter.setComparator(2, (o1, o2) -> o1.intValue() < o2.intValue() ? -1 : (o1.intValue() > o2.intValue() ? 1 : 0));
        this.queueTable.setRowSorter(this.queueSorter);
        this.queueTable.setSelectionMode(0);
        this.queueTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.queueTable.getSelectedRow();
            if (row != -1) {
                row = this.queueTable.convertRowIndexToModel(row);
                if (this.currentQueuesModel != null) {
                    this.currentQueuesModel.setQueue(row);
                }
            }
        });
        this.queueScroll = new JScrollPane(this.queueTable);
        this.queueTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.setTopComponent(this.queueScroll);
        final String[] columnToolTips = new String[]{"The queue which contains the command", "The user who submitted the command", "Command source code", "Unique id of the command"};
        final CommandRenderer cRenderer = new CommandRenderer();
        Object[] commandColumns = new String[]{"Queue", "User", "Command String", "Time"};
        this.commandTableModel = new DefaultTableModel(commandColumns, 0);
        this.commandTable = new JTable(this.commandTableModel){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                        if (index == -1) {
                            return "";
                        }
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return columnToolTips[realIndex];
                    }
                };
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return column == this.convertColumnIndexToModel(2) ? cRenderer : super.getCellRenderer(row, column);
            }
        };
        this.commandTable.setAutoResizeMode(0);
        this.commandTable.getTableHeader().setResizingAllowed(true);
        JScrollPane scroll = new JScrollPane(this.commandTable);
        this.commandTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.setBottomComponent(scroll);
        TableColumnModel model = this.commandTable.getTableHeader().getColumnModel();
        model.getColumn(0).setPreferredWidth(60);
        model.getColumn(1).setPreferredWidth(80);
        model.getColumn(2).setPreferredWidth(500);
        int newWidth = new JLabel((String)"0000-00-00T00:00:00.000").getPreferredSize().width + 20;
        model.getColumn(3).setPreferredWidth(newWidth);
        this.setResizeWeight(0.1);
        final JPopupMenu cmdPopup = new JPopupMenu();
        JMenuItem miSend = new JMenuItem("Send");
        miSend.addActionListener(this);
        miSend.setActionCommand("send");
        cmdPopup.add(miSend);
        JMenuItem miReject = new JMenuItem("Reject");
        miReject.addActionListener(this);
        miReject.setActionCommand("reject");
        cmdPopup.add(miReject);
        this.commandTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = CommandQueueDisplay.this.commandTable.rowAtPoint(e.getPoint());
                    if (row != -1 && !CommandQueueDisplay.this.commandTable.isRowSelected(row)) {
                        CommandQueueDisplay.this.commandTable.setRowSelectionInterval(row, row);
                    }
                    cmdPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.commandQueueControl.addCommandQueueListener(this);
    }

    public void addProcessor(String instance, String processorName) {
        QueuesTableModel model = new QueuesTableModel(instance, processorName);
        this.queuesModels.put(instance + "." + processorName, model);
    }

    public void removeProcessor(String instance, String processorName) {
        this.queuesModels.remove(instance + "." + processorName);
    }

    public void setProcessor(String instance, String processorName) {
        QueuesTableModel queuesTableModel = this.currentQueuesModel = processorName == null ? this.emptyQueuesModel : this.queuesModels.get(instance + "." + processorName);
        if (this.currentQueuesModel == null) {
            this.currentQueuesModel = this.emptyQueuesModel;
        }
        this.queueTable.setModel(this.currentQueuesModel);
        this.queueSorter.setModel(this.currentQueuesModel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        try {
            if (this.currentQueuesModel != null) {
                if (cmd.equals("send")) {
                    int[] rows;
                    for (int row : rows = this.commandTable.getSelectedRows()) {
                        int index;
                        String queueName = (String)this.commandTableModel.getValueAt(this.commandTable.convertRowIndexToModel(row), 0);
                        Commanding.CommandQueueEntry cqe = this.currentQueuesModel.getCommand(queueName, index = this.commandTable.convertRowIndexToModel(row));
                        if (cqe == null) continue;
                        long timeinthequeue = TimeEncoding.currentInstant() - cqe.getGenerationTime();
                        if (timeinthequeue > oldCommandWarningTime * 1000L) {
                            int res = CommandFateDialog.showDialog(this.frame, cqe.getCmdId());
                            switch (res) {
                                case -1: {
                                    return;
                                }
                                case 0: {
                                    YamcsMonitor.theApp.log("sending command with updated time: " + cqe.getSource());
                                    this.commandQueueControl.releaseCommand(cqe, true);
                                    break;
                                }
                                case 1: {
                                    YamcsMonitor.theApp.log("sending command: " + cqe);
                                    this.commandQueueControl.releaseCommand(cqe, false);
                                    break;
                                }
                                case 2: {
                                    System.out.println("rejecting command: " + cqe.getSource());
                                    this.commandQueueControl.rejectCommand(cqe);
                                }
                            }
                            continue;
                        }
                        YamcsMonitor.theApp.log("sending command: " + cqe.getSource());
                        this.commandQueueControl.releaseCommand(cqe, false);
                    }
                } else if (cmd.equals("reject")) {
                    int[] rows;
                    for (int row : rows = this.commandTable.getSelectedRows()) {
                        int index;
                        String queueName = (String)this.commandTableModel.getValueAt(this.commandTable.convertRowIndexToModel(row), 0);
                        Commanding.CommandQueueEntry cqe = this.currentQueuesModel.getCommand(queueName, index = this.commandTable.convertRowIndexToModel(row));
                        if (cqe == null) continue;
                        YamcsMonitor.theApp.log("rejecting command: " + cqe.getSource());
                        this.commandQueueControl.rejectCommand(cqe);
                    }
                }
            }
        }
        catch (Exception e) {
            YamcsMonitor.theApp.showMessage(e.getMessage());
        }
    }

    @Override
    public void log(String msg) {
        YamcsMonitor.theApp.log(msg);
    }

    @Override
    public void updateQueue(Commanding.CommandQueueInfo cqi) {
        if (!this.selectedInstance.equals(cqi.getInstance())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            QueuesTableModel model = this.queuesModels.get(cqi.getInstance() + "." + cqi.getProcessorName());
            model.updateQueue(cqi);
            if (cqi.getEntryCount() > 0) {
                for (Commanding.CommandQueueEntry cqe : cqi.getEntryList()) {
                    this.commandAdded(cqe);
                }
            }
        });
    }

    @Override
    public void commandAdded(Commanding.CommandQueueEntry cqe) {
        if (!this.selectedInstance.equals(cqe.getInstance())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            QueuesTableModel model = this.queuesModels.get(cqe.getInstance() + "." + cqe.getProcessorName());
            model.commandAdded(cqe);
        });
    }

    @Override
    public void commandRejected(Commanding.CommandQueueEntry cqe) {
        if (!this.selectedInstance.equals(cqe.getInstance())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            QueuesTableModel model = this.queuesModels.get(cqe.getInstance() + "." + cqe.getProcessorName());
            model.removeCommandFromQueue(cqe);
        });
    }

    @Override
    public void commandSent(Commanding.CommandQueueEntry cqe) {
        if (!this.selectedInstance.equals(cqe.getInstance())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            QueuesTableModel model = this.queuesModels.get(cqe.getInstance() + "." + cqe.getProcessorName());
            model.removeCommandFromQueue(cqe);
        });
    }

    public void setSelectedInstance(String newInstance) {
        this.queuesModels.clear();
        this.selectedInstance = newInstance;
    }

    static class CommandFateDialog
    extends JDialog
    implements ActionListener {
        int result;
        static CommandFateDialog cfd1 = null;
        static CommandFateDialog cfd2 = null;
        JRadioButton[] radioButtons;
        JLabel messageLabel;

        public static int showDialog(Frame aFrame, Commanding.CommandId cmdId) {
            if (cfd1 == null) {
                cfd1 = new CommandFateDialog(aFrame, 1);
            }
            CommandFateDialog.cfd1.messageLabel.setText("The command '" + cmdId.getSequenceNumber() + "' is older than " + oldCommandWarningTime + " seconds");
            cfd1.setLocationRelativeTo(aFrame);
            cfd1.setVisible(true);
            return CommandFateDialog.cfd1.result;
        }

        public static int showDialog2(Frame aFrame) {
            if (cfd2 == null) {
                cfd2 = new CommandFateDialog(aFrame, 2);
            }
            cfd2.setLocationRelativeTo(aFrame);
            cfd2.setVisible(true);
            return CommandFateDialog.cfd2.result;
        }

        public CommandFateDialog(Frame aFrame, int type) {
            super(aFrame, true);
            if (type == 1) {
                this.setTitle("Command older than " + oldCommandWarningTime + " seconds");
            } else {
                this.setTitle("Command(s) older than " + oldCommandWarningTime + " seconds");
            }
            JPanel box = new JPanel();
            this.messageLabel = type == 1 ? new JLabel("The command 2009/208 17:07:17.845@255.255.255.255/123456 is older than " + oldCommandWarningTime + " seconds") : new JLabel("Enabling the queue would cause some commands older than " + oldCommandWarningTime + " seconds to be sent.");
            box.setLayout(new BoxLayout(box, 3));
            box.add(this.messageLabel);
            ButtonGroup group = new ButtonGroup();
            if (type == 1) {
                this.radioButtons = new JRadioButton[3];
                this.radioButtons[0] = new JRadioButton("Send the command with updated generation time");
                this.radioButtons[1] = new JRadioButton("Send the command with the current (old) generation time");
                this.radioButtons[2] = new JRadioButton("Reject the command");
            } else {
                this.radioButtons = new JRadioButton[2];
                this.radioButtons[0] = new JRadioButton("Send all the commands with updated generation time");
                this.radioButtons[1] = new JRadioButton("Send all the command with the current (old) generation time");
            }
            for (int i = 0; i < this.radioButtons.length; ++i) {
                box.add(this.radioButtons[i]);
                group.add(this.radioButtons[i]);
            }
            group.setSelected(this.radioButtons[0].getModel(), true);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this);
            JButton okButton = new JButton("OK");
            okButton.setActionCommand("OK");
            okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(okButton);
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 2));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(okButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createHorizontalGlue());
            Container contentPane = this.getContentPane();
            contentPane.add((Component)box, "Before");
            contentPane.add((Component)buttonPane, "Last");
            this.pack();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    result = -1;
                    this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getActionCommand().equalsIgnoreCase("OK")) {
                this.result = -1;
                for (int i = 0; i < this.radioButtons.length; ++i) {
                    if (!this.radioButtons[i].isSelected()) continue;
                    this.result = i;
                    break;
                }
                this.setVisible(false);
            } else if (ev.getActionCommand().equalsIgnoreCase("Cancel")) {
                this.result = -1;
                this.setVisible(false);
            }
        }
    }

    class CommandRenderer
    extends JTextArea
    implements TableCellRenderer {
        CommandRenderer() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint() {
        }

        public void firePropertyChange() {
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value.toString());
            int height_wanted = (int)this.getPreferredSize().getHeight();
            table.setRowHeight(row, height_wanted);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class QueuesTableModel
    extends AbstractTableModel {
        List<Commanding.CommandQueueInfo> queues = new ArrayList<Commanding.CommandQueueInfo>(3);
        Map<String, ArrayList<Commanding.CommandQueueEntry>> commands = new HashMap<String, ArrayList<Commanding.CommandQueueEntry>>();
        String instance;
        String processor;
        final String[] queueColumns = new String[]{"Queue", "State", "Commands"};

        public QueuesTableModel(String instance, String processor) {
            this.instance = instance;
            this.processor = processor;
        }

        void updateQueue(Commanding.CommandQueueInfo cqi) {
            boolean found = false;
            for (int i = 0; i < this.queues.size(); ++i) {
                Commanding.CommandQueueInfo q = this.queues.get(i);
                if (!q.getName().equals(cqi.getName())) continue;
                this.queues.set(i, cqi);
                found = true;
                this.fireTableRowsUpdated(i, i);
                break;
            }
            if (!found) {
                this.queues.add(cqi);
                this.fireTableRowsInserted(this.queues.size(), this.queues.size());
            }
        }

        void commandAdded(Commanding.CommandQueueEntry cqe) {
            ArrayList<Object> cmds = this.commands.get(cqe.getQueueName());
            if (cmds == null) {
                cmds = new ArrayList();
                this.commands.put(cqe.getQueueName(), cmds);
            }
            cmds.add(cqe);
            this.reloadCommandsTable();
        }

        void removeCommandFromQueue(Commanding.CommandQueueEntry cqe) {
            ArrayList<Commanding.CommandQueueEntry> cmds = this.commands.get(cqe.getQueueName());
            if (cmds == null) {
                return;
            }
            for (int i = 0; i < cmds.size(); ++i) {
                if (!cmds.get(i).getCmdId().equals((Object)cqe.getCmdId())) continue;
                cmds.remove(i);
                this.reloadCommandsTable();
                break;
            }
        }

        void setQueue(int index) {
            CommandQueueDisplay.this.commandTableModel.setRowCount(0);
            Commanding.CommandQueueInfo q = this.queues.get(index);
            ArrayList<Commanding.CommandQueueEntry> cmds = this.commands.get(q.getName());
            if (cmds == null) {
                return;
            }
            for (Commanding.CommandQueueEntry cqe : cmds) {
                Object[] r = new Object[]{q.getName(), cqe.getUsername(), cqe.getSource(), TimeEncoding.toString((long)cqe.getGenerationTime())};
                CommandQueueDisplay.this.commandTableModel.addRow(r);
            }
        }

        void reloadCommandsTable() {
            int row;
            if (this == CommandQueueDisplay.this.currentQueuesModel && (row = CommandQueueDisplay.this.queueTable.convertRowIndexToModel(CommandQueueDisplay.this.queueTable.getSelectedRow())) >= 0) {
                this.setQueue(row);
            }
        }

        Commanding.CommandQueueEntry getCommand(String queueName, int index) {
            ArrayList<Commanding.CommandQueueEntry> cmds = this.commands.get(queueName);
            if (cmds == null) {
                return null;
            }
            return cmds.get(index);
        }

        @Override
        public String getColumnName(int col) {
            return this.queueColumns[col];
        }

        @Override
        public int getRowCount() {
            return this.queues.size();
        }

        @Override
        public int getColumnCount() {
            return this.queueColumns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Commanding.CommandQueueInfo q = this.queues.get(row);
            Object o = null;
            switch (col) {
                case 0: {
                    o = q.getName();
                    break;
                }
                case 1: {
                    o = q.getState().toString();
                    break;
                }
                case 2: {
                    ArrayList<Commanding.CommandQueueEntry> cmds = this.commands.get(q.getName());
                    o = cmds == null ? Integer.valueOf(0) : Integer.valueOf(cmds.size());
                }
            }
            return o;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            try {
                Commanding.CommandQueueInfo q = this.queues.get(row);
                if (value.equals(CommandQueueDisplay.this.queueStateItems[0])) {
                    CommandQueueDisplay.this.commandQueueControl.setQueueState(Commanding.CommandQueueInfo.newBuilder((Commanding.CommandQueueInfo)q).setState(Commanding.QueueState.BLOCKED).build(), false);
                } else if (value.equals(CommandQueueDisplay.this.queueStateItems[1])) {
                    CommandQueueDisplay.this.commandQueueControl.setQueueState(Commanding.CommandQueueInfo.newBuilder((Commanding.CommandQueueInfo)q).setState(Commanding.QueueState.DISABLED).build(), false);
                } else if (value.equals(CommandQueueDisplay.this.queueStateItems[2])) {
                    boolean oldcommandsfound = false;
                    ArrayList<Commanding.CommandQueueEntry> cmds = this.commands.get(q.getName());
                    if (cmds != null) {
                        for (Commanding.CommandQueueEntry cqe : cmds) {
                            if (TimeEncoding.currentInstant() - cqe.getGenerationTime() <= oldCommandWarningTime * 1000L) continue;
                            oldcommandsfound = true;
                            break;
                        }
                    }
                    if (oldcommandsfound) {
                        int result = CommandFateDialog.showDialog2(CommandQueueDisplay.this.frame);
                        switch (result) {
                            case -1: {
                                return;
                            }
                            case 0: {
                                CommandQueueDisplay.this.commandQueueControl.setQueueState(Commanding.CommandQueueInfo.newBuilder((Commanding.CommandQueueInfo)q).setState(Commanding.QueueState.ENABLED).build(), true);
                                break;
                            }
                            case 1: {
                                CommandQueueDisplay.this.commandQueueControl.setQueueState(Commanding.CommandQueueInfo.newBuilder((Commanding.CommandQueueInfo)q).setState(Commanding.QueueState.ENABLED).build(), false);
                            }
                        }
                    } else {
                        CommandQueueDisplay.this.commandQueueControl.setQueueState(Commanding.CommandQueueInfo.newBuilder((Commanding.CommandQueueInfo)q).setState(Commanding.QueueState.ENABLED).build(), false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                YamcsMonitor.theApp.showMessage(e.toString());
            }
        }
    }
}

