/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.yamcs.protobuf.YamcsManagement;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.yamcsmonitor.LinkTableModel;

public class LinkTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private LinkTableModel linkTableModel;
    private LinkCellRenderer linkInfoRenderer;
    private DataCountCellRenderer dataCountRenderer;

    public LinkTable(LinkTableModel linkTableModel) {
        super(linkTableModel);
        this.linkTableModel = linkTableModel;
        this.setSelectionMode(0);
        this.setAutoCreateRowSorter(true);
        this.linkInfoRenderer = new LinkCellRenderer(this);
        this.dataCountRenderer = new DataCountCellRenderer(this);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return "";
        }
        row = this.convertRowIndexToModel(row);
        return this.linkTableModel.getLinkInfo(row).getDetailedStatus();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 5) {
            return this.dataCountRenderer;
        }
        return this.linkInfoRenderer;
    }

    private static final class DataCountCellRenderer
    extends LinkCellRenderer {
        private static final long serialVersionUID = 1L;
        private final NumberFormat formatter = NumberFormat.getInstance(Locale.US);

        DataCountCellRenderer(LinkTable linkTable) {
            super(linkTable);
        }

        @Override
        protected void setValue(Object value) {
            Object result = value;
            if (value != null) {
                Number numberValue = (Number)value;
                result = this.formatter.format(numberValue.doubleValue());
            }
            super.setValue(result);
        }
    }

    private static class LinkCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        final Border statusBorder;
        final Border statusBorderSelected;
        final Font statusFont;
        final LinkTable linkTable;

        LinkCellRenderer(LinkTable linkTable) {
            this.linkTable = linkTable;
            this.statusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, linkTable.getBackground());
            this.statusBorderSelected = BorderFactory.createMatteBorder(1, 1, 1, 1, linkTable.getSelectionBackground());
            this.statusFont = linkTable.getFont().deriveFont((float)this.getFont().getSize() * 0.8f);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            int modelRow = this.linkTable.convertRowIndexToModel(row);
            int modelColumn = this.linkTable.convertColumnIndexToModel(column);
            YamcsManagement.LinkInfo info = this.linkTable.linkTableModel.getLinkInfo(modelRow);
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            if (info != null && modelColumn == 4) {
                this.setHorizontalAlignment(0);
                this.setFont(this.statusFont);
                this.setBorder(isSelected ? this.statusBorderSelected : this.statusBorder);
                if (info.getDisabled()) {
                    this.setBackground(UiColors.DISABLED_FAINT_BG);
                    this.setForeground(UiColors.DISABLED_FAINT_FG);
                } else if ("OK".equals(info.getStatus())) {
                    if (this.linkTable.linkTableModel.isDataCountIncreasing(modelRow)) {
                        this.setBackground(UiColors.GOOD_BRIGHT_BG);
                        this.setForeground(UiColors.GOOD_BRIGHT_FG);
                    } else {
                        this.setBackground(UiColors.GOOD_FAINT_BG);
                        this.setForeground(UiColors.GOOD_FAINT_FG);
                    }
                } else {
                    this.setBackground(UiColors.ERROR_FAINT_BG);
                    this.setForeground(UiColors.ERROR_FAINT_FG);
                }
            } else if (modelColumn == 5) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

