/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.yamcs.protobuf.YamcsManagement;

public class LinkTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Name", "Type", "Spec", "Stream", "Status", "Data Count"};
    private ArrayList<YamcsManagement.LinkInfo> links = new ArrayList();
    private ArrayList<Long> lastDataCountIncrease = new ArrayList();
    private ArrayList<ScheduledFuture<?>> schduledFutures = new ArrayList();
    ScheduledThreadPoolExecutor timer;

    public LinkTableModel(ScheduledThreadPoolExecutor timer) {
        this.timer = timer;
    }

    public void update(YamcsManagement.LinkInfo uli) {
        boolean found = false;
        for (int i = 0; i < this.links.size(); ++i) {
            YamcsManagement.LinkInfo li = this.links.get(i);
            if (!li.getName().equals(uli.getName())) continue;
            if (uli.getDataCount() > li.getDataCount()) {
                this.lastDataCountIncrease.set(i, System.currentTimeMillis());
                this.scheduleFireTableRowsUpdated(i);
            }
            this.links.set(i, uli);
            this.fireTableRowsUpdated(i, i);
            found = true;
            break;
        }
        if (!found) {
            this.links.add(uli);
            this.lastDataCountIncrease.add(0L);
            this.schduledFutures.add(null);
            this.fireTableRowsInserted(this.links.size() - 1, this.links.size() - 1);
        }
    }

    private void scheduleFireTableRowsUpdated(int row) {
        ScheduledFuture<?> future = this.schduledFutures.get(row);
        if (future != null) {
            future.cancel(false);
        }
        future = this.timer.schedule(() -> SwingUtilities.invokeLater(() -> this.fireTableRowsUpdated(row, row)), 2L, TimeUnit.SECONDS);
        this.schduledFutures.set(row, future);
    }

    public boolean isDataCountIncreasing(int index) {
        return System.currentTimeMillis() - this.lastDataCountIncrease.get(index) < 1500L;
    }

    public YamcsManagement.LinkInfo getLinkInfo(int index) {
        return index >= 0 && index < this.links.size() ? this.links.get(index) : null;
    }

    public void clear() {
        int len = this.links.size();
        if (len > 0) {
            this.links.clear();
            this.fireTableRowsDeleted(0, len - 1);
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.links.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        YamcsManagement.LinkInfo li = this.links.get(row);
        Object o = null;
        switch (col) {
            case 0: {
                o = li.getName();
                break;
            }
            case 1: {
                o = li.getType();
                break;
            }
            case 2: {
                o = li.getSpec();
                break;
            }
            case 3: {
                o = li.getStream();
                break;
            }
            case 4: {
                o = li.getStatus();
                break;
            }
            case 5: {
                o = li.getDataCount();
            }
        }
        return o;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

