/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.yamcs.protobuf.YamcsManagement;

public class ProcessorTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Name", "Type", "Creator"};
    private ArrayList<YamcsManagement.ProcessorInfo> processors = new ArrayList();

    public void removeProcessor(String instance, String name) {
        for (int i = 0; i < this.processors.size(); ++i) {
            YamcsManagement.ProcessorInfo ci = this.processors.get(i);
            if (!ci.getInstance().equals(instance) || !ci.getName().equals(name)) continue;
            this.processors.remove(i);
            this.fireTableRowsDeleted(i, i);
            break;
        }
    }

    public boolean upsertProcessor(YamcsManagement.ProcessorInfo ci) {
        boolean found = false;
        for (int i = 0; i < this.processors.size(); ++i) {
            YamcsManagement.ProcessorInfo ci1 = this.processors.get(i);
            if (!ci.getInstance().equals(ci1.getInstance()) || !ci.getName().equals(ci1.getName())) continue;
            this.processors.set(i, ci);
            this.fireTableRowsUpdated(i, i);
            found = true;
            break;
        }
        if (!found) {
            this.processors.add(ci);
            int n = this.processors.size();
            this.fireTableRowsInserted(n - 1, n - 1);
        }
        return !found;
    }

    public YamcsManagement.ProcessorInfo getProcessorInfo(int index) {
        return index >= 0 && index < this.processors.size() ? this.processors.get(index) : null;
    }

    public void clear() {
        int len = this.processors.size();
        if (len > 0) {
            this.processors.clear();
            this.fireTableRowsDeleted(0, len - 1);
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.processors.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        YamcsManagement.ProcessorInfo c = this.processors.get(row);
        String o = null;
        switch (col) {
            case 0: {
                o = c.getName();
                break;
            }
            case 1: {
                o = c.getType();
                break;
            }
            case 2: {
                o = c.getCreator();
            }
        }
        return o;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

