/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.yamcsmonitor;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;
import org.yamcs.ConfigurationException;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsException;
import org.yamcs.api.ProcessorControlClient;
import org.yamcs.api.ProcessorListener;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnectDialog;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.api.ws.WebSocketClientCallback;
import org.yamcs.protobuf.Web;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.protobuf.YamcsManagement;
import org.yamcs.ui.CommandQueueControlClient;
import org.yamcs.ui.LinkControlClient;
import org.yamcs.ui.LinkListener;
import org.yamcs.ui.YamcsArchiveIndexReceiver;
import org.yamcs.ui.archivebrowser.ArchiveIndexReceiver;
import org.yamcs.ui.yamcsmonitor.ArchiveBrowserSelector;
import org.yamcs.ui.yamcsmonitor.ArchiveProcWidget;
import org.yamcs.ui.yamcsmonitor.ClientTableModel;
import org.yamcs.ui.yamcsmonitor.CommandQueueDisplay;
import org.yamcs.ui.yamcsmonitor.LinkTable;
import org.yamcs.ui.yamcsmonitor.LinkTableModel;
import org.yamcs.ui.yamcsmonitor.ProcessorTableModel;
import org.yamcs.ui.yamcsmonitor.ProcessorWidget;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.YObjectLoader;

public class YamcsMonitor
implements WebSocketClientCallback,
ProcessorListener,
ConnectionListener,
ActionListener,
ItemListener,
LinkListener {
    ProcessorTableModel processorTableModel = new ProcessorTableModel();
    ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1);
    LinkTableModel linkTableModel = new LinkTableModel(this.timer);
    ClientTableModel clientTableModel;
    DefaultTableModel statsTableModel;
    JFrame frame;
    CommandQueueControlClient commandQueueControl;
    ArchiveBrowserSelector archiveBrowserSelector;
    private JTextArea logTextArea;
    private JMenuItem miConnect;
    private JMenuItem dcmi;
    private JLabel tmQuickStatus;
    private JLabel tcQuickStatus;
    TitledBorder processorStatusBorder;
    JTabbedPane processorStatusPanel;
    private JMenu clientsPopupMenu;
    private JTable linkTable;
    private JTable processorTable;
    private JTable clientsTable;
    private JComboBox<ProcessorWidget> processorChooser;
    private JTextField newYProcName;
    CommandQueueDisplay commandQueueDisplay;
    JScrollPane linkTableScroll;
    JScrollPane processorTableScroll;
    private Set<String> allProcessors = new HashSet<String>();
    static boolean hasAdminRights = true;
    static String initialUrl = null;
    private JButton createProcessorButton;
    private JCheckBox persistentCheckBox;
    public YamcsConnectionProperties connectionParams = null;
    private LinkControlClient linkControl;
    private ArchiveIndexReceiver indexReceiver;
    private ProcessorControlClient processorControl;
    private YamcsConnector yconnector;
    static YamcsMonitor theApp;
    HashMap<String, YamcsManagement.Statistics> processorStats = new HashMap();
    static final SimpleDateFormat format_yyyyddd;
    private JMenuItem instanceMenuItem;
    private String selectedInstance;
    boolean authenticationEnabled = false;

    public YamcsMonitor() throws ConfigurationException, IOException {
        theApp = this;
        YConfiguration config = YConfiguration.getConfiguration((String)"yamcs-ui");
        if (config.containsKey("authenticationEnabled")) {
            this.authenticationEnabled = config.getBoolean("authenticationEnabled");
        }
        this.yconnector = new YamcsConnector("YamcsMonitor");
        this.yconnector.addConnectionListener((ConnectionListener)this);
        this.processorControl = new ProcessorControlClient(this.yconnector);
        this.processorControl.setProcessorListener((ProcessorListener)this);
        this.linkControl = new LinkControlClient(this.yconnector, this);
        this.indexReceiver = new YamcsArchiveIndexReceiver(this.yconnector);
        this.archiveBrowserSelector = new ArchiveBrowserSelector(this.frame, this.yconnector, this.indexReceiver, this.processorControl, hasAdminRights);
        this.indexReceiver.setIndexListener(this.archiveBrowserSelector);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                YamcsMonitor.this.yconnector.disconnect();
            }
        });
    }

    private void createAndShowGUI() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(this.getIcon("yamcs-monitor-32.png").getImage());
        JMenuBar menuBar = new JMenuBar();
        int menuKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.miConnect = new JMenuItem("Connect to Yamcs...");
        this.miConnect.setMnemonic(67);
        this.miConnect.setAccelerator(KeyStroke.getKeyStroke(89, menuKey));
        this.miConnect.addActionListener(this);
        this.miConnect.setActionCommand("connect");
        menu.add(this.miConnect);
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Quit", 81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, menuKey));
        menuItem.getAccessibleContext().setAccessibleDescription("Quit Yamcs Monitor");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("exit");
        menu.add(menuItem);
        this.frame.setJMenuBar(menuBar);
        this.instanceMenuItem = new JMenu("Instance");
        menuBar.add(this.instanceMenuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        menuItem = new JMenuItem("About Yamcs Monitor");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("about");
        menu.add(menuItem);
        Box dsp = Box.createVerticalBox();
        dsp.add(this.buildLinkTable());
        dsp.add(this.buildProcessorTable());
        dsp.add(this.buildProcessorStatusPanel());
        Box csp = Box.createVerticalBox();
        csp.add(this.buildClientTable());
        csp.add(this.buildCreateProcessorPanel());
        this.logTextArea = new JTextArea(5, 20);
        this.logTextArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.logTextArea);
        scroll.setBorder(BorderFactory.createEtchedBorder());
        JSplitPane phoriz = new JSplitPane(1, dsp, csp);
        phoriz.setResizeWeight(0.5);
        phoriz.setContinuousLayout(true);
        JSplitPane pvert = new JSplitPane(0, phoriz, scroll);
        pvert.setResizeWeight(1.0);
        pvert.setContinuousLayout(true);
        this.frame.getContentPane().add((Component)pvert, "Center");
        this.setTitle("not connected");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private Component buildLinkTable() {
        this.linkTable = new LinkTable(this.linkTableModel);
        if (hasAdminRights) {
            final JPopupMenu popupLinks = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Enable Link");
            popupLinks.add(menuitem);
            menuitem.addActionListener(e -> {
                int selectedRow = this.linkTable.convertRowIndexToModel(this.linkTable.getSelectedRow());
                if (selectedRow < 0) {
                    this.showMessage("Please select a link first");
                    return;
                }
                YamcsManagement.LinkInfo li = this.linkTableModel.getLinkInfo(selectedRow);
                try {
                    this.linkControl.enable(li);
                }
                catch (Exception x) {
                    this.showMessage(x.toString());
                }
            });
            popupLinks.addSeparator();
            menuitem = new JMenuItem("Disable Link");
            popupLinks.add(menuitem);
            menuitem.addActionListener(e -> {
                int selectedRow = this.linkTable.convertRowIndexToModel(this.linkTable.getSelectedRow());
                if (selectedRow < 0) {
                    this.showMessage("Please select a link first");
                    return;
                }
                YamcsManagement.LinkInfo li = this.linkTableModel.getLinkInfo(selectedRow);
                try {
                    this.linkControl.disable(li);
                }
                catch (Exception x) {
                    this.showMessage(x.toString());
                }
            });
            this.linkTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int clickedRow = YamcsMonitor.this.linkTable.rowAtPoint(e.getPoint());
                        if (clickedRow != -1 && !YamcsMonitor.this.linkTable.isRowSelected(clickedRow)) {
                            YamcsMonitor.this.linkTable.setRowSelectionInterval(clickedRow, clickedRow);
                        }
                        popupLinks.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        this.linkTableScroll = new JScrollPane(this.linkTable, 22, 30);
        this.linkTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.linkTableScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Data Links"));
        return this.linkTableScroll;
    }

    private Component buildProcessorTable() {
        this.processorTable = new JTable(this.processorTableModel){};
        this.processorTable.setSelectionMode(0);
        this.processorTable.setAutoCreateRowSorter(true);
        if (hasAdminRights) {
            final JPopupMenu popupProcessors = new JPopupMenu();
            this.dcmi = new JMenuItem("Destroy Processor");
            this.dcmi.setEnabled(false);
            popupProcessors.add(this.dcmi);
            this.dcmi.addActionListener(e -> this.destroyProcessor(this.processorTable.convertRowIndexToModel(this.processorTable.getSelectedRow())));
            this.processorTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int clickedRow = YamcsMonitor.this.processorTable.rowAtPoint(e.getPoint());
                        if (clickedRow != -1 && !YamcsMonitor.this.processorTable.isRowSelected(clickedRow) && clickedRow != -1) {
                            YamcsMonitor.this.processorTable.setRowSelectionInterval(clickedRow, clickedRow);
                        }
                        popupProcessors.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        this.processorTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.processorTable.getSelectedRow();
            if (selectedRow == -1) {
                this.commandQueueDisplay.setProcessor(null, null);
                this.archiveBrowserSelector.archivePanel.replayPanel.clearReplayPanel();
                if (this.dcmi != null) {
                    this.dcmi.setEnabled(false);
                }
            } else {
                selectedRow = this.processorTable.convertRowIndexToModel(selectedRow);
                YamcsManagement.ProcessorInfo ci = this.processorTableModel.getProcessorInfo(selectedRow);
                this.commandQueueDisplay.setProcessor(ci.getInstance(), ci.getName());
                if (this.dcmi != null) {
                    this.dcmi.setEnabled(!"lounge".equalsIgnoreCase(ci.getType()));
                }
                if (ci.hasReplayRequest()) {
                    this.archiveBrowserSelector.archivePanel.replayPanel.setupReplayPanel(ci);
                } else {
                    this.archiveBrowserSelector.archivePanel.replayPanel.clearReplayPanel();
                }
            }
        });
        this.processorTableScroll = new JScrollPane(this.processorTable, 22, 30);
        this.processorTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.processorTableScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processors"));
        return this.processorTableScroll;
    }

    private Component buildProcessorStatusPanel() {
        this.processorStatusPanel = new JTabbedPane();
        this.processorStatusBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processor Information");
        this.processorStatusPanel.setBorder(this.processorStatusBorder);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        JPanel tmPanel = new JPanel(gridbag);
        this.processorStatusPanel.addTab("Telemetry", tmPanel);
        JLabel label = new JLabel("TM Link Status:");
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridwidth = 1;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        tmPanel.add(label);
        this.tmQuickStatus = new JLabel();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 2;
        gridbag.setConstraints(this.tmQuickStatus, c);
        tmPanel.add(this.tmQuickStatus);
        final String[] packetColumnToolTips = new String[]{"The Opsname of the packet.\n Unknown means that packet is not defined in the database.\nNo opsname means that the packet does not have an opsname set", "Number of times this packet has been received", "Local time of last received packet", "Generation time of last received packet", "The number of parameters contained in this packet subscribed when the packet has been last received"};
        Object[] cols = new String[]{"Packet Name", "Count", "Last Recv'd", "CCSDS Time", "Parameters"};
        this.statsTableModel = new DefaultTableModel(cols, 0);
        JTable table = new JTable(this.statsTableModel){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                        if (index == -1) {
                            return "";
                        }
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return packetColumnToolTips[realIndex];
                    }
                };
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        JScrollPane scroll = new JScrollPane(table);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        gridbag.setConstraints(scroll, c);
        tmPanel.add(scroll);
        JPanel tcPanel = new JPanel(gridbag);
        this.processorStatusPanel.addTab("Telecommands", tcPanel);
        label = new JLabel("TC Link Status:");
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        gridbag.setConstraints(label, c);
        tcPanel.add(label);
        this.tcQuickStatus = new JLabel();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 2;
        gridbag.setConstraints(this.tcQuickStatus, c);
        tcPanel.add(this.tcQuickStatus);
        this.commandQueueDisplay = new CommandQueueDisplay(this.yconnector, hasAdminRights);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        gridbag.setConstraints(this.commandQueueDisplay, c);
        tcPanel.add(this.commandQueueDisplay);
        return this.processorStatusPanel;
    }

    private Component buildClientTable() {
        this.clientTableModel = new ClientTableModel();
        this.clientsTable = new JTable(this.clientTableModel);
        TableRowSorter<ClientTableModel> clientsSorter = new TableRowSorter<ClientTableModel>(this.clientTableModel);
        clientsSorter.setComparator(0, (o1, o2) -> o1.intValue() < o2.intValue() ? -1 : (o1.intValue() > o2.intValue() ? 1 : 0));
        this.clientsTable.setRowSorter(clientsSorter);
        this.clientsTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.clientsTable.getColumnModel().getColumn(1).setMaxWidth(120);
        JScrollPane scroll = new JScrollPane(this.clientsTable, 22, 30);
        this.clientsTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Connected Clients"));
        final JPopupMenu popup = new JPopupMenu();
        this.clientsPopupMenu = new JMenu("Connect to Processor");
        popup.add(this.clientsPopupMenu);
        this.clientsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int clickedRow = YamcsMonitor.this.clientsTable.rowAtPoint(e.getPoint());
                    if (clickedRow != -1 && !YamcsMonitor.this.clientsTable.isRowSelected(clickedRow)) {
                        YamcsMonitor.this.clientsTable.setRowSelectionInterval(clickedRow, clickedRow);
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return scroll;
    }

    private Component buildCreateProcessorPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel createPanel = new JPanel(gridbag);
        createPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New Processor"));
        JLabel label = new JLabel("Name:");
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        label.setHorizontalAlignment(4);
        c.weightx = 0.0;
        c.gridwidth = 1;
        gridbag.setConstraints(label, c);
        createPanel.add(label);
        this.newYProcName = new JTextField();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.newYProcName, c);
        createPanel.add(this.newYProcName);
        label = new JLabel("Type:");
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        label.setHorizontalAlignment(4);
        c.weightx = 0.0;
        c.gridwidth = 1;
        gridbag.setConstraints(label, c);
        createPanel.add(label);
        ArrayList<ProcessorWidget> widgets = new ArrayList<ProcessorWidget>();
        try {
            YConfiguration yconf = YConfiguration.getConfiguration((String)"yamcs-ui");
            if (yconf.containsKey("processorWidgets")) {
                List ywidgets = yconf.getList("processorWidgets");
                for (Object ywidget : ywidgets) {
                    Map m = (Map)ywidget;
                    String processorType = YConfiguration.getString((Map)m, (String)"type");
                    String widgetClass = YConfiguration.getString((Map)m, (String)"class");
                    ProcessorWidget widget = (ProcessorWidget)YObjectLoader.loadObject((String)widgetClass, (Object[])new Object[]{processorType});
                    widgets.add(widget);
                }
            } else {
                widgets.add(new ArchiveProcWidget("Archive"));
            }
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        this.processorChooser = new JComboBox<ProcessorWidget>(widgets.toArray(new ProcessorWidget[widgets.size()]));
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.processorChooser, c);
        createPanel.add(this.processorChooser);
        label = new JLabel("Spec:");
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        label.setHorizontalAlignment(4);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 11;
        gridbag.setConstraints(label, c);
        createPanel.add(label);
        CardLayout specLayout = new CardLayout();
        JPanel specPanel = new JPanel(specLayout);
        specPanel.setBorder(BorderFactory.createEtchedBorder());
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 10;
        c.fill = 1;
        gridbag.setConstraints(specPanel, c);
        createPanel.add(specPanel);
        for (ProcessorWidget widget : widgets) {
            widget.setSuggestedNameComponent(this.newYProcName);
            specPanel.add((Component)widget.createConfigurationPanel(), widget.processorType);
        }
        this.processorChooser.addActionListener(ae -> {
            specLayout.show(specPanel, this.processorChooser.getSelectedItem().toString());
            ProcessorWidget widget = (ProcessorWidget)this.processorChooser.getSelectedItem();
            widget.activate();
        });
        if (hasAdminRights) {
            label = new JLabel("Persistent:");
            label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            label.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.anchor = 11;
            gridbag.setConstraints(label, c);
            createPanel.add(label);
            this.persistentCheckBox = new JCheckBox();
            c.weightx = 1.0;
            c.gridwidth = 0;
            gridbag.setConstraints(this.persistentCheckBox, c);
            createPanel.add(this.persistentCheckBox);
        }
        this.createProcessorButton = new JButton("Create");
        this.createProcessorButton.addActionListener(e -> this.createProcessor(this.clientsTable.getSelectedRows()));
        this.createProcessorButton.setEnabled(false);
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 1.0;
        c.anchor = 11;
        c.weighty = 0.0;
        gridbag.setConstraints(this.createProcessorButton, c);
        createPanel.add(this.createProcessorButton);
        this.clientsTable.getSelectionModel().addListSelectionListener(e -> this.createProcessorButton.setEnabled(this.clientsTable.getSelectedRowCount() != 0));
        return createPanel;
    }

    private void changeSelectedInstance(String newInstance) {
        this.yconnector.disconnect();
        this.selectedInstance = newInstance;
        this.connectionParams.setInstance(newInstance);
        this.yconnector.connect(this.connectionParams);
        this.setTitle("connected to " + this.yconnector.getUrl() + " " + this.selectedInstance);
        this.updateBorders();
    }

    private void updateBorders() {
        this.linkTableScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Data Links (" + this.selectedInstance + ")"));
        this.processorTableScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processors (" + this.selectedInstance + ")"));
    }

    void setTitle(String title) {
        SwingUtilities.invokeLater(() -> this.frame.setTitle("Yamcs Monitor (" + title + ")"));
    }

    void showArchiveBrowserSelector() {
        this.archiveBrowserSelector.setVisible(true);
    }

    void showMessage(String msg) {
        YamcsMonitor.showMessage(msg, this.frame);
    }

    static void showMessage(String msg, Component parent) {
        JOptionPane.showMessageDialog(parent, msg, YamcsMonitor.theApp.frame.getTitle(), -1);
    }

    protected void destroyProcessor(int selectedRow) {
        String name = (String)this.processorTableModel.getValueAt(selectedRow, 0);
        try {
            this.processorControl.destroyProcessor(name);
        }
        catch (YamcsApiException e) {
            this.showMessage("Cannot destroy processor '" + name + " because the processor was already closed");
        }
    }

    protected void createProcessor(int[] selectedRows) {
        boolean persistent = false;
        if (hasAdminRights) {
            persistent = this.persistentCheckBox.isSelected();
        }
        if (!persistent && selectedRows.length == 0) {
            this.showMessage("Please select at least one client to create the processor for.");
            return;
        }
        String name = this.newYProcName.getText();
        ProcessorWidget type = (ProcessorWidget)this.processorChooser.getSelectedItem();
        Yamcs.ReplayRequest replayRequest = type.getReplayRequest();
        if (hasAdminRights) {
            persistent = this.persistentCheckBox.isSelected();
        }
        if (replayRequest == null) {
            return;
        }
        int[] clients = new int[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            clients[i] = (Integer)this.clientTableModel.getValueAt(this.clientsTable.convertRowIndexToModel(selectedRows[i]), 0);
        }
        try {
            this.processorControl.createProcessor(this.selectedInstance, name, type.toString(), replayRequest, persistent, clients);
        }
        catch (Exception e) {
            this.showMessage(e.getMessage());
        }
    }

    public void connect(YamcsConnectionProperties ycp) {
        this.connectionParams = ycp;
        this.yconnector.connect(ycp);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("connect")) {
            YamcsConnectDialog.YamcsConnectDialogResult ycdr = YamcsConnectDialog.showDialog((JFrame)this.frame, (boolean)false, (boolean)this.authenticationEnabled);
            if (ycdr.isOk()) {
                this.logTextArea.removeAll();
                this.connect(ycdr.getConnectionProperties());
            }
        } else if (cmd.equals("exit")) {
            System.exit(0);
        } else if (cmd.equals("about")) {
            this.showAbout();
        }
    }

    public void showAbout() {
        JTextPane pane = new JTextPane();
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.setText("<center><h2>Yamcs Monitor</h2><h3>&copy; Space Applications Services</h3><h3>Version 4.5.0</h3><p>This program is used to manage processors in a Yamcs server and clients connected to it.</center>");
        pane.setPreferredSize(new Dimension(350, 180));
        JOptionPane.showMessageDialog(this.frame, pane, "Yamcs Monitor", -1, this.getIcon("yamcs-64x64.png"));
    }

    public ImageIcon getIcon(String imagename) {
        return new ImageIcon(this.getClass().getResource("/org/yamcs/images/" + imagename));
    }

    public void connecting(String corbaUrl) {
        this.log("connecting to " + corbaUrl);
    }

    public void connectionFailed(String corbaUrl, YamcsException exception) {
        this.log("connection to " + corbaUrl + " failed: " + exception);
        this.connectionParams = null;
        this.disconnected();
    }

    public void connected(String url) {
        this.log("connected to " + url);
        List instances = this.yconnector.getYamcsInstances();
        this.setTitle("connected to " + url);
        if (instances == null) {
            this.log("Failed to get instances from " + url);
            return;
        }
        if (this.selectedInstance == null) {
            this.selectedInstance = (String)instances.get(0);
        }
        this.commandQueueDisplay.setSelectedInstance(this.selectedInstance);
        SwingUtilities.invokeLater(() -> {
            this.instanceMenuItem.removeAll();
            for (String sn : instances) {
                JMenuItem mi = new JMenuItem(sn);
                this.instanceMenuItem.add(mi);
                mi.addActionListener(e -> this.changeSelectedInstance(sn));
            }
            this.buildClientListPopup();
            this.linkTableModel.clear();
            this.processorTableModel.clear();
            this.clientTableModel.clear();
            this.updateBorders();
        });
    }

    public void disconnected() {
        this.setTitle("not connected");
        this.linkTableModel.clear();
        this.processorTableModel.clear();
        this.clientTableModel.clear();
        this.updateStatistics(null);
        this.archiveBrowserSelector.archivePanel.disconnected();
    }

    public ProcessorWidget getActiveProcessorWidget() {
        return (ProcessorWidget)this.processorChooser.getSelectedItem();
    }

    @Override
    public void log(String s) {
        System.out.println("received log: " + s);
        SwingUtilities.invokeLater(() -> this.logTextArea.append(s + "\n"));
    }

    public void updateStatistics(YamcsManagement.Statistics stats) {
        if (this.statsTableModel == null) {
            return;
        }
        int selectedRow = this.processorTable.getSelectedRow();
        if (selectedRow == -1 || !this.yconnector.isConnected()) {
            this.processorStatusBorder.setTitle("Processor Statistics");
            this.processorStatusPanel.repaint();
            this.tmQuickStatus.setText("");
            this.tcQuickStatus.setText("");
            this.statsTableModel.setRowCount(0);
        } else {
            int modelSelectedRow = this.processorTable.convertRowIndexToModel(selectedRow);
            YamcsManagement.ProcessorInfo ci = this.processorTableModel.getProcessorInfo(modelSelectedRow);
            if (!ci.getInstance().equals(stats.getInstance()) || !ci.getName().equals(stats.getYProcessorName())) {
                return;
            }
            try {
                List tmstats = stats.getTmstatsList();
                this.processorStatusBorder.setTitle("Processor Information: " + ci.getName());
                this.processorStatusPanel.repaint();
                SwingUtilities.invokeLater(() -> {
                    this.statsTableModel.setRowCount(0);
                    for (YamcsManagement.TmStatistics ts : tmstats) {
                        Object[] r = new Object[]{ts.getPacketName(), ts.getReceivedPackets(), TimeEncoding.toCombinedFormat((long)ts.getLastReceived()), TimeEncoding.toCombinedFormat((long)ts.getLastPacketTime()), ts.getSubscribedParameterCount()};
                        this.statsTableModel.addRow(r);
                    }
                    if (ci.hasReplayRequest() && modelSelectedRow < this.processorTableModel.getRowCount()) {
                        this.archiveBrowserSelector.archivePanel.replayPanel.updateStatistics(stats);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMessage(e.getMessage());
            }
        }
    }

    void buildClientListPopup() {
        ActionListener ai = ae -> {
            String instanceDotName = ae.getActionCommand();
            int[] selectedRows = this.clientsTable.getSelectedRows();
            int[] clients = new int[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                YamcsManagement.ClientInfo ci = this.clientTableModel.get(this.clientsTable.convertRowIndexToModel(selectedRows[i]));
                clients[i] = ci.getId();
            }
            try {
                String[] in = instanceDotName.split("\\.", 2);
                this.processorControl.connectToProcessor(in[0], in[1], clients);
            }
            catch (Exception e) {
                this.showMessage(e.toString());
            }
        };
        this.clientsPopupMenu.removeAll();
        for (String instanceDotName : this.allProcessors) {
            JMenuItem mi = new JMenuItem(instanceDotName);
            mi.addActionListener(ai);
            mi.setActionCommand(instanceDotName);
            this.clientsPopupMenu.add(mi);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    public void processorUpdated(YamcsManagement.ProcessorInfo ci) {
        SwingUtilities.invokeLater(() -> {
            this.allProcessors.add(ci.getInstance() + "." + ci.getName());
            if (!ci.getInstance().equals(this.selectedInstance)) {
                return;
            }
            boolean added = this.processorTableModel.upsertProcessor(ci);
            this.buildClientListPopup();
            this.archiveBrowserSelector.archivePanel.replayPanel.updateProcessorInfol(ci);
            if (added && ci.getHasCommanding() && hasAdminRights) {
                this.commandQueueDisplay.addProcessor(ci.getInstance(), ci.getName());
            }
        });
    }

    public void processorClosed(YamcsManagement.ProcessorInfo pinfo) {
        SwingUtilities.invokeLater(() -> {
            this.allProcessors.remove(pinfo.getInstance() + "." + pinfo.getName());
            if (!pinfo.getInstance().equals(this.selectedInstance)) {
                return;
            }
            this.processorTableModel.removeProcessor(pinfo.getInstance(), pinfo.getName());
            this.commandQueueDisplay.removeProcessor(pinfo.getInstance(), pinfo.getName());
            this.buildClientListPopup();
        });
    }

    public void clientDisconnected(YamcsManagement.ClientInfo ci) {
        SwingUtilities.invokeLater(() -> this.clientTableModel.removeClient(ci.getId()));
    }

    public void clientUpdated(YamcsManagement.ClientInfo ci) {
        SwingUtilities.invokeLater(() -> this.clientTableModel.updateClient(ci));
    }

    @Override
    public void updateLink(YamcsManagement.LinkInfo li) {
        if (!li.getInstance().equals(this.selectedInstance)) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.linkTableModel.update(li));
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: yamcs-monitor.sh [-na] [-h] [url]");
        System.err.println("-na:\tRun in non-admin mode - hide some options which will raise no permission exception (as to not confuse the user)");
        System.err.println("url:\tConnect at startup to the given yamcs url");
        System.err.println("-h:\tShow this help text");
        System.err.println("Example:\n\t yamcs-monitor.sh http://yamcs:8090/");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException, URISyntaxException, ConfigurationException {
        for (int i = 0; i < args.length; ++i) {
            if ("-na".equals(args[i])) {
                hasAdminRights = false;
                continue;
            }
            if (args[i].equals("-h")) {
                YamcsMonitor.printUsageAndExit();
                continue;
            }
            if (args[i].startsWith("http://") || args[i].startsWith("https://")) {
                initialUrl = args[i];
                continue;
            }
            YamcsMonitor.printUsageAndExit();
        }
        YConfiguration.setup();
        YamcsMonitor app = new YamcsMonitor();
        YamcsConnectionProperties ycd = initialUrl == null ? null : YamcsConnectionProperties.parse((String)initialUrl);
        SwingUtilities.invokeLater(() -> {
            app.createAndShowGUI();
            if (ycd != null) {
                app.connect(ycd);
            }
        });
    }

    public void onMessage(Web.WebSocketServerMessage.WebSocketSubscriptionData data) {
    }

    public void popup(String text) {
    }

    static {
        format_yyyyddd = new SimpleDateFormat("yyyy/DDD HH:mm:ss");
    }
}

