/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.CustomMappingSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiExports
extends Collector {
    private static final String REQUESTS_NAME_PREFIX = "yamcs.api.requests.total";
    private static final String ERRORS_NAME_PREFIX = "yamcs.api.errors.total";
    private MetricRegistry registry;
    private SampleBuilder sampleBuilder;

    public ApiExports(MetricRegistry registry) {
        this.registry = registry;
        ArrayList<MapperConfig> mappings = new ArrayList<MapperConfig>();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("service", "${0}");
        labels.put("method", "${1}");
        MapperConfig mapping = new MapperConfig();
        mapping.setMatch("yamcs.api.requests.total.*.*");
        mapping.setName(REQUESTS_NAME_PREFIX);
        mapping.setLabels(labels);
        mappings.add(mapping);
        mapping = new MapperConfig();
        mapping.setMatch("yamcs.api.errors.total.*.*");
        mapping.setName(ERRORS_NAME_PREFIX);
        mapping.setLabels(labels);
        mappings.add(mapping);
        this.sampleBuilder = new CustomMappingSampleBuilder(mappings);
    }

    public List<Collector.MetricFamilySamples> collect() {
        HashMap<String, Collector.MetricFamilySamples> samplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        for (Map.Entry entry : this.registry.getCounters().entrySet()) {
            String dropwizardName = (String)entry.getKey();
            Counter counter = (Counter)entry.getValue();
            Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(dropwizardName, "", new ArrayList(), new ArrayList(), new Long(counter.getCount()).doubleValue());
            this.addToMap(samplesMap, new Collector.MetricFamilySamples(sample.name, Collector.Type.COUNTER, this.getHelpMessage(dropwizardName), Arrays.asList(sample)));
        }
        return new ArrayList<Collector.MetricFamilySamples>(samplesMap.values());
    }

    private String getHelpMessage(String dropwizardName) {
        if (dropwizardName.startsWith(REQUESTS_NAME_PREFIX)) {
            return "Total requests per API method";
        }
        if (dropwizardName.startsWith(ERRORS_NAME_PREFIX)) {
            return "Total errors per API method";
        }
        return "";
    }

    private void addToMap(Map<String, Collector.MetricFamilySamples> map, Collector.MetricFamilySamples newSamples) {
        if (newSamples != null) {
            Collector.MetricFamilySamples currentSamples = map.get(newSamples.name);
            if (currentSamples == null) {
                map.put(newSamples.name, newSamples);
            } else {
                ArrayList samples = new ArrayList(currentSamples.samples);
                samples.addAll(newSamples.samples);
                map.put(newSamples.name, new Collector.MetricFamilySamples(newSamples.name, currentSamples.type, currentSamples.help, samples));
            }
        }
    }
}

