/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yamcs.YamcsServer;
import org.yamcs.YamcsServerInstance;
import org.yamcs.protobuf.YamcsInstance;

public class InstancesExports
extends Collector {
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily("yamcs_instances_current", "Current amount of Yamcs instances", (double)YamcsServer.getInstances().size()));
        GaugeMetricFamily stateFamily = new GaugeMetricFamily("yamcs_instances_state", "Current count of instances by state", Collections.singletonList("state"));
        Map<YamcsInstance.InstanceState, Integer> stateCounts = this.getStateCountMap();
        for (Map.Entry<YamcsInstance.InstanceState, Integer> entry : stateCounts.entrySet()) {
            stateFamily.addMetric(Collections.singletonList(entry.getKey().toString()), (double)entry.getValue().intValue());
        }
        sampleFamilies.add((Collector.MetricFamilySamples)stateFamily);
        return sampleFamilies;
    }

    private Map<YamcsInstance.InstanceState, Integer> getStateCountMap() {
        HashMap<YamcsInstance.InstanceState, Integer> counts = new HashMap<YamcsInstance.InstanceState, Integer>();
        for (YamcsInstance.InstanceState state : YamcsInstance.InstanceState.values()) {
            counts.put(state, 0);
        }
        for (YamcsServerInstance instance : YamcsServer.getInstances()) {
            YamcsInstance.InstanceState state = instance.state();
            counts.put(state, (Integer)counts.get(state) + 1);
        }
        return counts;
    }
}

