/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.yamcs.YamcsServer;
import org.yamcs.YamcsServerInstance;
import org.yamcs.protobuf.LinkInfo;

public class LinkExports
extends Collector {
    private static final List<String> LINK_LABELS = Arrays.asList("yamcs_instance", "link");

    public List<Collector.MetricFamilySamples> collect() {
        CounterMetricFamily inCounters = new CounterMetricFamily("yamcs_links_in_total", "Number of received items since Yamcs has started (e.g. packets)", LINK_LABELS);
        CounterMetricFamily outCounters = new CounterMetricFamily("yamcs_links_out_total", "Number of sent items since Yamcs has started (e.g. telecommand packets)", LINK_LABELS);
        for (YamcsServerInstance instance : YamcsServer.getInstances()) {
            for (LinkInfo link : instance.getLinkManager().getLinkInfo()) {
                List<String> labelValues = Arrays.asList(link.getInstance(), link.getName());
                inCounters.addMetric(labelValues, (double)link.getDataInCount());
                outCounters.addMetric(labelValues, (double)link.getDataOutCount());
            }
        }
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add((Collector.MetricFamilySamples)inCounters);
        sampleFamilies.add((Collector.MetricFamilySamples)outCounters);
        return sampleFamilies;
    }
}

