/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.yamcs.Processor;
import org.yamcs.YamcsServer;
import org.yamcs.YamcsServerInstance;
import org.yamcs.management.ManagementGpbHelper;
import org.yamcs.protobuf.Statistics;
import org.yamcs.protobuf.TmStatistics;
import org.yamcs.xtceproc.ProcessingStatistics;

public class ProcessorExports
extends Collector {
    private static final List<String> PACKET_LABELS = Arrays.asList("yamcs_instance", "processor", "packet");

    public List<Collector.MetricFamilySamples> collect() {
        CounterMetricFamily receivedPackets = new CounterMetricFamily("yamcs_processor_receive_packets_total", "Processed packets since Yamcs has started", PACKET_LABELS);
        for (YamcsServerInstance instance : YamcsServer.getInstances()) {
            for (Processor processor : instance.getProcessors()) {
                if (!processor.isPersistent()) continue;
                ProcessingStatistics ps = processor.getTmProcessor().getStatistics();
                Statistics stats = ManagementGpbHelper.buildStats((Processor)processor, (List)ps.snapshot());
                for (TmStatistics packetStats : stats.getTmstatsList()) {
                    List<String> labelValues = Arrays.asList(processor.getInstance(), processor.getName(), packetStats.getPacketName());
                    receivedPackets.addMetric(labelValues, (double)packetStats.getReceivedPackets());
                }
            }
        }
        ArrayList<Collector.MetricFamilySamples> sampleFamilies = new ArrayList<Collector.MetricFamilySamples>();
        sampleFamilies.add((Collector.MetricFamilySamples)receivedPackets);
        return sampleFamilies;
    }
}

