/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import com.google.protobuf.ByteString;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import org.yamcs.api.HttpBody;
import org.yamcs.api.Observer;
import org.yamcs.http.Context;
import org.yamcs.prometheus.PrometheusPlugin;
import org.yamcs.prometheus.api.AbstractPrometheusApi;
import org.yamcs.prometheus.api.GetMetricsRequest;

public class PrometheusApi
extends AbstractPrometheusApi<Context> {
    private CollectorRegistry registry;

    public PrometheusApi(CollectorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void getMetrics(Context ctx, GetMetricsRequest request, Observer<HttpBody> observer) {
        ctx.checkSystemPrivilege(PrometheusPlugin.PRIV_GET_METRICS);
        HashSet names = new HashSet(request.getNameList());
        try (ByteString.Output out = ByteString.newOutput();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out);){
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.filteredMetricFamilySamples(names));
            ((Writer)writer).close();
            HttpBody body = HttpBody.newBuilder().setContentType("text/plain; version=0.0.4; charset=utf-8").setData(out.toByteString()).build();
            observer.complete((Object)body);
        }
        catch (IOException e) {
            observer.completeExceptionally((Throwable)e);
        }
    }
}

