/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.yamcs.Plugin;
import org.yamcs.PluginException;
import org.yamcs.Spec;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.api.Api;
import org.yamcs.http.Handler;
import org.yamcs.http.HttpRequestHandler;
import org.yamcs.http.HttpServer;
import org.yamcs.logging.Log;
import org.yamcs.prometheus.ApiExports;
import org.yamcs.prometheus.InstancesExports;
import org.yamcs.prometheus.LinkExports;
import org.yamcs.prometheus.ProcessorExports;
import org.yamcs.prometheus.PrometheusApi;
import org.yamcs.prometheus.YamcsInfoExports;
import org.yamcs.security.SystemPrivilege;

public class PrometheusPlugin
implements Plugin {
    public static final SystemPrivilege PRIV_GET_METRICS = new SystemPrivilege("Prometheus.GetMetrics");
    private static final Log log = new Log(PrometheusPlugin.class);
    private YamcsServer yamcs = YamcsServer.getServer();

    public PrometheusPlugin() {
        Spec spec = new Spec();
        spec.addOption("jvm", Spec.OptionType.BOOLEAN).withDefault((Object)Boolean.TRUE);
    }

    public void onLoad(YConfiguration config) throws PluginException {
        this.yamcs.getSecurityStore().addSystemPrivilege(PRIV_GET_METRICS);
        CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        if (config.getBoolean("jvm")) {
            DefaultExports.register((CollectorRegistry)registry);
        }
        new YamcsInfoExports().register(registry);
        new InstancesExports().register(registry);
        new LinkExports().register(registry);
        new ProcessorExports().register(registry);
        List httpServers = this.yamcs.getGlobalServices(HttpServer.class);
        if (httpServers.isEmpty()) {
            log.warn("Can't mount metrics endpoint. Yamcs does not appear to be running an HTTP Server.");
            return;
        }
        HttpServer httpServer = (HttpServer)httpServers.get(0);
        new ApiExports(httpServer.getMetricRegistry()).register(registry);
        try (InputStream in = this.getClass().getResourceAsStream("/yamcs-prometheus.protobin");){
            httpServer.getProtobufRegistry().importDefinitions(in);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        httpServer.addApi((Api)new PrometheusApi(registry));
        RedirectHandler redirectHandler = new RedirectHandler();
        httpServer.addHandler("metrics", () -> redirectHandler);
    }

    @ChannelHandler.Sharable
    private static final class RedirectHandler
    extends Handler {
        private RedirectHandler() {
        }

        public void handle(ChannelHandlerContext ctx, FullHttpRequest req) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
            QueryStringDecoder qs = new QueryStringDecoder(req.uri());
            String location = qs.rawPath().replaceFirst("metrics", "api/prometheus/metrics");
            String q = qs.rawQuery();
            if (!q.isEmpty()) {
                location = location + "?" + q;
            }
            response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)location);
            HttpRequestHandler.sendResponse((ChannelHandlerContext)ctx, (HttpRequest)req, (HttpResponse)response);
        }
    }
}

