/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.yamcs.Plugin;
import org.yamcs.PluginManager;
import org.yamcs.PluginMetadata;
import org.yamcs.YamcsServer;
import org.yamcs.YamcsVersion;

public class YamcsInfoExports
extends Collector {
    private PluginManager pluginManager = YamcsServer.getServer().getPluginManager();

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        ArrayList<String> labelNames = new ArrayList<String>();
        labelNames.add("version");
        labelNames.add("revision");
        labelNames.add("server_id");
        ArrayList<String> labelValues = new ArrayList<String>();
        labelValues.add(YamcsVersion.VERSION);
        labelValues.add(YamcsVersion.REVISION);
        labelValues.add(YamcsServer.getServer().getServerId());
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            PluginMetadata meta = this.pluginManager.getMetadata(plugin.getClass());
            labelNames.add(Collector.sanitizeMetricName((String)meta.getName()) + "_version");
            labelValues.add(meta.getVersion());
        }
        GaugeMetricFamily serverInfo = new GaugeMetricFamily("yamcs_info", "Version info", labelNames);
        serverInfo.addMetric(labelValues, 1.0);
        mfs.add((Collector.MetricFamilySamples)serverInfo);
        return mfs;
    }
}

