/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.web;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.yamcs.CommandOption;
import org.yamcs.PluginManager;
import org.yamcs.ProcessorConfig;
import org.yamcs.ProcessorFactory;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.commanding.CommandQueue;
import org.yamcs.commanding.CommandQueueManager;
import org.yamcs.http.api.ServerApi;
import org.yamcs.http.auth.AuthHandler;
import org.yamcs.logging.Log;
import org.yamcs.management.ManagementService;
import org.yamcs.protobuf.AuthInfo;
import org.yamcs.templating.ParseException;
import org.yamcs.templating.TemplateProcessor;
import org.yamcs.utils.FileUtils;

public class WebFileDeployer {
    private static final Log log = new Log(WebFileDeployer.class);
    public static final String PATH_INDEX_TEMPLATE = "index.template.html";
    public static final String PATH_INDEX = "index.html";
    public static final String PATH_NGSW = "ngsw.json";
    public static final String PATH_WEBMANIFEST = "manifest.webmanifest";
    private Path source;
    private Path target;
    private List<Path> extraStaticRoots;
    private Map<String, Map<String, Object>> extraConfigs;
    private YConfiguration config;
    private String contextPath;

    public WebFileDeployer(String cacheKey, YConfiguration config, String contextPath, List<Path> extraStaticRoots, Map<String, Map<String, Object>> extraConfigs) throws IOException, ParseException {
        this.config = config;
        this.contextPath = contextPath;
        this.extraStaticRoots = extraStaticRoots;
        this.extraConfigs = extraConfigs;
        this.target = YamcsServer.getServer().getCacheDirectory().resolve(cacheKey);
        FileUtils.deleteRecursivelyIfExists((Path)this.target);
        Files.createDirectory(this.target, new FileAttribute[0]);
        String sourceOverride = System.getProperty("yamcs.web.staticRoot");
        if (sourceOverride != null) {
            this.source = Path.of(sourceOverride, new String[0]);
            this.source = this.source.toAbsolutePath().normalize();
        } else if (config.containsKey("staticRoot")) {
            this.source = Path.of(config.getString("staticRoot"), new String[0]);
            this.source = this.source.toAbsolutePath().normalize();
        }
        boolean deployed = false;
        if (this.source != null) {
            if (Files.exists(this.source, new LinkOption[0])) {
                log.debug("Deploying yamcs-web from {}", new Object[]{this.source});
                FileUtils.copyRecursively((Path)this.source, (Path)this.target, (CopyOption[])new CopyOption[0]);
                deployed = true;
                new Redeployer(this.source, this.target).start();
            } else {
                log.warn("Static root for yamcs-web not found at '{}'", new Object[]{this.source});
            }
        }
        if (!deployed) {
            this.deployWebsiteFromClasspath(this.target);
        }
        this.prepareWebApplication();
    }

    public Path getDirectory() {
        return this.target;
    }

    public List<Path> getExtraStaticRoots() {
        return this.extraStaticRoots;
    }

    public void setExtraSources(List<Path> extraStaticRoots, Map<String, Map<String, Object>> extraConfigs) {
        this.extraStaticRoots = extraStaticRoots;
        this.extraConfigs = extraConfigs;
        this.redeploy();
    }

    public void redeploy() {
        try {
            this.prepareWebApplication();
        }
        catch (IOException | ParseException e) {
            log.error("Failed to deploy additional static roots", e);
        }
    }

    private void deployWebsiteFromClasspath(Path target) throws IOException {
        block18: {
            try (InputStream in = this.getClass().getResourceAsStream("/static/manifest.txt");){
                if (in == null) break block18;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    String manifest = CharStreams.toString((Readable)reader);
                    String[] staticFiles = manifest.split(";");
                    log.debug("Unpacking {} webapp files", new Object[]{staticFiles.length});
                    for (String staticFile : staticFiles) {
                        try (InputStream resource = this.getClass().getResourceAsStream("/static/" + staticFile);){
                            Files.createDirectories(target.resolve(staticFile).getParent(), new FileAttribute[0]);
                            Files.copy(resource, target.resolve(staticFile), new CopyOption[0]);
                        }
                    }
                }
            }
        }
    }

    private synchronized void prepareWebApplication() throws IOException, ParseException {
        Path ngswFile;
        Path webManifestFile;
        HashMap<String, String> hashTableOverrides = new HashMap<String, String>();
        Path indexTemplateFile = this.target.resolve(PATH_INDEX_TEMPLATE);
        Path indexFile = this.target.resolve(PATH_INDEX);
        if (Files.exists(indexTemplateFile, new LinkOption[0])) {
            String content = this.renderIndex(indexTemplateFile);
            Files.writeString(indexFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            hashTableOverrides.put("/index.html", this.calculateSha1(content));
        }
        if (Files.exists(webManifestFile = this.target.resolve(PATH_WEBMANIFEST), new LinkOption[0])) {
            String content = this.renderWebManifest(webManifestFile);
            Files.writeString(webManifestFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            hashTableOverrides.put("/manifest.webmanifest", this.calculateSha1(content));
        }
        if (Files.exists(ngswFile = this.target.resolve(PATH_NGSW), new LinkOption[0])) {
            String ngswContent = this.renderNgsw(ngswFile, hashTableOverrides);
            Files.writeString(ngswFile, (CharSequence)ngswContent, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private String renderIndex(Path file) throws IOException, ParseException {
        String template = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        ArrayList cssFiles = new ArrayList();
        ArrayList jsFiles = new ArrayList();
        for (Path path : this.extraStaticRoots) {
            Stream<Path> listing = Files.list(path);
            try {
                listing.forEachOrdered(extensionFile -> {
                    String lcFilename = extensionFile.getFileName().toString().toLowerCase();
                    if (lcFilename.endsWith(".css")) {
                        cssFiles.add(extensionFile);
                    } else if (lcFilename.endsWith(".js")) {
                        jsFiles.add(extensionFile);
                    }
                });
            }
            finally {
                if (listing == null) continue;
                listing.close();
            }
        }
        StringBuilder extraHeaderHtml = new StringBuilder();
        for (Path cssFile : cssFiles) {
            extraHeaderHtml.append("<link rel=\"stylesheet\" href=\"").append(this.contextPath).append("/").append(cssFile.getFileName()).append("\">\n");
        }
        for (Path jsFile : jsFiles) {
            extraHeaderHtml.append("<script src=\"").append(this.contextPath).append("/").append(jsFile.getFileName()).append("\" type=\"module\"></script>\n");
        }
        extraHeaderHtml.append(this.config.getString("extraHeaderHTML", ""));
        template = template.replace("<!--[[ EXTRA_HEADER_HTML ]]-->", extraHeaderHtml.toString());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.config.toMap());
        if (this.config.containsKey("logo")) {
            Path logo = Path.of(this.config.getString("logo"), new String[0]);
            String filename = logo.getFileName().toString();
            hashMap.put("logo", this.contextPath + "/" + filename);
        }
        AuthInfo authInfo = AuthHandler.createAuthInfo();
        String authJson = JsonFormat.printer().print((MessageOrBuilder)authInfo);
        Map authMap = (Map)new Gson().fromJson(authJson, Map.class);
        hashMap.put("auth", authMap);
        YamcsServer yamcs = YamcsServer.getServer();
        PluginManager pluginManager = yamcs.getPluginManager();
        ArrayList<String> plugins = new ArrayList<String>();
        for (Object plugin : pluginManager.getPlugins()) {
            String pluginName = pluginManager.getMetadata(plugin.getClass()).getName();
            plugins.add(pluginName);
        }
        hashMap.put("plugins", plugins);
        ArrayList<Map> commandOptions = new ArrayList<Map>();
        for (CommandOption option : yamcs.getCommandOptions()) {
            String json = JsonFormat.printer().print((MessageOrBuilder)ServerApi.toCommandOptionInfo((CommandOption)option));
            commandOptions.add((Map)new Gson().fromJson(json, Map.class));
        }
        hashMap.put("commandOptions", commandOptions);
        hashMap.put("serverId", yamcs.getServerId());
        hashMap.put("hasTemplates", !yamcs.getInstanceTemplates().isEmpty());
        boolean commandClearanceEnabled = ProcessorFactory.getProcessorTypes().entrySet().stream().anyMatch(entry -> ((ProcessorConfig)entry.getValue()).checkCommandClearance());
        hashMap.put("commandClearanceEnabled", commandClearanceEnabled);
        TreeSet<String> queueNames = new TreeSet<String>();
        for (CommandQueueManager qmanager : ManagementService.getInstance().getCommandQueueManagers()) {
            for (CommandQueue queue : qmanager.getQueues()) {
                queueNames.add(queue.getName());
            }
        }
        hashMap.put("queueNames", queueNames);
        hashMap.put("extra", this.extraConfigs);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("contextPath", this.contextPath);
        args.put("config", hashMap);
        args.put("configJson", new Gson().toJson(hashMap));
        return TemplateProcessor.process((String)template, args);
    }

    private String renderWebManifest(Path file) throws IOException, ParseException {
        String template = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("contextPath", this.contextPath);
        return TemplateProcessor.process((String)template, args);
    }

    private String renderNgsw(Path file, Map<String, String> hashTableOverrides) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject == null) {
                throw new EOFException();
            }
            if (jsonObject.get("configVersion").getAsInt() != 1) {
                log.warn("Unexpected ngsw.json config version");
            }
            jsonObject.addProperty("index", this.contextPath + jsonObject.get("index").getAsString());
            for (JsonElement assetGroupEl : jsonObject.get("assetGroups").getAsJsonArray()) {
                JsonObject assetGroup = assetGroupEl.getAsJsonObject();
                JsonArray modifiedUrls = new JsonArray();
                for (JsonElement urlEl : assetGroup.get("urls").getAsJsonArray()) {
                    modifiedUrls.add(this.contextPath + urlEl.getAsString());
                }
                assetGroup.add("urls", (JsonElement)modifiedUrls);
            }
            for (JsonElement dataGroupEl : jsonObject.get("dataGroups").getAsJsonArray()) {
                JsonObject dataGroup = dataGroupEl.getAsJsonObject();
                JsonArray modifiedPatterns = new JsonArray();
                for (JsonElement patternEl : dataGroup.get("patterns").getAsJsonArray()) {
                    modifiedPatterns.add(Pattern.quote(this.contextPath) + patternEl.getAsString());
                }
                dataGroup.add("patterns", (JsonElement)modifiedPatterns);
            }
            JsonObject modifiedHashTable = new JsonObject();
            for (Map.Entry hashEntry : jsonObject.get("hashTable").getAsJsonObject().entrySet()) {
                String sha1 = hashTableOverrides.getOrDefault(hashEntry.getKey(), ((JsonElement)hashEntry.getValue()).getAsString());
                modifiedHashTable.addProperty(this.contextPath + (String)hashEntry.getKey(), sha1);
            }
            jsonObject.add("hashTable", (JsonElement)modifiedHashTable);
            String string = gson.toJson((JsonElement)jsonObject);
            return string;
        }
    }

    private String calculateSha1(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(content.getBytes(StandardCharsets.UTF_8));
            return String.format("%040x", new BigInteger(1, digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private class Redeployer
    extends Thread {
        private Path source;
        private Path target;

        private Redeployer(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (Files.exists(this.source, new LinkOption[0])) {
                        WatchService watchService = this.source.getFileSystem().newWatchService();
                        this.source.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                        boolean forceDeploy = false;
                        boolean loop = true;
                        while (loop) {
                            WatchKey key = watchService.take();
                            if (forceDeploy || !key.pollEvents().isEmpty()) {
                                forceDeploy = false;
                                log.debug("Redeploying yamcs-web from {}", new Object[]{this.source});
                                FileUtils.deleteContents((Path)this.target);
                                FileUtils.copyRecursively((Path)this.source, (Path)this.target, (CopyOption[])new CopyOption[0]);
                                try {
                                    WebFileDeployer.this.prepareWebApplication();
                                }
                                catch (EOFException eOFException) {
                                    // empty catch block
                                }
                            }
                            loop = key.reset();
                        }
                        boolean bl = true;
                        continue;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

