/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.web;

import com.google.gson.Gson;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.yamcs.CommandOption;
import org.yamcs.ProcessorConfig;
import org.yamcs.ProcessorFactory;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.commanding.CommandQueue;
import org.yamcs.commanding.CommandQueueManager;
import org.yamcs.http.Handler;
import org.yamcs.http.HandlerContext;
import org.yamcs.http.HttpServer;
import org.yamcs.http.InternalServerErrorException;
import org.yamcs.http.NotFoundException;
import org.yamcs.http.api.ServerApi;
import org.yamcs.http.auth.AuthHandler;
import org.yamcs.management.ManagementService;
import org.yamcs.protobuf.AuthInfo;
import org.yamcs.templating.TemplateProcessor;

@ChannelHandler.Sharable
public class IndexHandler
extends Handler {
    private YConfiguration config;
    private HttpServer httpServer;
    private Path indexFile;
    private String cachedHtml;
    private FileTime cacheTime;

    public IndexHandler(YConfiguration config, HttpServer httpServer, Path webRoot) {
        this.config = config;
        this.httpServer = httpServer;
        this.indexFile = webRoot.resolve("index.html");
    }

    public void handle(HandlerContext ctx) {
        ctx.requireGET();
        if (!Files.exists(this.indexFile, new LinkOption[0])) {
            throw new NotFoundException();
        }
        String html = null;
        try {
            html = this.getHtml();
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        ByteBuf body = ctx.createByteBuf();
        body.writeCharSequence((CharSequence)html, StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, body);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-store, must-revalidate");
        ctx.sendResponse((HttpResponse)response);
    }

    private synchronized String getHtml() throws IOException {
        FileTime lastModified = Files.getLastModifiedTime(this.indexFile, new LinkOption[0]);
        if (!lastModified.equals(this.cacheTime)) {
            this.cachedHtml = this.processTemplate();
            this.cacheTime = lastModified;
        }
        return this.cachedHtml;
    }

    private String processTemplate() throws IOException {
        String template = new String(Files.readAllBytes(this.indexFile), StandardCharsets.UTF_8);
        HashMap<String, Object> webConfig = new HashMap<String, Object>(this.config.toMap());
        AuthInfo authInfo = AuthHandler.createAuthInfo();
        String authJson = JsonFormat.printer().print((MessageOrBuilder)authInfo);
        Map authMap = (Map)new Gson().fromJson(authJson, Map.class);
        webConfig.put("auth", authMap);
        YamcsServer yamcs = YamcsServer.getServer();
        ArrayList<Map> commandOptions = new ArrayList<Map>();
        for (CommandOption option : yamcs.getCommandOptions()) {
            String json = JsonFormat.printer().print((MessageOrBuilder)ServerApi.toCommandOptionInfo((CommandOption)option));
            commandOptions.add((Map)new Gson().fromJson(json, Map.class));
        }
        webConfig.put("commandOptions", commandOptions);
        webConfig.put("serverId", yamcs.getServerId());
        webConfig.put("hasTemplates", !yamcs.getInstanceTemplates().isEmpty());
        boolean commandClearanceEnabled = ProcessorFactory.getProcessorTypes().entrySet().stream().anyMatch(entry -> ((ProcessorConfig)entry.getValue()).checkCommandClearance());
        webConfig.put("commandClearanceEnabled", commandClearanceEnabled);
        TreeSet<String> queueNames = new TreeSet<String>();
        for (CommandQueueManager qmanager : ManagementService.getInstance().getCommandQueueManagers()) {
            for (CommandQueue queue : qmanager.getQueues()) {
                queueNames.add(queue.getName());
            }
        }
        webConfig.put("queueNames", queueNames);
        HashMap<String, Object> args = new HashMap<String, Object>(4);
        args.put("contextPath", this.httpServer.getContextPath());
        args.put("config", webConfig);
        args.put("configJson", new Gson().toJson(webConfig));
        return TemplateProcessor.process((String)template, args);
    }
}

