/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.web;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.yamcs.Plugin;
import org.yamcs.PluginException;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.http.Binding;
import org.yamcs.http.HttpServer;
import org.yamcs.logging.Log;
import org.yamcs.utils.FileUtils;
import org.yamcs.web.IndexHandler;
import org.yamcs.yarch.Bucket;
import org.yamcs.yarch.YarchDatabase;
import org.yamcs.yarch.YarchDatabaseInstance;

public class WebPlugin
implements Plugin {
    private Log log = new Log(this.getClass());

    public void onLoad(YConfiguration config) throws PluginException {
        Path staticRoot;
        String displayBucketName = config.getString("displayBucket");
        this.createBucketIfNotExists(displayBucketName);
        String stackBucketName = config.getString("stackBucket");
        this.createBucketIfNotExists(stackBucketName);
        HttpServer httpServer = (HttpServer)YamcsServer.getServer().getGlobalService(HttpServer.class);
        String staticRootOverride = System.getProperty("yamcs.web.staticRoot");
        if (staticRootOverride != null) {
            staticRoot = Paths.get(staticRootOverride, new String[0]);
            staticRoot = staticRoot.toAbsolutePath().normalize();
        } else if (config.containsKey("staticRoot")) {
            staticRoot = Paths.get(config.getString("staticRoot"), new String[0]);
            staticRoot = staticRoot.toAbsolutePath().normalize();
        } else {
            try {
                staticRoot = this.deployWebsiteFromClasspath();
            }
            catch (IOException e) {
                throw new PluginException("Could not deploy website", (Throwable)e);
            }
        }
        if (Files.exists(staticRoot, new LinkOption[0])) {
            this.log.debug("Serving yamcs-web from {}", new Object[]{staticRoot});
        } else {
            this.log.warn("Static root for yamcs-web not found at '{}'", new Object[]{staticRoot});
        }
        httpServer.addStaticRoot(staticRoot);
        IndexHandler indexHandler = new IndexHandler(config, httpServer, staticRoot);
        httpServer.addHandler("*", () -> indexHandler);
        YamcsServer.getServer().addReadyListener(() -> {
            for (Binding binding : httpServer.getBindings()) {
                this.log.info("Website deployed at {}{}", new Object[]{binding, httpServer.getContextPath()});
            }
        });
    }

    private Bucket createBucketIfNotExists(String bucketName) throws PluginException {
        YarchDatabaseInstance yarch = YarchDatabase.getInstance((String)"_global");
        try {
            Bucket bucket = yarch.getBucket(bucketName);
            if (bucket == null) {
                bucket = yarch.createBucket(bucketName);
            }
            return bucket;
        }
        catch (IOException e) {
            throw new PluginException("Could not create '" + bucketName + "' bucket", (Throwable)e);
        }
    }

    private Path deployWebsiteFromClasspath() throws IOException {
        Path cacheDir = YamcsServer.getServer().getCacheDirectory().resolve("yamcs-web");
        FileUtils.deleteRecursivelyIfExists((Path)cacheDir);
        Files.createDirectory(cacheDir, new FileAttribute[0]);
        try (InputStream in = this.getClass().getResourceAsStream("/static/manifest.txt");){
            Path path;
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                String manifest = CharStreams.toString((Readable)reader);
                String[] staticFiles = manifest.split(";");
                this.log.debug("Unpacking {} webapp files", new Object[]{staticFiles.length});
                for (String staticFile : staticFiles) {
                    try (InputStream resource = this.getClass().getResourceAsStream("/static/" + staticFile);){
                        Files.copy(resource, cacheDir.resolve(staticFile), new CopyOption[0]);
                    }
                }
                path = cacheDir;
            }
            return path;
        }
    }
}

