/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.web;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yamcs.YConfiguration;
import org.yamcs.http.HandlerContext;
import org.yamcs.http.HttpServer;
import org.yamcs.http.InternalServerErrorException;
import org.yamcs.http.NotFoundException;
import org.yamcs.http.StaticFileHandler;

public class AngularHandler
extends StaticFileHandler {
    private static boolean PWA = false;
    private Path indexFile;
    private Path webManifestFile;
    private Path ngswFile;
    private String logo;
    private Path logoFile;

    public AngularHandler(YConfiguration config, HttpServer httpServer, Path mainDirectory, List<Path> extraStaticRoots) {
        super("", Stream.concat(Stream.of(mainDirectory), extraStaticRoots.stream()).collect(Collectors.toList()));
        this.indexFile = mainDirectory.resolve("index.html");
        this.webManifestFile = mainDirectory.resolve("manifest.webmanifest");
        this.ngswFile = mainDirectory.resolve("ngsw.json");
        if (config.containsKey("logo")) {
            this.logoFile = Path.of(config.getString("logo"), new String[0]);
            this.logo = this.logoFile.getFileName().toString();
        }
    }

    public void handle(HandlerContext ctx) {
        String filePath = this.getFilePath(ctx);
        if (this.logo != null && this.logo.equals(filePath)) {
            this.serveLogo(ctx);
            return;
        }
        switch (filePath) {
            case "manifest.webmanifest": {
                if (!PWA) {
                    throw new NotFoundException();
                }
                this.serveUncached(ctx, this.webManifestFile, "application/manifest+json");
                return;
            }
            case "ngsw.json": {
                if (!PWA) {
                    throw new NotFoundException();
                }
                this.serveUncached(ctx, this.ngswFile, "application/json");
                return;
            }
        }
        File file = this.locateFile(filePath);
        if (file != null && !filePath.isEmpty()) {
            super.handle(ctx);
            return;
        }
        this.serveUncached(ctx, this.indexFile, "text/html");
    }

    private void serveUncached(HandlerContext ctx, Path file, String contentType) {
        ctx.requireGET();
        ByteBuf body = ctx.createByteBuf();
        try (InputStream fileIn = Files.newInputStream(file, new OpenOption[0]);
             ByteBufOutputStream bufOut = new ByteBufOutputStream(body);){
            ByteStreams.copy((InputStream)fileIn, (OutputStream)bufOut);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, body);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-store, must-revalidate");
        ctx.sendResponse((HttpResponse)response);
    }

    private void serveLogo(HandlerContext ctx) {
        ctx.requireGET();
        ByteBuf body = ctx.createByteBuf();
        try (InputStream in = Files.newInputStream(this.logoFile, new OpenOption[0]);
             ByteBufOutputStream out = new ByteBufOutputStream(body);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException();
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, body);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MIME.getMimetype(this.logoFile));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=86400");
        ctx.sendResponse((HttpResponse)response);
    }
}

