/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.FloatRange;

public class AlarmRanges
implements Serializable {
    private static final long serialVersionUID = 200706052351L;
    FloatRange watchRange = null;
    FloatRange warningRange = null;
    FloatRange distressRange = null;
    FloatRange criticalRange = null;
    FloatRange severeRange = null;

    public void addWatchRange(FloatRange range) {
        this.watchRange = this.watchRange == null ? range : this.watchRange.intersectWith(range);
    }

    public void addWarningRange(FloatRange range) {
        this.warningRange = this.warningRange == null ? range : this.warningRange.intersectWith(range);
    }

    public void addDistressRange(FloatRange range) {
        this.distressRange = this.distressRange == null ? range : this.distressRange.intersectWith(range);
    }

    public void addCriticalRange(FloatRange range) {
        this.criticalRange = this.criticalRange == null ? range : this.criticalRange.intersectWith(range);
    }

    public void addSevereRange(FloatRange range) {
        this.severeRange = this.severeRange == null ? range : this.severeRange.intersectWith(range);
    }

    public void addRange(FloatRange range, AlarmLevels level) {
        switch (level) {
            case watch: {
                this.addWatchRange(range);
                break;
            }
            case warning: {
                this.addWarningRange(range);
                break;
            }
            case distress: {
                this.addDistressRange(range);
                break;
            }
            case critical: {
                this.addCriticalRange(range);
                break;
            }
            case severe: {
                this.addSevereRange(range);
                break;
            }
            default: {
                throw new RuntimeException("Level '" + (Object)((Object)level) + "' not allowed for alarm ranges");
            }
        }
    }

    public FloatRange getWatchRange() {
        return this.watchRange;
    }

    public FloatRange getWarningRange() {
        return this.warningRange;
    }

    public FloatRange getDistressRange() {
        return this.distressRange;
    }

    public FloatRange getCriticalRange() {
        return this.criticalRange;
    }

    public FloatRange getSevereRange() {
        return this.severeRange;
    }

    public void setWarningRange(FloatRange warningRange) {
        this.warningRange = warningRange;
    }

    public String toString() {
        return (this.watchRange != null ? " watchRange" + this.watchRange : "") + (this.warningRange != null ? " warningRange" + this.warningRange : "") + (this.distressRange != null ? " distressRange" + this.distressRange : "") + (this.criticalRange != null ? " criticalRange" + this.criticalRange : "") + (this.severeRange != null ? " severeRange" + this.severeRange : "");
    }
}

