/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.ValueEnumeration;
import org.yamcs.xtce.ValueEnumerationRange;

public class EnumeratedDataType
extends BaseDataType {
    private static final long serialVersionUID = 201002231432L;
    protected HashMap<Long, ValueEnumeration> enumeration = new HashMap();
    protected List<ValueEnumeration> enumerationList = new ArrayList<ValueEnumeration>();
    protected Vector<ValueEnumerationRange> ranges = null;
    protected String initialValue = null;

    EnumeratedDataType(String name) {
        super(name);
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public ValueEnumeration enumValue(Long key) {
        if (this.enumeration.containsKey(key)) {
            return this.enumeration.get(key);
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.isValueInRange(key)) continue;
                return new ValueEnumeration(key, range.getLabel());
            }
        }
        return null;
    }

    public ValueEnumeration enumValue(String label) {
        for (ValueEnumeration enumeration : this.enumerationList) {
            if (!enumeration.getLabel().equals(label)) continue;
            return enumeration;
        }
        return null;
    }

    public boolean hasLabel(String label) {
        for (ValueEnumeration enumeration : this.enumerationList) {
            if (!enumeration.getLabel().equals(label)) continue;
            return true;
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.getLabel().equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    public void addEnumerationValue(long value, String label) {
        ValueEnumeration valEnum = new ValueEnumeration(value, label);
        this.enumerationList.add(valEnum);
        this.enumeration.put(value, valEnum);
    }

    public void addEnumerationRange(double min, double max, boolean isMinInclusive, boolean isMaxInclusive, String label) {
        assert (min < max);
        ValueEnumerationRange range = new ValueEnumerationRange(min, max, isMinInclusive, isMaxInclusive, label);
        this.ranges.add(range);
    }

    public void addEnumerationRange(ValueEnumerationRange range) {
        if (this.ranges == null) {
            this.ranges = new Vector(2);
        }
        this.ranges.add(range);
    }

    public List<ValueEnumeration> getValueEnumerationList() {
        return Collections.unmodifiableList(this.enumerationList);
    }

    @Override
    public Object parseString(String stringValue) {
        return stringValue;
    }
}

