/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.ByteOrder;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.StringDataEncoding;

public class FloatDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 200805131551L;
    Calibrator defaultCalibrator = null;
    private Encoding encoding;
    StringDataEncoding stringEncoding = null;

    public FloatDataEncoding(int sizeInBits) {
        this(sizeInBits, ByteOrder.BIG_ENDIAN);
    }

    public FloatDataEncoding(int sizeInBits, ByteOrder byteOrder) {
        super(sizeInBits, byteOrder);
        this.encoding = Encoding.IEEE754_1985;
    }

    public FloatDataEncoding(StringDataEncoding sde) {
        super(sde.getSizeInBits());
        this.encoding = Encoding.STRING;
        this.stringEncoding = sde;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public StringDataEncoding getStringDataEncoding() {
        return this.stringEncoding;
    }

    public Calibrator getDefaultCalibrator() {
        return this.defaultCalibrator;
    }

    public void setDefaultCalibrator(Calibrator calibrator) {
        this.defaultCalibrator = calibrator;
    }

    public String toString() {
        switch (this.encoding) {
            case IEEE754_1985: {
                return "FloatDataEncoding(sizeInBits=" + this.sizeInBits + "" + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
            case STRING: {
                return "FloatDataEncoding(StringEncoding: " + this.stringEncoding + (this.defaultCalibrator == null ? "" : ", defaultCalibrator:" + this.defaultCalibrator) + ")";
            }
        }
        return "UnknownFloatEncoding(" + (Object)((Object)this.encoding) + ")";
    }

    @Override
    public Object parseString(String stringValue) {
        switch (this.encoding) {
            case IEEE754_1985: {
                if (this.sizeInBits == 32) {
                    return Float.valueOf(Float.parseFloat(stringValue));
                }
                return Double.parseDouble(stringValue);
            }
            case STRING: {
                return stringValue;
            }
        }
        throw new IllegalStateException("Unknown encoding " + (Object)((Object)this.encoding));
    }

    public static enum Encoding {
        IEEE754_1985,
        STRING;

    }
}

