/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.StringDataEncoding;

public class IntegerDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 200805131551L;
    static Logger log = LoggerFactory.getLogger((String)IntegerDataEncoding.class.getName());
    Calibrator defaultCalibrator = null;
    Encoding encoding = Encoding.unsigned;
    StringDataEncoding stringEncoding = null;

    public IntegerDataEncoding(int sizeInBits, ByteOrder byteOrder) {
        super(sizeInBits, byteOrder);
    }

    public IntegerDataEncoding(int sizeInBits) {
        super(sizeInBits, ByteOrder.BIG_ENDIAN);
    }

    public IntegerDataEncoding(String name, StringDataEncoding sde) {
        super(sde.getSizeInBits());
        this.encoding = Encoding.string;
        this.stringEncoding = sde;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public StringDataEncoding getStringEncoding() {
        return this.stringEncoding;
    }

    public Calibrator getDefaultCalibrator() {
        return this.defaultCalibrator;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public void setDefaultCalibrator(Calibrator calibrator) {
        this.defaultCalibrator = calibrator;
    }

    public String toString() {
        if (this.stringEncoding == null) {
            return "IntegerDataEncoding(sizeInBits:" + this.sizeInBits + ", encoding:" + (Object)((Object)this.encoding) + ", defaultCalibrator:" + this.defaultCalibrator + " byteOrder:" + this.byteOrder + ")";
        }
        return "IntegerDataEncoding(StringEncoding: " + this.stringEncoding + " defaultCalibrator:" + this.defaultCalibrator + " byteOrder:" + this.byteOrder + ")";
    }

    @Override
    public Object parseString(String stringValue) {
        if (this.encoding == Encoding.string) {
            return stringValue;
        }
        if (this.sizeInBits > 32) {
            return Long.decode(stringValue);
        }
        return Long.decode(stringValue).intValue();
    }

    public static enum Encoding {
        unsigned,
        twosComplement,
        onesComplement,
        signMagnitude,
        BCD,
        packedBCD,
        string;

    }
}

