/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.AlarmRanges;
import org.yamcs.xtce.FloatRange;
import org.yamcs.xtce.IntegerDataType;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.NumericAlarm;
import org.yamcs.xtce.NumericContextAlarm;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;

public class IntegerParameterType
extends IntegerDataType
implements ParameterType {
    private static final long serialVersionUID = 2L;
    List<NumericContextAlarm> contextAlarmList = null;
    NumericAlarm defaultAlarm = null;

    public IntegerParameterType(String name) {
        super(name);
    }

    public NumericAlarm createOrGetAlarm(MatchCriteria contextMatch) {
        if (contextMatch == null) {
            if (this.defaultAlarm == null) {
                this.defaultAlarm = new NumericAlarm();
            }
            return this.defaultAlarm;
        }
        NumericContextAlarm nca = this.getNumericContextAlarm(contextMatch);
        if (nca == null) {
            nca = new NumericContextAlarm();
            nca.setContextMatch(contextMatch);
            this.addContextAlarm(nca);
        }
        return nca;
    }

    private AlarmRanges getAlarmRanges(MatchCriteria contextMatch) {
        NumericAlarm alarm = this.createOrGetAlarm(contextMatch);
        return alarm.getStaticAlarmRanges();
    }

    public void setDefaultWatchAlarmRange(FloatRange watchRange) {
        this.getAlarmRanges(null).watchRange = watchRange;
    }

    public void setDefaultWarningAlarmRange(FloatRange warningRange) {
        this.getAlarmRanges(null).warningRange = warningRange;
    }

    public void setDefaultDistressAlarmRange(FloatRange distressRange) {
        this.getAlarmRanges(null).distressRange = distressRange;
    }

    public void setDefaultCriticalAlarmRange(FloatRange criticalRange) {
        this.getAlarmRanges(null).criticalRange = criticalRange;
    }

    public void setDefaultSevereAlarmRange(FloatRange severeRange) {
        this.getAlarmRanges(null).severeRange = severeRange;
    }

    public void addAlarmRange(MatchCriteria contextMatch, FloatRange range, AlarmLevels level) {
        this.getAlarmRanges(contextMatch).addRange(range, level);
    }

    public void addWatchAlarmRange(MatchCriteria contextMatch, FloatRange watchRange) {
        this.getAlarmRanges(contextMatch).addWatchRange(watchRange);
    }

    public void addWarningAlarmRange(MatchCriteria contextMatch, FloatRange warningRange) {
        this.getAlarmRanges(contextMatch).addWarningRange(warningRange);
    }

    public void addDistressAlarmRange(MatchCriteria contextMatch, FloatRange distressRange) {
        this.getAlarmRanges(contextMatch).addDistressRange(distressRange);
    }

    public void addCriticalAlarmRange(MatchCriteria contextMatch, FloatRange criticalRange) {
        this.getAlarmRanges(contextMatch).addCriticalRange(criticalRange);
    }

    public void addSevereAlarmRange(MatchCriteria contextMatch, FloatRange severeRange) {
        this.getAlarmRanges(contextMatch).addSevereRange(severeRange);
    }

    public void addContextAlarm(NumericContextAlarm nca) {
        if (this.contextAlarmList == null) {
            this.contextAlarmList = new ArrayList<NumericContextAlarm>();
        }
        this.contextAlarmList.add(nca);
    }

    public void addContextAlarms(Collection<NumericContextAlarm> ncas) {
        if (this.contextAlarmList == null) {
            this.contextAlarmList = new ArrayList<NumericContextAlarm>();
        }
        this.contextAlarmList.addAll(ncas);
    }

    public NumericAlarm getDefaultAlarm() {
        return this.defaultAlarm;
    }

    public NumericContextAlarm getNumericContextAlarm(MatchCriteria context) {
        if (this.contextAlarmList == null) {
            return null;
        }
        for (NumericContextAlarm nca : this.contextAlarmList) {
            if (!nca.getContextMatch().equals(context)) continue;
            return nca;
        }
        return null;
    }

    public List<NumericContextAlarm> getContextAlarmList() {
        return this.contextAlarmList;
    }

    public void setContextAlarmList(List<NumericContextAlarm> contextAlarmList) {
        this.contextAlarmList = contextAlarmList;
    }

    @Override
    public boolean hasAlarm() {
        return this.defaultAlarm != null || this.contextAlarmList != null && !this.contextAlarmList.isEmpty();
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.getContextAlarmList() == null) {
            return null;
        }
        HashSet<Parameter> dependentParameters = new HashSet<Parameter>();
        for (NumericContextAlarm nca : this.contextAlarmList) {
            dependentParameters.addAll(nca.getContextMatch().getDependentParameters());
        }
        return dependentParameters;
    }

    public String toString() {
        return "IntegerDataType name:" + this.name + " sizeInBits:" + this.sizeInBits + " signed:" + this.signed + " encoding:" + this.encoding + (this.defaultAlarm != null ? this.defaultAlarm : "");
    }

    @Override
    public String getTypeAsString() {
        return "integer";
    }
}

