/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.Set;
import org.slf4j.Logger;
import org.yamcs.xtce.ANDedConditions;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.Condition;
import org.yamcs.xtce.CriteriaEvaluator;
import org.yamcs.xtce.ExpressionList;
import org.yamcs.xtce.ORedConditions;
import org.yamcs.xtce.Parameter;

public interface MatchCriteria
extends Serializable {
    public Set<Parameter> getDependentParameters();

    public boolean isMet(CriteriaEvaluator var1);

    public static void printParsedMatchCriteria(Logger log, MatchCriteria criteria, String indent) {
        if (criteria instanceof Comparison) {
            log.debug(indent + criteria.toString());
        } else if (criteria instanceof ComparisonList) {
            log.debug(indent + "ComparisonList (");
            for (Comparison comparison : ((ComparisonList)criteria).comparisons) {
                log.debug(indent + "  " + comparison.toString());
            }
            log.debug(indent + ")");
        } else if (criteria instanceof Condition) {
            log.debug(indent + criteria.toString());
        } else if (criteria instanceof ANDedConditions) {
            log.debug(indent + "AND (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.debug(indent + ")");
        } else if (criteria instanceof ORedConditions) {
            log.debug(indent + "OR (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.debug(indent + ")");
        }
    }
}

